/*
 * Decompiled with CFR 0.152.
 */
package io.github.michaelboyles.s3extension;

import java.util.Objects;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.auth.credentials.WebIdentityTokenFileCredentialsProvider;

final class S3Auth {
    private S3Auth() {
        throw new UnsupportedOperationException();
    }

    public static AwsCredentialsProviderChain getAuthChain(AuthenticationInfo auth) {
        AwsCredentialsProviderChain.Builder builder = AwsCredentialsProviderChain.builder().addCredentialsProvider((AwsCredentialsProvider)SystemPropertyCredentialsProvider.create()).addCredentialsProvider((AwsCredentialsProvider)EnvironmentVariableCredentialsProvider.create()).addCredentialsProvider((AwsCredentialsProvider)WebIdentityTokenFileCredentialsProvider.create());
        if (auth != null) {
            String accessKey = Objects.requireNonNull(auth.getUserName());
            String secretKey = Objects.requireNonNull(auth.getPassword());
            builder.addCredentialsProvider(() -> AwsBasicCredentials.create((String)accessKey, (String)secretKey));
        }
        return builder.addCredentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create()).addCredentialsProvider((AwsCredentialsProvider)ContainerCredentialsProvider.builder().build()).addCredentialsProvider((AwsCredentialsProvider)InstanceProfileCredentialsProvider.builder().build()).build();
    }
}

