/*
 * Decompiled with CFR 0.152.
 */
package io.github.michaelboyles.s3extension;

import io.github.michaelboyles.s3extension.ListeningWagon;
import io.github.michaelboyles.s3extension.S3Auth;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.Optional;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;

public final class S3Wagon
extends ListeningWagon {
    private static final String NO_CACHE = "no-cache";
    private static final String CACHE_FOREVER = "public,max-age=31536000,immutable";
    private S3Client s3;

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public void connect(Repository source, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) {
        this.fireSessionOpening();
        this.setRepository(source);
        AwsCredentialsProviderChain credentials = S3Auth.getAuthChain(authenticationInfo);
        this.s3 = (S3Client)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)credentials)).build();
        this.fireSessionOpened();
        this.fireSessionLoggedIn();
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.fireGetTransferInitiated(resource, destination);
        this.fireGetTransferStarted(resource, destination);
        this._get(resource, destination);
        this.fireGetTransferCompleted(resource, destination);
    }

    private void _get(Resource resource, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(this.getBucketName()).key(this.getKey(resource.getName())).build();
            ResponseInputStream stream = this.s3.getObject(request);
            this.writeStreamToFile((InputStream)stream, resource, destination);
        }
        catch (NoSuchKeyException e) {
            throw new ResourceDoesNotExistException("Resource " + resource + " does not exist in the repository", (Throwable)e);
        }
        catch (S3Exception e) {
            if (e.statusCode() == 403) {
                throw new AuthorizationException("Bad S3 credentials", (Throwable)e);
            }
            throw new TransferFailedException("S3 transfer failed", (Throwable)e);
        }
        catch (Exception e) {
            throw new TransferFailedException("S3 transfer failed", (Throwable)e);
        }
    }

    private String getBucketName() {
        return this.getRepository().getHost();
    }

    private String getKey(String location) {
        String baseDir = this.getBaseDir();
        String path = Paths.get(baseDir + location, new String[0]).normalize().toString();
        return path.replace("\\", "/");
    }

    private String getBaseDir() {
        StringBuilder sb = new StringBuilder(this.getRepository().getBasedir());
        sb.deleteCharAt(0);
        if (sb.length() == 0) {
            return "";
        }
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        return sb.toString();
    }

    private void writeStreamToFile(InputStream objectInputStream, Resource resource, File destination) throws IOException {
        File temp = File.createTempFile(destination.getName(), ".tmp", destination.getParentFile());
        try (InputStream in = objectInputStream;
             FileOutputStream out = new FileOutputStream(temp);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, length);
                this.fireGetTransferProgress(resource, destination, buffer, length);
            }
        }
        Files.move(temp.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        HeadObjectResponse response = this.s3.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.getBucketName()).key(this.getKey(resourceName)).build());
        if (response.lastModified().isAfter(Instant.ofEpochMilli(timestamp))) {
            this._get(new Resource(resourceName), destination);
            return true;
        }
        return false;
    }

    public void put(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.firePutTransferInitiated(resource, source);
        this.firePutTransferStarted(resource, source);
        this._put(source, resource);
        this.firePutTransferCompleted(resource, source);
    }

    private void _put(File source, Resource destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (!source.exists()) {
            throw new ResourceDoesNotExistException("Source does not exist");
        }
        PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.getBucketName()).key(this.getKey(destination.getName())).acl((ObjectCannedACL)this.getAccessControlList().orElse(null)).cacheControl(destination.getName().contains("maven-metadata.xml") ? NO_CACHE : CACHE_FOREVER).build();
        try (InputStream inputStream = this.newUploadStream(source, destination);){
            RequestBody body = RequestBody.fromInputStream((InputStream)inputStream, (long)source.length());
            this.s3.putObject(putObjectRequest, body);
        }
        catch (S3Exception e) {
            if (e.statusCode() == 403) {
                throw new AuthorizationException("Bad S3 credentials", (Throwable)e);
            }
            throw new TransferFailedException("S3 transfer failed", (Throwable)e);
        }
        catch (Exception e) {
            throw new TransferFailedException("S3 transfer failed", (Throwable)e);
        }
    }

    private Optional<ObjectCannedACL> getAccessControlList() {
        return Optional.ofNullable(this.getRepository()).map(Repository::getPermissions).map(RepositoryPermissions::getFileMode).map(String::trim).map(ObjectCannedACL::fromValue);
    }

    public boolean resourceExists(String resourceName) {
        try {
            this.s3.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.getBucketName()).key(this.getKey(resourceName)).build());
            return true;
        }
        catch (NoSuchKeyException e) {
            return false;
        }
    }

    public void disconnect() {
        this.fireSessionDisconnecting();
        this.fireSessionLoggedOff();
        S3Client s3 = this.s3;
        if (s3 != null) {
            s3.close();
            this.s3 = null;
        }
        this.fireSessionDisconnected();
    }

    private InputStream newUploadStream(File source, Resource resource) throws ResourceDoesNotExistException, TransferFailedException {
        try {
            return new PutInputStream(source, resource);
        }
        catch (FileNotFoundException e) {
            throw new ResourceDoesNotExistException("Does not exist", (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Transfer failed", (Throwable)e);
        }
    }

    private class PutInputStream
    extends FileInputStream {
        private final File source;
        private final Resource resource;

        PutInputStream(File source, Resource resource) throws IOException {
            super(source);
            this.source = source;
            this.resource = resource;
        }

        @Override
        public int read() throws IOException {
            int theByte = super.read();
            S3Wagon.this.firePutTransferProgress(this.resource, this.source, new byte[]{(byte)theByte}, 1);
            return theByte;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int bytesRead = super.read(buffer, offset, length);
            S3Wagon.this.firePutTransferProgress(this.resource, this.source, buffer, bytesRead);
            return bytesRead;
        }
    }
}

