/*
 * Decompiled with CFR 0.152.
 */
package io.github.michaljonko.log4j.appender;

import io.github.michaljonko.log4j.appender.AbstractDynatraceGenericLogIngestManager;
import io.github.michaljonko.log4j.appender.DynatraceGenericLogIngestAttribute;
import io.github.michaljonko.log4j.appender.DynatraceGenericLogIngestManager;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.SerializedLayout;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.JsonUtils;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="DynatraceGenericLogIngestAppender", category="Core", elementType="appender", printObject=true)
public final class DynatraceGenericLogIngestAppender
extends AbstractAppender {
    private static final FixedDateFormat DATE_FORMAT = FixedDateFormat.create((FixedDateFormat.FixedFormat)FixedDateFormat.FixedFormat.ISO8601_PERIOD);
    private static final String PACKAGE = DynatraceGenericLogIngestAppender.class.getPackage().getName();
    private final AbstractDynatraceGenericLogIngestManager manager;
    private final StrSubstitutor strSubstitutor;
    private final Set<DynatraceGenericLogIngestAttribute> attributes;

    DynatraceGenericLogIngestAppender(String name, Layout<? extends Serializable> layout, Filter filter, StrSubstitutor strSubstitutor, boolean ignoreExceptions, Property[] properties, AbstractDynatraceGenericLogIngestManager manager) {
        super(name, filter, Objects.requireNonNull(layout, "layout is null"), ignoreExceptions, properties);
        this.manager = Objects.requireNonNull(manager, "manager is null");
        this.strSubstitutor = Objects.requireNonNull(strSubstitutor, "strSubstitutor is null");
        if (Objects.nonNull(properties) && properties.length > 0) {
            long distinctPropertyNames = Arrays.stream(properties).map(Property::getName).distinct().count();
            if (distinctPropertyNames != (long)properties.length) {
                throw new IllegalArgumentException("property with the same name defined");
            }
            this.attributes = Arrays.stream(properties).map(p -> new DynatraceGenericLogIngestAttribute(p.getName(), p.getValue(), p.isValueNeedsLookup())).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
        } else {
            this.attributes = Collections.emptySet();
        }
    }

    public void append(LogEvent event) {
        byte[] message;
        Object formattedEvent;
        if (Objects.isNull(event)) {
            return;
        }
        String loggerName = event.getLoggerName();
        if (Objects.nonNull(loggerName) && loggerName.startsWith(PACKAGE)) {
            DynatraceGenericLogIngestAppender.getStatusLogger().warn("Recursive logging from [{}] for appender [{}].", (Object)event.getLoggerName(), (Object)this.getName());
            return;
        }
        Layout layout = this.getLayout();
        if (layout instanceof SerializedLayout) {
            byte[] header = layout.getHeader();
            formattedEvent = layout.toByteArray(event);
            message = new byte[header.length + ((byte[])formattedEvent).length];
            System.arraycopy(header, 0, message, 0, header.length);
            System.arraycopy(formattedEvent, 0, message, header.length, ((byte[])formattedEvent).length);
        } else {
            message = layout.toByteArray(event);
        }
        StringBuilder jsonBuilder = new StringBuilder().append("{").append(Strings.dquote((String)"timestamp")).append(":").append(Strings.dquote((String)DATE_FORMAT.formatInstant(event.getInstant()))).append(",").append(Strings.dquote((String)"level")).append(":").append(Strings.dquote((String)event.getLevel().name())).append(",");
        formattedEvent = this.attributes.iterator();
        while (formattedEvent.hasNext()) {
            DynatraceGenericLogIngestAttribute attribute = (DynatraceGenericLogIngestAttribute)formattedEvent.next();
            String name = attribute.getName();
            String value = attribute.valueNeedsLookup() ? this.strSubstitutor.replace(event, attribute.getValue()) : attribute.getValue();
            jsonBuilder.append(Strings.dquote((String)name)).append(":\"");
            JsonUtils.quoteAsString((CharSequence)value, (StringBuilder)jsonBuilder);
            jsonBuilder.append("\",");
        }
        jsonBuilder.append(Strings.dquote((String)"message")).append(":\"");
        JsonUtils.quoteAsString((CharSequence)new String(message), (StringBuilder)jsonBuilder);
        jsonBuilder.append("\"}");
        String jsonMessage = jsonBuilder.toString();
        if (this.manager.send(jsonMessage) != AbstractDynatraceGenericLogIngestManager.Status.SUCCESS) {
            DynatraceGenericLogIngestAppender.getStatusLogger().warn("Cannot send log event {}", (Object)jsonMessage);
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        return super.stop(timeout, timeUnit) && this.manager.stop(timeout, timeUnit);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B createBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public static final class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<DynatraceGenericLogIngestAppender> {
        @PluginAttribute(value="activeGateUrl")
        @Required(message="No URL provided for ActiveGate")
        private URL activeGateUrl;
        @PluginAttribute(value="token", sensitive=true)
        private String token;
        @PluginAttribute(value="sslValidation", defaultBoolean=true)
        private boolean sslValidation;

        public URL getActiveGateUrl() {
            return this.activeGateUrl;
        }

        public B setActiveGateUrl(URL activeGateUrl) {
            this.activeGateUrl = activeGateUrl;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getToken() {
            return this.token;
        }

        public B setToken(String token) {
            this.token = token;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public boolean isSslValidation() {
            return this.sslValidation;
        }

        public B setSslValidation(boolean sslValidation) {
            this.sslValidation = sslValidation;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public DynatraceGenericLogIngestAppender build() {
            DynatraceGenericLogIngestManager.ManagerConfig managerConfig = new DynatraceGenericLogIngestManager.ManagerConfig(Objects.requireNonNull(this.getConfiguration(), "configuration is null").getLoggerContext(), this.getActiveGateUrl(), this.getToken(), this.isSslValidation());
            DynatraceGenericLogIngestManager manager = DynatraceGenericLogIngestManager.getManager(this.getName(), managerConfig);
            return new DynatraceGenericLogIngestAppender(this.getName(), (Layout<? extends Serializable>)this.getOrCreateLayout(), this.getFilter(), this.getConfiguration().getStrSubstitutor(), this.isIgnoreExceptions(), this.getPropertyArray(), manager);
        }
    }
}

