/*
 * Decompiled with CFR 0.152.
 */
package io.github.michaljonko.log4j.appender;

import io.github.michaljonko.log4j.appender.AbstractDynatraceGenericLogIngestManager;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.util.Strings;

final class DynatraceGenericLogIngestManager
extends AbstractDynatraceGenericLogIngestManager {
    private static final ManagerFactory<DynatraceGenericLogIngestManager, ManagerConfig> MANAGER_FACTORY = new DynatraceGenericLogIngestManagerFactory();
    private static final ContentType CONTENT_TYPE = ContentType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8);
    private static final String USER_AGENT = "Dynatrace Generic Log Ingest Appender";
    private final String activeGateUrl;
    private final BasicHeader authorizationTokenHeader;
    private final CloseableHttpClient httpClient;

    DynatraceGenericLogIngestManager(String name, ManagerConfig managerConfig, RequestConfig requestConfig) {
        super(Objects.requireNonNull(Objects.requireNonNull(managerConfig, "managerConfig is null").getLoggerContext(), "loggerContext is null"), Objects.requireNonNull(name, "name is null"));
        this.activeGateUrl = Objects.requireNonNull(managerConfig.getActiveGateUrl(), "activeGateUrl is null").toString();
        this.authorizationTokenHeader = new BasicHeader("Authorization", "Api-Token " + Objects.requireNonNull(managerConfig.getToken(), "token is null"));
        HttpClientBuilder httpClientBuilder = HttpClients.custom().disableAuthCaching().disableCookieManagement().setUserAgent(USER_AGENT).setDefaultRequestConfig(requestConfig);
        if (!managerConfig.isSslValidation()) {
            try {
                SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
                NoopHostnameVerifier verifier = new NoopHostnameVerifier();
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)verifier);
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
            }
            catch (Exception t) {
                this.logError("Error during appender initialization. SSL validation cannot be disabled. Default SSLConnectionSocketFactory with SSLContext validation will be used.", t);
            }
        }
        this.httpClient = httpClientBuilder.build();
    }

    DynatraceGenericLogIngestManager(String name, ManagerConfig managerConfig) {
        this(name, managerConfig, RequestConfig.custom().setConnectTimeout((int)TimeUnit.SECONDS.toMillis(30L)).setSocketTimeout((int)TimeUnit.SECONDS.toMillis(30L)).setConnectionRequestTimeout((int)TimeUnit.SECONDS.toMillis(30L)).build());
    }

    protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
        super.releaseSub(timeout, timeUnit);
        if (Objects.nonNull(this.httpClient)) {
            try {
                this.httpClient.close();
                return true;
            }
            catch (IOException e) {
                this.logError("Cannot close HttpClient", e);
            }
        }
        return false;
    }

    @Override
    protected AbstractDynatraceGenericLogIngestManager.Status send(String message) {
        boolean success;
        StatusLine statusLine;
        if (Strings.isBlank((String)message)) {
            return AbstractDynatraceGenericLogIngestManager.Status.EMPTY_MESSAGE;
        }
        HttpPost request = new HttpPost(this.activeGateUrl);
        request.setHeader((Header)this.authorizationTokenHeader);
        request.setEntity((HttpEntity)new StringEntity(message, CONTENT_TYPE));
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            statusLine = response.getStatusLine();
        }
        catch (IOException e) {
            this.logError("Cannot send log event", e);
            return AbstractDynatraceGenericLogIngestManager.Status.EXCEPTION;
        }
        int statusCode = statusLine.getStatusCode();
        boolean bl = success = statusCode == 200 || statusCode == 204;
        if (!success) {
            this.logWarn("ActiveGate rejected request.", new RejectedRequestException(statusCode, statusLine.getReasonPhrase()));
            return AbstractDynatraceGenericLogIngestManager.Status.FAILED;
        }
        return AbstractDynatraceGenericLogIngestManager.Status.SUCCESS;
    }

    static DynatraceGenericLogIngestManager getManager(String name, ManagerConfig managerConfig) {
        return (DynatraceGenericLogIngestManager)DynatraceGenericLogIngestManager.getManager((String)Objects.requireNonNull(name, "name is null"), MANAGER_FACTORY, (Object)Objects.requireNonNull(managerConfig, "managerConfig is null"));
    }

    private static final class RejectedRequestException
    extends RuntimeException {
        private RejectedRequestException(int statusCode, String reason) {
            super("statusCode=" + statusCode + " reason=" + reason, null, false, false);
        }
    }

    private static final class DynatraceGenericLogIngestManagerFactory
    implements ManagerFactory<DynatraceGenericLogIngestManager, ManagerConfig> {
        private DynatraceGenericLogIngestManagerFactory() {
        }

        public DynatraceGenericLogIngestManager createManager(String name, ManagerConfig config) {
            return new DynatraceGenericLogIngestManager(name, config);
        }
    }

    static final class ManagerConfig {
        private final LoggerContext loggerContext;
        private final URL activeGateUrl;
        private final String token;
        private final boolean sslValidation;

        ManagerConfig(LoggerContext loggerContext, URL activeGateUrl, String token, boolean sslValidation) {
            this.loggerContext = Objects.requireNonNull(loggerContext, "loggerContext is null");
            this.activeGateUrl = Objects.requireNonNull(activeGateUrl, "activeGateUrl is null");
            this.token = Objects.requireNonNull(token, "token is null");
            this.sslValidation = sslValidation;
        }

        LoggerContext getLoggerContext() {
            return this.loggerContext;
        }

        URL getActiveGateUrl() {
            return this.activeGateUrl;
        }

        String getToken() {
            return this.token;
        }

        boolean isSslValidation() {
            return this.sslValidation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManagerConfig data = (ManagerConfig)o;
            return this.sslValidation == data.sslValidation && Objects.equals(this.loggerContext, data.loggerContext) && Objects.equals(this.activeGateUrl, data.activeGateUrl) && Objects.equals(this.token, data.token);
        }

        public int hashCode() {
            return Objects.hash(this.loggerContext, this.activeGateUrl, this.token, this.sslValidation);
        }

        public String toString() {
            return new StringJoiner(", ", ManagerConfig.class.getSimpleName() + "[", "]").add("loggerContext=" + this.loggerContext).add("activeGateUrl='" + this.activeGateUrl + "'").add("token='########'").add("sslValidation=" + this.sslValidation).toString();
        }
    }
}

