/*
 * Decompiled with CFR 0.152.
 */
package io.github.michaljonko.log4j.lookup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.AbstractLookup;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="dt", category="Lookup")
public final class DynatraceLookup
extends AbstractLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Path MAGIC_FILE_PATH = Paths.get("dt_metadata_e617c525669e072eebe3d0f08212e8f2.properties", new String[0]);
    private final Map<String, String> metadata;

    public DynatraceLookup() {
        this(MAGIC_FILE_PATH);
    }

    DynatraceLookup(Path magicFilePath) {
        Map tempMetadata = Collections.emptyMap();
        try (Stream<String> linesWithPath = Files.lines(Objects.requireNonNull(magicFilePath, "magicFilePath is null"));){
            tempMetadata = linesWithPath.findFirst().map(x$0 -> Paths.get(x$0, new String[0])).map(DynatraceLookup::readMetadataFile).orElse(Collections.emptyMap());
        }
        catch (IOException e) {
            LOGGER.error("DynatraceLookup cannot read metadata (magic file {})", (Object)magicFilePath);
        }
        this.metadata = tempMetadata;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> readMetadataFile(Path path) {
        try (Stream<String> linesWithProperties = Files.lines(path);){
            Map map = linesWithProperties.filter(Strings::isNotBlank).filter(line -> !line.startsWith("=") && line.contains("=")).map(line -> line.split("=", 2)).filter(array -> ((String[])array).length == 1 || ((String[])array).length == 2).collect(Collectors.collectingAndThen(Collectors.toMap(array -> array[0], array -> ((String[])array).length == 2 ? array[1] : ""), Collections::unmodifiableMap));
            return map;
        }
        catch (IOException e) {
            LOGGER.error("DynatraceLookup cannot read metadata (metadata file {})", (Object)path);
            return Collections.emptyMap();
        }
    }

    public String lookup(LogEvent event, String key) {
        return this.metadata.getOrDefault(key, "");
    }
}

