/*
 * Decompiled with CFR 0.152.
 */
package io.github.michaljonko.log4j.lookup;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.AbstractLookup;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@Plugin(name="otel", category="Lookup")
public final class OpenTelemetryLookup
extends AbstractLookup {
    private static final Set<String> ALLOWED_KEYS = new HashSet<String>(Arrays.asList("trace_id", "span_id", "trace_flags"));
    private final Function<LogEvent, ReadOnlyStringMap> contextDataExtractor;

    public OpenTelemetryLookup() {
        this(LogEvent::getContextData);
    }

    OpenTelemetryLookup(Function<LogEvent, ReadOnlyStringMap> contextDataExtractor) {
        this.contextDataExtractor = Objects.requireNonNull(contextDataExtractor, "contextDataExtractor is null");
    }

    public String lookup(LogEvent event, String key) {
        if (Objects.nonNull(event) && ALLOWED_KEYS.contains(key) && Objects.nonNull(event.getContextData())) {
            return this.contextDataExtractor.andThen(map -> map.getValue(key)).andThen(o -> Objects.nonNull(o) ? o.toString() : null).apply(event);
        }
        return null;
    }
}

