/*
 * Decompiled with CFR 0.152.
 */
package com.github.nocatch;

import com.github.nocatch.NoCatchException;
import java.lang.reflect.Constructor;
import java.util.concurrent.Callable;

public final class NoCatch {
    private static Class<? extends RuntimeException> DEFAULT_WRAPPER_EXCEPTION = NoCatchException.class;

    private NoCatch() {
        throw new AssertionError((Object)"Not instantiatable");
    }

    public static void setDefaultWrapperException(Class<? extends RuntimeException> defaultWrapperException) {
        DEFAULT_WRAPPER_EXCEPTION = defaultWrapperException;
    }

    public static void noCatch(NoCatchRunnable runnable) {
        NoCatch.noCatch(runnable, DEFAULT_WRAPPER_EXCEPTION);
    }

    public static void noCatch(NoCatchRunnable runnable, Class<? extends RuntimeException> wrapperException) {
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw NoCatch.wrapException(e, wrapperException);
        }
    }

    private static RuntimeException wrapException(Exception exception, Class<? extends RuntimeException> wrapperException) {
        try {
            Constructor<? extends RuntimeException> constructor = wrapperException.getDeclaredConstructor(Throwable.class);
            constructor.setAccessible(true);
            throw constructor.newInstance(exception);
        }
        catch (ReflectiveOperationException e) {
            NoCatchException fallbackException = new NoCatchException("WARN: Could not wrap thrown exception using the specified wrapper (" + wrapperException.getName() + ". Your wrapper needs to have a constructor that takes a cause.", exception);
            fallbackException.addSuppressed(e);
            throw fallbackException;
        }
    }

    public static <T> T noCatch(Callable<T> callable) {
        return NoCatch.noCatch(callable, DEFAULT_WRAPPER_EXCEPTION);
    }

    public static <T> T noCatch(Callable<T> callable, Class<? extends RuntimeException> wrapperException) {
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw NoCatch.wrapException(e, wrapperException);
        }
    }

    public static interface NoCatchRunnable {
        public void run() throws Exception;
    }
}

