/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.testcontainers;

import io.github.microcks.testcontainers.MicrocksContainer;
import io.github.microcks.testcontainers.connection.AmazonServiceConnection;
import io.github.microcks.testcontainers.connection.GenericConnection;
import io.github.microcks.testcontainers.connection.KafkaConnection;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public class MicrocksAsyncMinionContainer
extends GenericContainer<MicrocksAsyncMinionContainer> {
    private static final String MICROCKS_ASYNC_MINION_FULL_IMAGE_NAME = "quay.io/microcks/microcks-uber-async-minion";
    private static final DockerImageName MICROCKS_ASYNC_MINION_IMAGE = DockerImageName.parse((String)"quay.io/microcks/microcks-uber-async-minion");
    private static final String ASYNC_PROTOCOLS_ENV_VAR = "ASYNC_PROTOCOLS";
    private static final String DESTINATION_PATTERN = "%s-%s-%s";
    public static final int MICROCKS_ASYNC_MINION_HTTP_PORT = 8081;
    private String extraProtocols = "";

    public MicrocksAsyncMinionContainer(Network network, String image, MicrocksContainer microcks) {
        this(network, DockerImageName.parse((String)image), microcks);
    }

    public MicrocksAsyncMinionContainer(Network network, DockerImageName imageName, MicrocksContainer microcks) {
        super(imageName);
        imageName.assertCompatibleWith(new DockerImageName[]{MICROCKS_ASYNC_MINION_IMAGE});
        this.withNetwork(network);
        this.withNetworkAliases(new String[]{"microcks-async-minion"});
        this.withEnv("MICROCKS_HOST_PORT", "microcks:8080");
        this.withExposedPorts(new Integer[]{8081});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Profile prod activated\\..*", (int)1));
        this.dependsOn(new Startable[]{microcks});
    }

    public MicrocksAsyncMinionContainer(Network network, DockerImageName imageName, String microcksHost) {
        super(imageName);
        imageName.assertCompatibleWith(new DockerImageName[]{MICROCKS_ASYNC_MINION_IMAGE});
        this.withNetwork(network);
        this.withNetworkAliases(new String[]{"microcks-async-minion"});
        this.withEnv("MICROCKS_HOST_PORT", microcksHost + ":" + 8080);
        this.withExposedPorts(new Integer[]{8081});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Profile prod activated\\..*", (int)1));
    }

    public MicrocksAsyncMinionContainer withKafkaConnection(KafkaConnection connection) {
        if (!this.extraProtocols.contains(",KAFKA")) {
            this.extraProtocols = this.extraProtocols + ",KAFKA";
        }
        this.withEnv(ASYNC_PROTOCOLS_ENV_VAR, this.extraProtocols);
        this.withEnv("KAFKA_BOOTSTRAP_SERVER", connection.getBootstrapServers());
        return this;
    }

    public MicrocksAsyncMinionContainer withMQTTConnection(GenericConnection connection) {
        if (!this.extraProtocols.contains(",MQTT")) {
            this.extraProtocols = this.extraProtocols + ",MQTT";
        }
        this.withEnv(ASYNC_PROTOCOLS_ENV_VAR, this.extraProtocols);
        this.withEnv("MQTT_SERVER", connection.getServer());
        this.withEnv("MQTT_USERNAME", connection.getUsername());
        this.withEnv("MQTT_PASSWORD", connection.getPassword());
        return this;
    }

    public MicrocksAsyncMinionContainer withAMQPConnection(GenericConnection connection) {
        if (!this.extraProtocols.contains(",AMQP")) {
            this.extraProtocols = this.extraProtocols + ",AMQP";
        }
        this.withEnv(ASYNC_PROTOCOLS_ENV_VAR, this.extraProtocols);
        this.withEnv("AMQP_SERVER", connection.getServer());
        this.withEnv("AMQP_USERNAME", connection.getUsername());
        this.withEnv("AMQP_PASSWORD", connection.getPassword());
        return this;
    }

    public MicrocksAsyncMinionContainer withAmazonSQSConnection(AmazonServiceConnection connection) {
        if (!this.extraProtocols.contains(",SQS")) {
            this.extraProtocols = this.extraProtocols + ",SQS";
        }
        this.withEnv(ASYNC_PROTOCOLS_ENV_VAR, this.extraProtocols);
        this.withEnv("AWS_SQS_REGION", connection.getRegion());
        this.withEnv("AWS_ACCESS_KEY_ID", connection.getAccessKey());
        this.withEnv("AWS_SECRET_ACCESS_KEY", connection.getSecretKey());
        if (connection.getEndpointOverride() != null) {
            this.withEnv("AWS_SQS_ENDPOINT", connection.getEndpointOverride());
        }
        return this;
    }

    public MicrocksAsyncMinionContainer withAmazonSNSConnection(AmazonServiceConnection connection) {
        if (!this.extraProtocols.contains(",SNS")) {
            this.extraProtocols = this.extraProtocols + ",SNS";
        }
        this.withEnv(ASYNC_PROTOCOLS_ENV_VAR, this.extraProtocols);
        this.withEnv("AWS_SNS_REGION", connection.getRegion());
        this.withEnv("AWS_ACCESS_KEY_ID", connection.getAccessKey());
        this.withEnv("AWS_SECRET_ACCESS_KEY", connection.getSecretKey());
        if (connection.getEndpointOverride() != null) {
            this.withEnv("AWS_SNS_ENDPOINT", connection.getEndpointOverride());
        }
        return this;
    }

    public String getHttpEndpoint() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(8081));
    }

    public String getWSMockEndpoint(String service, String version, String operationName) {
        if (operationName.contains(" ")) {
            operationName = operationName.split(" ")[1];
        }
        return String.format("ws://%s:%s/api/ws/%s/%s/%s", this.getHost(), this.getMappedPort(8081), service.replace(" ", "+"), version.replace(" ", "+"), operationName);
    }

    public String getKafkaMockTopic(String service, String version, String operationName) {
        if (operationName.contains(" ")) {
            operationName = operationName.split(" ")[1];
        }
        return String.format(DESTINATION_PATTERN, service.replace(" ", "").replace("-", ""), version, operationName.replace("/", "-"));
    }

    public String getMQTTMockTopic(String service, String version, String operationName) {
        if (operationName.contains(" ")) {
            operationName = operationName.split(" ")[1];
        }
        return String.format(DESTINATION_PATTERN, service.replace(" ", "").replace("-", ""), version.replace(" ", ""), operationName);
    }

    public String getAMQPMockDestination(String service, String version, String operationName) {
        if (operationName.contains(" ")) {
            operationName = operationName.split(" ")[1];
        }
        return String.format(DESTINATION_PATTERN, service.replace(" ", "").replace("-", ""), version.replace(" ", ""), operationName);
    }

    public String getAmazonSQSMockQueue(String service, String version, String operationName) {
        return this.getAmazonServiceMockDestination(service, version, operationName);
    }

    public String getAmazonSNSMockTopic(String service, String version, String operationName) {
        return this.getAmazonServiceMockDestination(service, version, operationName);
    }

    private String getAmazonServiceMockDestination(String service, String version, String operationName) {
        if (operationName.contains(" ")) {
            operationName = operationName.split(" ")[1];
        }
        return String.format(DESTINATION_PATTERN, service.replace(" ", "").replace("-", ""), version.replace(".", ""), operationName.replace("/", "-"));
    }
}

