/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.testcontainers;

import io.github.microcks.testcontainers.MicrocksAsyncMinionContainer;
import io.github.microcks.testcontainers.MicrocksContainer;
import io.github.microcks.testcontainers.connection.AmazonServiceConnection;
import io.github.microcks.testcontainers.connection.GenericConnection;
import io.github.microcks.testcontainers.connection.KafkaConnection;
import io.github.microcks.testcontainers.model.Secret;
import java.util.stream.Stream;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public class MicrocksContainersEnsemble
implements Startable {
    private final Network network;
    private GenericContainer<?> postman;
    private MicrocksAsyncMinionContainer asyncMinion;
    private final MicrocksContainer microcks;

    public MicrocksContainersEnsemble(String image) {
        this(Network.newNetwork(), image);
    }

    public MicrocksContainersEnsemble(Network network, String image) {
        this(network, DockerImageName.parse((String)image));
    }

    public MicrocksContainersEnsemble(Network network, DockerImageName image) {
        this.network = network;
        this.microcks = (MicrocksContainer)((MicrocksContainer)((MicrocksContainer)((MicrocksContainer)((MicrocksContainer)new MicrocksContainer(image).withNetwork(network)).withNetworkAliases(new String[]{"microcks"})).withEnv("POSTMAN_RUNNER_URL", "http://postman:3000")).withEnv("TEST_CALLBACK_URL", "http://microcks:8080")).withEnv("ASYNC_MINION_URL", "http://microcks-async-minion:8081");
    }

    public MicrocksContainersEnsemble withPostman() {
        return this.withPostman("quay.io/microcks/microcks-postman-runtime:latest");
    }

    public MicrocksContainersEnsemble withPostman(String image) {
        this.postman = new GenericContainer(DockerImageName.parse((String)image)).withNetwork(this.network).withNetworkAliases(new String[]{"postman"}).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*postman-runtime wrapper listening on port.*", (int)1));
        return this;
    }

    public MicrocksContainersEnsemble withAsyncFeature() {
        String image = this.microcks.getDockerImageName().replace("microcks-uber", "microcks-uber-async-minion");
        if (image.endsWith("-native")) {
            image = image.substring(0, image.length() - "-native".length());
        }
        return this.withAsyncFeature(image);
    }

    public MicrocksContainersEnsemble withAsyncFeature(String image) {
        this.asyncMinion = new MicrocksAsyncMinionContainer(this.network, image, this.microcks);
        return this;
    }

    public MicrocksContainersEnsemble withKafkaConnection(KafkaConnection connection) {
        this.ensureAsyncFeatureIsEnabled();
        this.asyncMinion.withKafkaConnection(connection);
        return this;
    }

    public MicrocksContainersEnsemble withMQTTConnection(GenericConnection connection) {
        this.ensureAsyncFeatureIsEnabled();
        this.asyncMinion.withMQTTConnection(connection);
        return this;
    }

    public MicrocksContainersEnsemble withAMQPConnection(GenericConnection connection) {
        this.ensureAsyncFeatureIsEnabled();
        this.asyncMinion.withAMQPConnection(connection);
        return this;
    }

    public MicrocksContainersEnsemble withAmazonSQSConnection(AmazonServiceConnection connection) {
        this.ensureAsyncFeatureIsEnabled();
        this.asyncMinion.withAmazonSQSConnection(connection);
        return this;
    }

    public MicrocksContainersEnsemble withAmazonSNSConnection(AmazonServiceConnection connection) {
        this.ensureAsyncFeatureIsEnabled();
        this.asyncMinion.withAmazonSNSConnection(connection);
        return this;
    }

    public MicrocksContainersEnsemble withAccessToHost(boolean hostAccessible) {
        this.microcks.withAccessToHost(hostAccessible);
        if (this.postman != null) {
            this.postman.withAccessToHost(hostAccessible);
        }
        if (this.asyncMinion != null) {
            this.asyncMinion.withAccessToHost(hostAccessible);
        }
        return this;
    }

    public MicrocksContainersEnsemble withMainArtifacts(String ... artifacts) {
        this.microcks.withMainArtifacts(artifacts);
        return this;
    }

    public MicrocksContainersEnsemble withSecondaryArtifacts(String ... artifacts) {
        this.microcks.withSecondaryArtifacts(artifacts);
        return this;
    }

    public MicrocksContainersEnsemble withMainRemoteArtifacts(String ... remoteArtifactUrls) {
        this.microcks.withMainRemoteArtifacts(remoteArtifactUrls);
        return this;
    }

    public MicrocksContainersEnsemble withSecondaryRemoteArtifacts(String ... remoteArtifactUrls) {
        this.microcks.withSecondaryRemoteArtifacts(remoteArtifactUrls);
        return this;
    }

    public MicrocksContainersEnsemble withSecret(Secret secret) {
        this.microcks.withSecret(secret);
        return this;
    }

    public MicrocksContainersEnsemble withAsyncDependsOn(Startable ... startables) {
        this.ensureAsyncFeatureIsEnabled();
        this.asyncMinion.dependsOn(startables);
        return this;
    }

    public Network getNetwork() {
        return this.network;
    }

    public MicrocksContainer getMicrocksContainer() {
        return this.microcks;
    }

    public GenericContainer<?> getPostmanContainer() {
        return this.postman;
    }

    public MicrocksAsyncMinionContainer getAsyncMinionContainer() {
        return this.asyncMinion;
    }

    public void start() {
        this.microcks.start();
        if (this.postman != null) {
            this.postman.start();
        }
        if (this.asyncMinion != null) {
            this.asyncMinion.start();
        }
    }

    public void stop() {
        ((Stream)this.allContainers().parallel()).forEach(GenericContainer::stop);
    }

    private void ensureAsyncFeatureIsEnabled() {
        if (this.asyncMinion == null) {
            throw new IllegalStateException("Async feature must have been enabled first");
        }
    }

    private Stream<GenericContainer<?>> allContainers() {
        Stream<GenericContainer<?>> stream = Stream.of(this.microcks);
        if (this.postman != null) {
            stream = Stream.concat(stream, Stream.of(this.postman));
        }
        if (this.asyncMinion != null) {
            stream = Stream.concat(stream, Stream.of(this.asyncMinion));
        }
        return stream;
    }
}

