/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.testcontainers.model;

import io.github.microcks.testcontainers.model.OAuth2GrantType;

public class OAuth2ClientContext {
    private String clientId;
    private String clientSecret;
    private String tokenUri;
    private String scopes;
    private String username;
    private String password;
    private String refreshToken;
    private OAuth2GrantType grantType;

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getTokenUri() {
        return this.tokenUri;
    }

    public void setTokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public OAuth2GrantType getGrantType() {
        return this.grantType;
    }

    public void setGrantType(OAuth2GrantType grantType) {
        this.grantType = grantType;
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private String tokenUri;
        private String scopes;
        private String username;
        private String password;
        private String refreshToken;
        private OAuth2GrantType grantType;

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder tokenUri(String tokenUri) {
            this.tokenUri = tokenUri;
            return this;
        }

        public Builder scopes(String scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder grantType(OAuth2GrantType grantType) {
            this.grantType = grantType;
            return this;
        }

        public OAuth2ClientContext build() {
            OAuth2ClientContext oAuth2ClientContext = new OAuth2ClientContext();
            oAuth2ClientContext.setClientId(this.clientId);
            oAuth2ClientContext.setClientSecret(this.clientSecret);
            oAuth2ClientContext.setTokenUri(this.tokenUri);
            oAuth2ClientContext.setScopes(this.scopes);
            oAuth2ClientContext.setUsername(this.username);
            oAuth2ClientContext.setPassword(this.password);
            oAuth2ClientContext.setRefreshToken(this.refreshToken);
            oAuth2ClientContext.setGrantType(this.grantType);
            return oAuth2ClientContext;
        }
    }
}

