/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.testcontainers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.dockerjava.api.command.InspectContainerResponse;
import io.github.microcks.testcontainers.MicrocksException;
import io.github.microcks.testcontainers.model.Secret;
import io.github.microcks.testcontainers.model.TestRequest;
import io.github.microcks.testcontainers.model.TestResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.github.dockerjava.core.MediaType;
import org.testcontainers.shaded.org.awaitility.Awaitility;
import org.testcontainers.shaded.org.awaitility.core.ConditionTimeoutException;
import org.testcontainers.utility.DockerImageName;

public class MicrocksContainer
extends GenericContainer<MicrocksContainer> {
    private static final Logger log = LoggerFactory.getLogger(MicrocksContainer.class);
    private static final String MICROCKS_FULL_IMAGE_NAME = "quay.io/microcks/microcks-uber";
    private static final DockerImageName MICROCKS_IMAGE = DockerImageName.parse((String)"quay.io/microcks/microcks-uber");
    private static final String HTTP_UPLOAD_LINE_FEED = "\r\n";
    public static final int MICROCKS_HTTP_PORT = 8080;
    public static final int MICROCKS_GRPC_PORT = 9090;
    private static ObjectMapper mapper;
    private Set<String> mainArtifactsToImport;
    private Set<String> secondaryArtifactsToImport;
    private Set<Secret> secrets;

    public MicrocksContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public MicrocksContainer(DockerImageName imageName) {
        super(imageName);
        imageName.assertCompatibleWith(new DockerImageName[]{MICROCKS_IMAGE});
        this.withExposedPorts(new Integer[]{8080, 9090});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Started MicrocksApplication.*", (int)1));
    }

    public MicrocksContainer withMainArtifacts(String ... artifacts) {
        if (this.mainArtifactsToImport == null) {
            this.mainArtifactsToImport = new HashSet<String>();
        }
        this.mainArtifactsToImport.addAll(Arrays.stream(artifacts).collect(Collectors.toList()));
        return (MicrocksContainer)this.self();
    }

    public MicrocksContainer withSecondaryArtifacts(String ... artifacts) {
        if (this.secondaryArtifactsToImport == null) {
            this.secondaryArtifactsToImport = new HashSet<String>();
        }
        this.secondaryArtifactsToImport.addAll(Arrays.stream(artifacts).collect(Collectors.toList()));
        return (MicrocksContainer)this.self();
    }

    public MicrocksContainer withSecret(Secret secret) {
        if (this.secrets == null) {
            this.secrets = new HashSet<Secret>();
        }
        this.secrets.add(secret);
        return (MicrocksContainer)this.self();
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        if (this.mainArtifactsToImport != null && !this.mainArtifactsToImport.isEmpty()) {
            this.mainArtifactsToImport.stream().forEach(artifactPath -> this.importArtifact((String)artifactPath, true));
        }
        if (this.secondaryArtifactsToImport != null && !this.secondaryArtifactsToImport.isEmpty()) {
            this.secondaryArtifactsToImport.stream().forEach(artifactPath -> this.importArtifact((String)artifactPath, false));
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            this.secrets.stream().forEach(this::createSecret);
        }
    }

    public String getHttpEndpoint() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(8080));
    }

    public String getSoapMockEndpoint(String service, String version) {
        return String.format("%s/soap/%s/%s", this.getHttpEndpoint(), service, version);
    }

    public String getRestMockEndpoint(String service, String version) {
        return String.format("%s/rest/%s/%s", this.getHttpEndpoint(), service, version);
    }

    public String getGraphQLMockEndpoint(String service, String version) {
        return String.format("%s/graphql/%s/%s", this.getHttpEndpoint(), service, version);
    }

    public String getGrpcMockEndpoint() {
        return String.format("grpc://%s:%s", this.getHost(), this.getMappedPort(9090));
    }

    public void importAsMainArtifact(File artifact) throws IOException, InterruptedException, MicrocksException {
        this.importArtifact(artifact, true);
    }

    public void importAsSecondaryArtifact(File artifact) throws IOException, InterruptedException, MicrocksException {
        this.importArtifact(artifact, false);
    }

    public TestResult testEndpoint(TestRequest testRequest) throws IOException, InterruptedException, MicrocksException {
        return MicrocksContainer.testEndpoint(this.getHttpEndpoint(), testRequest);
    }

    public CompletableFuture<TestResult> testEndpointAsync(TestRequest testRequest) {
        return MicrocksContainer.testEndpointAsync(this.getHttpEndpoint(), testRequest);
    }

    public static CompletableFuture<TestResult> testEndpointAsync(String microcksContainerHttpEndpoint, TestRequest testRequest) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return MicrocksContainer.testEndpoint(microcksContainerHttpEndpoint, testRequest);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public static TestResult testEndpoint(String microcksContainerHttpEndpoint, TestRequest testRequest) throws IOException, MicrocksException {
        String requestBody = MicrocksContainer.getMapper().writeValueAsString((Object)testRequest);
        URL url = new URL(microcksContainerHttpEndpoint + "/api/tests");
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestMethod("POST");
        httpConn.setRequestProperty("Content-Type", MediaType.APPLICATION_JSON.getMediaType());
        httpConn.setDoOutput(true);
        try (OutputStream os = httpConn.getOutputStream();){
            byte[] input = requestBody.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        StringBuilder responseContent = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), StandardCharsets.UTF_8));){
            String responseLine;
            while ((responseLine = br.readLine()) != null) {
                responseContent.append(responseLine.trim());
            }
        }
        if (httpConn.getResponseCode() == 201) {
            httpConn.disconnect();
            TestResult testResult = (TestResult)MicrocksContainer.getMapper().readValue(responseContent.toString(), TestResult.class);
            log.debug("Got Test Result: {}, now polling for progression", (Object)testResult.getId());
            String testResultId = testResult.getId();
            try {
                Awaitility.await().atMost(testRequest.getTimeout() + 1000L, TimeUnit.MILLISECONDS).pollDelay(100L, TimeUnit.MILLISECONDS).pollInterval(200L, TimeUnit.MILLISECONDS).until(() -> !MicrocksContainer.refreshTestResult(microcksContainerHttpEndpoint, testResultId).isInProgress());
            }
            catch (ConditionTimeoutException timeoutException) {
                log.info("Caught a ConditionTimeoutException for test on {}", (Object)testRequest.getTestEndpoint());
            }
            return MicrocksContainer.refreshTestResult(microcksContainerHttpEndpoint, testResultId);
        }
        if (log.isErrorEnabled()) {
            log.error("Couldn't launch on new test on Microcks with status {} ", (Object)httpConn.getResponseCode());
            log.error("Error response body is {}", (Object)responseContent);
        }
        httpConn.disconnect();
        throw new MicrocksException("Couldn't launch on new test on Microcks. Please check Microcks container logs");
    }

    private void importArtifact(String artifactPath, boolean mainArtifact) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(artifactPath);
        if (resource == null && (resource = MicrocksContainer.class.getClassLoader().getResource(artifactPath)) == null) {
            log.warn("Could not load classpath artifact: {}", (Object)artifactPath);
            throw new ArtifactLoadException("Error while importing artifact: " + artifactPath);
        }
        try {
            this.importArtifact(new File(resource.getFile()), mainArtifact);
        }
        catch (Exception e) {
            log.error("Could not load classpath artifact: {}", (Object)artifactPath);
            throw new ArtifactLoadException("Error while importing artifact: " + artifactPath, e);
        }
    }

    private void importArtifact(File artifact, boolean mainArtifact) throws IOException, MicrocksException {
        if (!artifact.exists()) {
            throw new IOException("Artifact " + artifact.getPath() + " does not exist or can't be read.");
        }
        String boundary = "===" + System.currentTimeMillis() + "===";
        URL url = new URL(this.getHttpEndpoint() + "/api/artifact/upload" + (mainArtifact ? "" : "?mainArtifact=false"));
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setUseCaches(false);
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        try (OutputStream os = httpConn.getOutputStream();
             PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(os, StandardCharsets.UTF_8), true);
             FileInputStream is = new FileInputStream(artifact);){
            writer.append("--" + boundary).append(HTTP_UPLOAD_LINE_FEED).append("Content-Disposition: form-data; name=\"file\"; filename=\"" + artifact.getName() + "\"").append(HTTP_UPLOAD_LINE_FEED).append("Content-Type: application/octet-stream").append(HTTP_UPLOAD_LINE_FEED).append("Content-Transfer-Encoding: binary").append(HTTP_UPLOAD_LINE_FEED).append(HTTP_UPLOAD_LINE_FEED);
            writer.flush();
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.flush();
            writer.append(HTTP_UPLOAD_LINE_FEED).append("--" + boundary + "--").append(HTTP_UPLOAD_LINE_FEED).flush();
        }
        if (httpConn.getResponseCode() != 201) {
            StringBuilder responseContent = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), StandardCharsets.UTF_8));){
                String responseLine = null;
                while ((responseLine = br.readLine()) != null) {
                    responseContent.append(responseLine.trim());
                }
            }
            httpConn.disconnect();
            log.error("Artifact has not been correctly imported: {}", (Object)responseContent);
            throw new MicrocksException("Artifact has not been correctly imported: " + responseContent);
        }
        httpConn.disconnect();
    }

    private void createSecret(Secret secret) {
        try {
            URL url = new URL(this.getHttpEndpoint() + "/api/secrets");
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setRequestMethod("POST");
            httpConn.setRequestProperty("Content-Type", MediaType.APPLICATION_JSON.getMediaType());
            httpConn.setRequestProperty("Accept", MediaType.APPLICATION_JSON.getMediaType());
            httpConn.setDoOutput(true);
            String requestBody = MicrocksContainer.getMapper().writeValueAsString((Object)secret);
            try (OutputStream os = httpConn.getOutputStream();){
                byte[] input = requestBody.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
                os.flush();
            }
            if (httpConn.getResponseCode() != 201) {
                StringBuilder responseContent = new StringBuilder();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), StandardCharsets.UTF_8));){
                    String responseLine = null;
                    while ((responseLine = br.readLine()) != null) {
                        responseContent.append(responseLine.trim());
                    }
                }
                httpConn.disconnect();
                log.error("Secret has not been correctly created: {}", (Object)responseContent);
                throw new MicrocksException("Secret has not been correctly created: " + responseContent);
            }
            httpConn.disconnect();
        }
        catch (Exception e) {
            log.warn("Error while creating Secret: {}", (Object)secret.getName());
            throw new SecretCreationException("Error while creating Secret", e);
        }
    }

    private static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.setPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
        }
        return mapper;
    }

    private static TestResult refreshTestResult(String microcksContainerHttpEndpoint, String testResultId) throws IOException {
        URL url = new URL(microcksContainerHttpEndpoint + "/api/tests/" + testResultId);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestMethod("GET");
        httpConn.setRequestProperty("Accept", "application/json");
        httpConn.setDoOutput(false);
        StringBuilder content = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));){
            String inputLine;
            while ((inputLine = br.readLine()) != null) {
                content.append(inputLine);
            }
        }
        httpConn.disconnect();
        return (TestResult)MicrocksContainer.getMapper().readValue(content.toString(), TestResult.class);
    }

    public static class ArtifactLoadException
    extends RuntimeException {
        public ArtifactLoadException(String message) {
            super(message);
        }

        public ArtifactLoadException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class SecretCreationException
    extends RuntimeException {
        public SecretCreationException(String message) {
            super(message);
        }

        public SecretCreationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

