/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.testcontainers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.dockerjava.api.command.InspectContainerResponse;
import io.github.microcks.testcontainers.MicrocksException;
import io.github.microcks.testcontainers.model.DailyInvocationStatistic;
import io.github.microcks.testcontainers.model.RequestResponsePair;
import io.github.microcks.testcontainers.model.Secret;
import io.github.microcks.testcontainers.model.TestRequest;
import io.github.microcks.testcontainers.model.TestResult;
import io.github.microcks.testcontainers.model.UnidirectionalEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JavaType;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.org.awaitility.Awaitility;
import org.testcontainers.shaded.org.awaitility.core.ConditionTimeoutException;
import org.testcontainers.utility.DockerImageName;

public class MicrocksContainer
extends GenericContainer<MicrocksContainer> {
    private static final Logger log = LoggerFactory.getLogger(MicrocksContainer.class);
    private static final String MICROCKS_FULL_IMAGE_NAME = "quay.io/microcks/microcks-uber";
    private static final DockerImageName MICROCKS_IMAGE = DockerImageName.parse((String)"quay.io/microcks/microcks-uber");
    private static final SimpleDateFormat METRICS_API_DAY_FORMATTER = new SimpleDateFormat("yyyyMMdd");
    private static final String HTTP_UPLOAD_LINE_FEED = "\r\n";
    private static final String HTTP_CONTENT_TYPE = "Content-Type";
    private static final String HTTP_ACCEPT = "Accept";
    private static final String APPLICATION_JSON = "application/json";
    public static final int MICROCKS_HTTP_PORT = 8080;
    public static final int MICROCKS_GRPC_PORT = 9090;
    private static ObjectMapper mapper;
    private Set<String> snapshotsToImport;
    private Set<String> mainArtifactsToImport;
    private Set<String> secondaryArtifactsToImport;
    private Set<String> mainRemoteArtifactsToImport;
    private Set<String> secondaryRemoteArtifactsToImport;
    private Set<Secret> secrets;

    public MicrocksContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public MicrocksContainer(DockerImageName imageName) {
        super(imageName);
        imageName.assertCompatibleWith(new DockerImageName[]{MICROCKS_IMAGE});
        this.withExposedPorts(new Integer[]{8080, 9090});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Started MicrocksApplication.*", (int)1));
    }

    public MicrocksContainer withMainArtifacts(String ... artifacts) {
        if (this.mainArtifactsToImport == null) {
            this.mainArtifactsToImport = new HashSet<String>();
        }
        this.mainArtifactsToImport.addAll(Arrays.stream(artifacts).collect(Collectors.toList()));
        return (MicrocksContainer)this.self();
    }

    public MicrocksContainer withSecondaryArtifacts(String ... artifacts) {
        if (this.secondaryArtifactsToImport == null) {
            this.secondaryArtifactsToImport = new HashSet<String>();
        }
        this.secondaryArtifactsToImport.addAll(Arrays.stream(artifacts).collect(Collectors.toList()));
        return (MicrocksContainer)this.self();
    }

    public MicrocksContainer withMainRemoteArtifacts(String ... remoteArtifactUrls) {
        if (this.mainRemoteArtifactsToImport == null) {
            this.mainRemoteArtifactsToImport = new HashSet<String>();
        }
        this.mainRemoteArtifactsToImport.addAll(Arrays.stream(remoteArtifactUrls).collect(Collectors.toList()));
        return (MicrocksContainer)this.self();
    }

    public MicrocksContainer withSecondaryRemoteArtifacts(String ... remoteArtifactUrls) {
        if (this.secondaryRemoteArtifactsToImport == null) {
            this.secondaryRemoteArtifactsToImport = new HashSet<String>();
        }
        this.secondaryRemoteArtifactsToImport.addAll(Arrays.stream(remoteArtifactUrls).collect(Collectors.toList()));
        return (MicrocksContainer)this.self();
    }

    public MicrocksContainer withSnapshots(String ... snapshots) {
        if (this.snapshotsToImport == null) {
            this.snapshotsToImport = new HashSet<String>();
        }
        this.snapshotsToImport.addAll(Arrays.stream(snapshots).collect(Collectors.toList()));
        return (MicrocksContainer)this.self();
    }

    public MicrocksContainer withSecret(Secret secret) {
        if (this.secrets == null) {
            this.secrets = new HashSet<Secret>();
        }
        this.secrets.add(secret);
        return (MicrocksContainer)this.self();
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        if (this.snapshotsToImport != null && !this.snapshotsToImport.isEmpty()) {
            this.snapshotsToImport.forEach(this::importSnapshot);
        }
        if (this.mainRemoteArtifactsToImport != null && !this.mainRemoteArtifactsToImport.isEmpty()) {
            this.mainRemoteArtifactsToImport.forEach(remoteArtifactUrl -> this.downloadArtifact((String)remoteArtifactUrl, true));
        }
        if (this.secondaryRemoteArtifactsToImport != null && !this.secondaryRemoteArtifactsToImport.isEmpty()) {
            this.secondaryRemoteArtifactsToImport.forEach(remoteArtifactUrl -> this.downloadArtifact((String)remoteArtifactUrl, false));
        }
        if (this.mainArtifactsToImport != null && !this.mainArtifactsToImport.isEmpty()) {
            this.mainArtifactsToImport.forEach(artifactPath -> this.importArtifact((String)artifactPath, true));
        }
        if (this.secondaryArtifactsToImport != null && !this.secondaryArtifactsToImport.isEmpty()) {
            this.secondaryArtifactsToImport.forEach(artifactPath -> this.importArtifact((String)artifactPath, false));
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            this.secrets.forEach(this::createSecret);
        }
    }

    public String getHttpEndpoint() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(8080));
    }

    public String getSoapMockEndpoint(String service, String version) {
        return String.format("%s/soap/%s/%s", this.getHttpEndpoint(), service, version);
    }

    public String getSoapMockEndpointPath(String service, String version) {
        return String.format("/soap/%s/%s", service, version);
    }

    public String getValidatingSoapMockEndpoint(String service, String version) {
        return String.format("%s/soap/%s/%s?validate=true", this.getHttpEndpoint(), service, version);
    }

    public String getValidatingSoapMockEndpointPath(String service, String version) {
        return String.format("/soap/%s/%s?validate=true", service, version);
    }

    public String getRestMockEndpoint(String service, String version) {
        return String.format("%s/rest/%s/%s", this.getHttpEndpoint(), service, version);
    }

    public String getRestMockEndpointPath(String service, String version) {
        return String.format("/rest/%s/%s", service, version);
    }

    public String getValidatingRestMockEndpoint(String service, String version) {
        return String.format("%s/rest-valid/%s/%s", this.getHttpEndpoint(), service, version);
    }

    public String getValidatingRestMockEndpointPath(String service, String version) {
        return String.format("/rest-valid/%s/%s", service, version);
    }

    public String getGraphQLMockEndpoint(String service, String version) {
        return String.format("%s/graphql/%s/%s", this.getHttpEndpoint(), service, version);
    }

    public String getGraphQLMockEndpointPath(String service, String version) {
        return String.format("/graphql/%s/%s", service, version);
    }

    public String getGrpcMockEndpoint() {
        return String.format("grpc://%s:%s", this.getHost(), this.getMappedPort(9090));
    }

    public void importAsMainArtifact(File artifact) throws IOException, MicrocksException {
        MicrocksContainer.importArtifact(this.getHttpEndpoint(), artifact, true);
    }

    public void importAsSecondaryArtifact(File artifact) throws IOException, MicrocksException {
        MicrocksContainer.importArtifact(this.getHttpEndpoint(), artifact, false);
    }

    public void importSnapshot(File snapshot) throws IOException, MicrocksException {
        MicrocksContainer.importSnapshot(this.getHttpEndpoint(), snapshot);
    }

    public static void importArtifact(String microcksContainerHttpEndpoint, File artifact, boolean mainArtifact) throws IOException, MicrocksException {
        if (!artifact.exists()) {
            throw new IOException("Artifact " + artifact.getPath() + " does not exist or can't be read.");
        }
        URL url = new URL(microcksContainerHttpEndpoint + "/api/artifact/upload" + (mainArtifact ? "" : "?mainArtifact=false"));
        HttpURLConnection httpConn = MicrocksContainer.uploadFileToMicrocks(url, artifact, "application/octet-stream");
        if (httpConn.getResponseCode() != 201) {
            StringBuilder responseContent = MicrocksContainer.getResponseContent(httpConn);
            httpConn.disconnect();
            log.error("Artifact has not been correctly imported: {}", (Object)responseContent);
            throw new MicrocksException("Artifact has not been correctly imported: " + responseContent);
        }
        httpConn.disconnect();
    }

    public static void importSnapshot(String microcksContainerHttpEndpoint, File snapshot) throws IOException, MicrocksException {
        if (!snapshot.exists()) {
            throw new IOException("Snapshot " + snapshot.getPath() + " does not exist or can't be read.");
        }
        URL url = new URL(microcksContainerHttpEndpoint + "/api/import");
        HttpURLConnection httpConn = MicrocksContainer.uploadFileToMicrocks(url, snapshot, APPLICATION_JSON);
        if (httpConn.getResponseCode() != 201) {
            StringBuilder responseContent = MicrocksContainer.getResponseContent(httpConn);
            httpConn.disconnect();
            log.error("Snapshot has not been correctly imported: {}", (Object)responseContent);
            throw new MicrocksException("Snapshot has not been correctly imported: " + responseContent);
        }
        httpConn.disconnect();
    }

    public TestResult testEndpoint(TestRequest testRequest) throws IOException, MicrocksException {
        return MicrocksContainer.testEndpoint(this.getHttpEndpoint(), testRequest);
    }

    public CompletableFuture<TestResult> testEndpointAsync(TestRequest testRequest) {
        return MicrocksContainer.testEndpointAsync(this.getHttpEndpoint(), testRequest);
    }

    public static CompletableFuture<TestResult> testEndpointAsync(String microcksContainerHttpEndpoint, TestRequest testRequest) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return MicrocksContainer.testEndpoint(microcksContainerHttpEndpoint, testRequest);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public static TestResult testEndpoint(String microcksContainerHttpEndpoint, TestRequest testRequest) throws IOException, MicrocksException {
        String requestBody = MicrocksContainer.getMapper().writeValueAsString((Object)testRequest);
        URL url = new URL(microcksContainerHttpEndpoint + "/api/tests");
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestMethod("POST");
        httpConn.setRequestProperty(HTTP_CONTENT_TYPE, APPLICATION_JSON);
        httpConn.setDoOutput(true);
        try (OutputStream os = httpConn.getOutputStream();){
            byte[] input = requestBody.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        StringBuilder responseContent = MicrocksContainer.getResponseContent(httpConn);
        if (httpConn.getResponseCode() == 201) {
            httpConn.disconnect();
            TestResult testResult = (TestResult)MicrocksContainer.getMapper().readValue(responseContent.toString(), TestResult.class);
            log.debug("Got Test Result: {}, now polling for progression", (Object)testResult.getId());
            String testResultId = testResult.getId();
            try {
                Awaitility.await().atMost(testRequest.getTimeout() + 1000L, TimeUnit.MILLISECONDS).pollDelay(100L, TimeUnit.MILLISECONDS).pollInterval(200L, TimeUnit.MILLISECONDS).until(() -> !MicrocksContainer.refreshTestResult(microcksContainerHttpEndpoint, testResultId).isInProgress());
            }
            catch (ConditionTimeoutException timeoutException) {
                log.info("Caught a ConditionTimeoutException for test on {}", (Object)testRequest.getTestEndpoint());
            }
            return MicrocksContainer.refreshTestResult(microcksContainerHttpEndpoint, testResultId);
        }
        if (log.isErrorEnabled()) {
            log.error("Couldn't launch on new test on Microcks with status {} ", (Object)httpConn.getResponseCode());
            log.error("Error response body is {}", (Object)responseContent);
        }
        httpConn.disconnect();
        throw new MicrocksException("Couldn't launch on new test on Microcks. Please check Microcks container logs");
    }

    public List<RequestResponsePair> getMessagesForTestCase(TestResult testResult, String operationName) throws IOException, MicrocksException {
        return MicrocksContainer.getMessagesForTestCase(this.getHttpEndpoint(), testResult, operationName);
    }

    public static List<RequestResponsePair> getMessagesForTestCase(String microcksContainerHttpEndpoint, TestResult testResult, String operationName) throws IOException, MicrocksException {
        String operation = operationName.replace('/', '!');
        String testCaseId = testResult.getId() + "-" + testResult.getTestNumber() + "-" + URLEncoder.encode(operation);
        URL url = new URL(microcksContainerHttpEndpoint + "/api/tests/" + testResult.getId() + "/messages/" + testCaseId);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestMethod("GET");
        httpConn.setRequestProperty(HTTP_ACCEPT, APPLICATION_JSON);
        httpConn.setDoOutput(false);
        if (httpConn.getResponseCode() == 200) {
            StringBuilder responseContent = MicrocksContainer.getResponseContent(httpConn);
            httpConn.disconnect();
            return (List)MicrocksContainer.getMapper().readValue(responseContent.toString(), (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, RequestResponsePair.class));
        }
        if (log.isErrorEnabled()) {
            log.error("Couldn't retrieve messages status {} ", (Object)httpConn.getResponseCode());
        }
        httpConn.disconnect();
        throw new MicrocksException("Couldn't retrieve messages on test on Microcks. Please check Microcks container logs");
    }

    public List<UnidirectionalEvent> getEventMessagesForTestCase(TestResult testResult, String operationName) throws IOException, MicrocksException {
        return MicrocksContainer.getEventMessagesForTestCase(this.getHttpEndpoint(), testResult, operationName);
    }

    public static List<UnidirectionalEvent> getEventMessagesForTestCase(String microcksContainerHttpEndpoint, TestResult testResult, String operationName) throws IOException, MicrocksException {
        String operation = operationName.replace('/', '!');
        String testCaseId = testResult.getId() + "-" + testResult.getTestNumber() + "-" + URLEncoder.encode(operation);
        URL url = new URL(microcksContainerHttpEndpoint + "/api/tests/" + testResult.getId() + "/events/" + testCaseId);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestMethod("GET");
        httpConn.setRequestProperty(HTTP_ACCEPT, APPLICATION_JSON);
        httpConn.setDoOutput(false);
        if (httpConn.getResponseCode() == 200) {
            StringBuilder responseContent = MicrocksContainer.getResponseContent(httpConn);
            httpConn.disconnect();
            return (List)MicrocksContainer.getMapper().readValue(responseContent.toString(), (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, UnidirectionalEvent.class));
        }
        if (log.isErrorEnabled()) {
            log.error("Couldn't retrieve messages status {} ", (Object)httpConn.getResponseCode());
        }
        httpConn.disconnect();
        throw new MicrocksException("Couldn't retrieve messages on test on Microcks. Please check Microcks container logs");
    }

    public void downloadAsMainRemoteArtifact(String remoteArtifactUrl) throws ArtifactLoadException {
        this.downloadArtifact(remoteArtifactUrl, true);
    }

    public void downloadAsSecondaryRemoteArtifact(String remoteArtifactUrl) throws ArtifactLoadException {
        this.downloadArtifact(remoteArtifactUrl, false);
    }

    public boolean verify(String serviceName, String serviceVersion) {
        return MicrocksContainer.doVerify(this.getHttpEndpoint(), serviceName, serviceVersion, null);
    }

    public static boolean verify(String microcksContainerHttpEndpoint, String serviceName, String serviceVersion) {
        return MicrocksContainer.doVerify(microcksContainerHttpEndpoint, serviceName, serviceVersion, null);
    }

    public boolean verify(String serviceName, String serviceVersion, Date invocationsDate) {
        return MicrocksContainer.doVerify(this.getHttpEndpoint(), serviceName, serviceVersion, invocationsDate);
    }

    public static boolean verify(String microcksContainerHttpEndpoint, String serviceName, String serviceVersion, Date invocationsDate) {
        return MicrocksContainer.doVerify(microcksContainerHttpEndpoint, serviceName, serviceVersion, invocationsDate);
    }

    private static boolean doVerify(String microcksContainerHttpEndpoint, String serviceName, String serviceVersion, Date invocationsDate) {
        DailyInvocationStatistic dailyInvocationStatistic = MicrocksContainer.getServiceInvocations(microcksContainerHttpEndpoint, serviceName, serviceVersion, invocationsDate);
        if (dailyInvocationStatistic == null) {
            return false;
        }
        BigDecimal count = dailyInvocationStatistic.getDailyCount();
        return count != null && count.intValue() != 0;
    }

    public Long getServiceInvocationsCount(String serviceName, String serviceVersion) {
        return MicrocksContainer.doGetServiceInvocationsCount(this.getHttpEndpoint(), serviceName, serviceVersion, null);
    }

    public static Long getServiceInvocationsCount(String microcksContainerHttpEndpoint, String serviceName, String serviceVersion) {
        return MicrocksContainer.doGetServiceInvocationsCount(microcksContainerHttpEndpoint, serviceName, serviceVersion, null);
    }

    public Long getServiceInvocationsCount(String serviceName, String serviceVersion, Date invocationsDate) {
        return MicrocksContainer.doGetServiceInvocationsCount(this.getHttpEndpoint(), serviceName, serviceVersion, invocationsDate);
    }

    public static Long getServiceInvocationsCount(String microcksContainerHttpEndpoint, String serviceName, String serviceVersion, Date invocationsDate) {
        return MicrocksContainer.doGetServiceInvocationsCount(microcksContainerHttpEndpoint, serviceName, serviceVersion, invocationsDate);
    }

    private static Long doGetServiceInvocationsCount(String microcksContainerHttpEndpoint, String serviceName, String serviceVersion, Date invocationsDate) {
        DailyInvocationStatistic dailyInvocationStatistic = MicrocksContainer.getServiceInvocations(microcksContainerHttpEndpoint, serviceName, serviceVersion, invocationsDate);
        if (dailyInvocationStatistic == null) {
            return 0L;
        }
        BigDecimal count = dailyInvocationStatistic.getDailyCount();
        return count.longValue();
    }

    private static DailyInvocationStatistic getServiceInvocations(String microcksContainerHttpEndpoint, String serviceName, String serviceVersion, Date invocationsDate) {
        String encodedServiceName = URLEncoder.encode(serviceName).replace("+", "%20");
        String encodedServiceVersion = URLEncoder.encode(serviceVersion).replace("+", "%20");
        String restApiURL = String.format("%s/api/metrics/invocations/%s/%s", microcksContainerHttpEndpoint, encodedServiceName, encodedServiceVersion);
        if (invocationsDate != null) {
            restApiURL = restApiURL + "?day=" + METRICS_API_DAY_FORMATTER.format(invocationsDate);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            log.warn("Failed to sleep before calling Microcks API", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try {
            StringBuilder content = MicrocksContainer.getFromRestApi(restApiURL);
            return content.length() == 0 ? null : (DailyInvocationStatistic)MicrocksContainer.getMapper().readValue(content.toString(), DailyInvocationStatistic.class);
        }
        catch (IOException e) {
            log.warn("Failed to get service's invocations at address " + restApiURL, (Throwable)e);
            return null;
        }
    }

    private void importArtifact(String artifactPath, boolean mainArtifact) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(artifactPath);
        if (resource == null && (resource = MicrocksContainer.class.getClassLoader().getResource(artifactPath)) == null) {
            log.warn("Could not load classpath artifact: {}", (Object)artifactPath);
            throw new ArtifactLoadException("Error while importing artifact: " + artifactPath);
        }
        try {
            File resourceFile = new File(URLDecoder.decode(resource.getFile(), StandardCharsets.UTF_8.name()));
            MicrocksContainer.importArtifact(this.getHttpEndpoint(), resourceFile, mainArtifact);
        }
        catch (Exception e) {
            log.error("Could not load classpath artifact: {}", (Object)artifactPath);
            throw new ArtifactLoadException("Error while importing artifact: " + artifactPath, e);
        }
    }

    private void downloadArtifact(String remoteArtifactUrl, boolean mainArtifact) throws ArtifactLoadException {
        try {
            URL url = new URL(this.getHttpEndpoint() + "/api/artifact/download");
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setUseCaches(false);
            httpConn.setRequestMethod("POST");
            httpConn.setDoOutput(true);
            String requestBody = "mainArtifact=" + mainArtifact + "&url=" + remoteArtifactUrl;
            try (OutputStream os = httpConn.getOutputStream();
                 BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));){
                writer.write(requestBody);
                writer.flush();
            }
            if (httpConn.getResponseCode() != 201) {
                StringBuilder responseContent = MicrocksContainer.getResponseContent(httpConn);
                httpConn.disconnect();
                log.error("Artifact has not been correctly downloaded: {}", (Object)responseContent);
                throw new MicrocksException("Artifact has not been correctly downloaded: " + responseContent);
            }
            httpConn.disconnect();
        }
        catch (Exception e) {
            log.error("Could not load remote artifact: {}", (Object)remoteArtifactUrl);
            throw new ArtifactLoadException("Error while importing remote artifact: " + remoteArtifactUrl, e);
        }
    }

    private void importSnapshot(String snapshotPath) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(snapshotPath);
        if (resource == null && (resource = MicrocksContainer.class.getClassLoader().getResource(snapshotPath)) == null) {
            log.warn("Could not load classpath snapshot: {}", (Object)snapshotPath);
            throw new ArtifactLoadException("Error while importing snasphot: " + snapshotPath);
        }
        try {
            MicrocksContainer.importSnapshot(this.getHttpEndpoint(), new File(resource.getFile()));
        }
        catch (Exception e) {
            log.error("Could not load classpath snapshot: {}", (Object)snapshotPath);
            throw new ArtifactLoadException("Error while importing snapshot: " + snapshotPath, e);
        }
    }

    private void createSecret(Secret secret) {
        try {
            URL url = new URL(this.getHttpEndpoint() + "/api/secrets");
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setRequestMethod("POST");
            httpConn.setRequestProperty(HTTP_CONTENT_TYPE, APPLICATION_JSON);
            httpConn.setRequestProperty(HTTP_ACCEPT, APPLICATION_JSON);
            httpConn.setDoOutput(true);
            String requestBody = MicrocksContainer.getMapper().writeValueAsString((Object)secret);
            try (OutputStream os = httpConn.getOutputStream();){
                byte[] input = requestBody.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
                os.flush();
            }
            if (httpConn.getResponseCode() != 201) {
                StringBuilder responseContent = MicrocksContainer.getResponseContent(httpConn);
                httpConn.disconnect();
                log.error("Secret has not been correctly created: {}", (Object)responseContent);
                throw new MicrocksException("Secret has not been correctly created: " + responseContent);
            }
            httpConn.disconnect();
        }
        catch (Exception e) {
            log.warn("Error while creating Secret: {}", (Object)secret.getName());
            throw new SecretCreationException("Error while creating Secret", e);
        }
    }

    private static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.setPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
        }
        return mapper;
    }

    private static StringBuilder getResponseContent(HttpURLConnection httpConn) throws IOException {
        StringBuilder responseContent = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), StandardCharsets.UTF_8));){
            String responseLine;
            while ((responseLine = br.readLine()) != null) {
                responseContent.append(responseLine.trim());
            }
        }
        return responseContent;
    }

    private static HttpURLConnection uploadFileToMicrocks(URL microcksApiURL, File file, String contentType) throws IOException {
        String boundary = "===" + System.currentTimeMillis() + "===";
        HttpURLConnection httpConn = (HttpURLConnection)microcksApiURL.openConnection();
        httpConn.setUseCaches(false);
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setRequestProperty(HTTP_CONTENT_TYPE, "multipart/form-data; boundary=" + boundary);
        try (OutputStream os = httpConn.getOutputStream();
             PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(os, StandardCharsets.UTF_8), true);
             FileInputStream is = new FileInputStream(file);){
            writer.append("--" + boundary).append(HTTP_UPLOAD_LINE_FEED).append("Content-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"").append(HTTP_UPLOAD_LINE_FEED).append("Content-Type: " + contentType).append(HTTP_UPLOAD_LINE_FEED).append("Content-Transfer-Encoding: binary").append(HTTP_UPLOAD_LINE_FEED).append(HTTP_UPLOAD_LINE_FEED);
            writer.flush();
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.flush();
            writer.append(HTTP_UPLOAD_LINE_FEED).append("--" + boundary + "--").append(HTTP_UPLOAD_LINE_FEED).flush();
        }
        return httpConn;
    }

    private static TestResult refreshTestResult(String microcksContainerHttpEndpoint, String testResultId) throws IOException {
        StringBuilder content = MicrocksContainer.getFromRestApi(microcksContainerHttpEndpoint + "/api/tests/" + testResultId);
        return (TestResult)MicrocksContainer.getMapper().readValue(content.toString(), TestResult.class);
    }

    private static StringBuilder getFromRestApi(String restApiURL) throws IOException {
        URL url = new URL(restApiURL);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestMethod("GET");
        httpConn.setRequestProperty(HTTP_ACCEPT, APPLICATION_JSON);
        httpConn.setDoOutput(false);
        StringBuilder content = MicrocksContainer.getResponseContent(httpConn);
        httpConn.disconnect();
        return content;
    }

    public static class ArtifactLoadException
    extends RuntimeException {
        public ArtifactLoadException(String message) {
            super(message);
        }

        public ArtifactLoadException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class SecretCreationException
    extends RuntimeException {
        public SecretCreationException(String message) {
            super(message);
        }

        public SecretCreationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

