/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;

public class AvroUtil {
    public static byte[] jsonToAvro(String json, String avroSchema) throws AvroTypeException, IOException {
        return AvroUtil.jsonToAvro(json, new Schema.Parser().parse(avroSchema));
    }

    public static byte[] jsonToAvro(String json, Schema avroSchema) throws AvroTypeException, IOException {
        GenericDatumReader reader = new GenericDatumReader(avroSchema);
        ByteArrayInputStream input = new ByteArrayInputStream(json.getBytes("UTF-8"));
        JsonDecoder jsonDecoder = DecoderFactory.get().jsonDecoder(avroSchema, (InputStream)input);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GenericDatumWriter writer = new GenericDatumWriter(avroSchema);
        BinaryEncoder e = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
        Object datum = null;
        try {
            while (true) {
                datum = reader.read(datum, (Decoder)jsonDecoder);
                writer.write(datum, (Encoder)e);
                e.flush();
            }
        }
        catch (EOFException eOFException) {
            return baos.toByteArray();
        }
    }

    public static GenericRecord jsonToAvroRecord(String json, String avroSchema) throws AvroTypeException, IOException {
        return AvroUtil.jsonToAvroRecord(json, new Schema.Parser().parse(avroSchema));
    }

    public static GenericRecord jsonToAvroRecord(String json, Schema avroSchema) throws AvroTypeException, IOException {
        GenericDatumReader reader = new GenericDatumReader(avroSchema);
        ByteArrayInputStream input = new ByteArrayInputStream(json.getBytes("UTF-8"));
        JsonDecoder jsonDecoder = DecoderFactory.get().jsonDecoder(avroSchema, (InputStream)input);
        return (GenericRecord)reader.read(null, (Decoder)jsonDecoder);
    }

    public static String avroToJson(byte[] avroBinary, String avroSchema) throws AvroTypeException, IOException {
        return AvroUtil.avroToJson(avroBinary, new Schema.Parser().parse(avroSchema));
    }

    public static String avroToJson(byte[] avroBinary, Schema avroSchema) throws AvroTypeException, IOException {
        GenericDatumReader datumReader = new GenericDatumReader(avroSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(avroBinary, null);
        GenericRecord record = (GenericRecord)datumReader.read(null, (Decoder)decoder);
        return record.toString();
    }

    public static GenericRecord avroToAvroRecord(byte[] avroBinary, String avroSchema) throws AvroTypeException, IOException {
        return AvroUtil.avroToAvroRecord(avroBinary, new Schema.Parser().parse(avroSchema));
    }

    public static GenericRecord avroToAvroRecord(byte[] avroBinary, Schema avroSchema) throws AvroTypeException, IOException {
        GenericDatumReader datumReader = new GenericDatumReader(avroSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(avroBinary, null);
        return (GenericRecord)datumReader.read(null, (Decoder)decoder);
    }

    public static boolean validate(Schema schema, Object datum) {
        switch (schema.getType()) {
            case RECORD: {
                if (!(datum instanceof GenericRecord)) break;
                GenericRecord record = (GenericRecord)datum;
                for (Schema.Field f : schema.getFields()) {
                    if (!record.hasField(f.name())) {
                        return false;
                    }
                    if (AvroUtil.validate(f.schema(), record.get(f.pos()))) continue;
                    return false;
                }
                return true;
            }
        }
        return GenericData.get().validate(schema, datum);
    }

    public static List<String> getValidationErrors(Schema schema, Object datum, String ... fieldName) {
        ArrayList<String> errors = new ArrayList<String>();
        switch (schema.getType()) {
            case RECORD: {
                if (!(datum instanceof GenericRecord)) break;
                GenericRecord record = (GenericRecord)datum;
                for (Schema.Field f : schema.getFields()) {
                    if (!record.hasField(f.name()) && !f.hasDefaultValue()) {
                        errors.add("Required field " + f.name() + " cannot be found in record");
                        continue;
                    }
                    if (!record.hasField(f.name())) continue;
                    errors.addAll(AvroUtil.getValidationErrors(f.schema(), record.get(f.pos()), f.name()));
                }
                break;
            }
            case ENUM: {
                if (schema.hasEnumSymbol(datum.toString())) break;
                errors.add(datum.toString() + " enum value is not defined in schema");
                break;
            }
            case ARRAY: {
                if (!(datum instanceof Collection)) {
                    errors.add(fieldName + " is not a valid array");
                    break;
                }
                for (Object element : (Collection)datum) {
                    errors.addAll(AvroUtil.getValidationErrors(schema.getElementType(), element, new String[0]));
                }
                break;
            }
            case STRING: {
                if (datum instanceof CharSequence) break;
                errors.add(fieldName + " is not a string");
                break;
            }
            case BYTES: {
                if (datum instanceof ByteBuffer) break;
                errors.add(fieldName + " is not bytes");
                break;
            }
            case INT: {
                if (datum instanceof Integer) break;
                errors.add(fieldName + " is not an integer");
                break;
            }
            case LONG: {
                if (datum instanceof Long) break;
                errors.add(fieldName + " is not a long");
                break;
            }
            case FLOAT: {
                if (datum instanceof Float) break;
                errors.add(fieldName + " is not a float");
                break;
            }
            case DOUBLE: {
                if (datum instanceof Double) break;
                errors.add(fieldName + " is not a double");
                break;
            }
            case BOOLEAN: {
                if (datum instanceof Boolean) break;
                errors.add(fieldName + " is not a boolean");
            }
        }
        return errors;
    }
}

