/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.uri.URITranslatorConfiguration;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaValidator {
    private static Logger log = LoggerFactory.getLogger(JsonSchemaValidator.class);
    public static final String JSON_V4_SCHEMA_IDENTIFIER = "http://json-schema.org/draft-04/schema#";
    public static final String JSON_V7_SCHEMA_IDENTIFIER = "http://json-schema.org/draft-07/schema#";
    public static final String JSON_V12_SCHEMA_IDENTIFIER = "http://json-schema.org/draft/2020-12/schema#";
    public static final String JSON_SCHEMA_IDENTIFIER_ELEMENT = "$schema";
    public static final String JSON_SCHEMA_COMPONENTS_ELEMENT = "components";
    public static final String JSON_SCHEMA_PROPERTIES_ELEMENT = "properties";

    private JsonSchemaValidator() {
    }

    public static boolean isJsonValid(String schemaText, String jsonText) throws IOException {
        return JsonSchemaValidator.isJsonValid(schemaText, jsonText, null);
    }

    public static boolean isJsonValid(String schemaText, String jsonText, String namespace) throws IOException {
        try {
            List<String> errors = JsonSchemaValidator.validateJson(schemaText, jsonText, namespace);
            if (!errors.isEmpty()) {
                log.debug("Get validation errors, returning false");
                return false;
            }
        }
        catch (ProcessingException pe) {
            log.debug("Got processing exception while extracting schema, returning false");
            return false;
        }
        return true;
    }

    public static List<String> validateJson(String schemaText, String jsonText) throws IOException, ProcessingException {
        return JsonSchemaValidator.validateJson(JsonSchemaValidator.getJsonNode(schemaText), JsonSchemaValidator.getJsonNode(jsonText), null);
    }

    public static List<String> validateJson(String schemaText, String jsonText, String namespace) throws IOException, ProcessingException {
        return JsonSchemaValidator.validateJson(JsonSchemaValidator.getJsonNode(schemaText), JsonSchemaValidator.getJsonNode(jsonText), namespace);
    }

    public static List<String> validateJson(JsonNode schemaNode, JsonNode jsonNode) throws ProcessingException {
        return JsonSchemaValidator.validateJson(schemaNode, jsonNode, null);
    }

    public static List<String> validateJson(JsonNode schemaNode, JsonNode jsonNode, String namespace) throws ProcessingException {
        ArrayList<String> errors = new ArrayList<String>();
        JsonSchema jsonSchemaNode = JsonSchemaValidator.extractJsonSchemaNode(schemaNode, namespace);
        ProcessingReport report = jsonSchemaNode.validate(jsonNode, true);
        if (!report.isSuccess()) {
            for (ProcessingMessage processingMessage : report) {
                errors.add(processingMessage.getMessage());
            }
        }
        return errors;
    }

    public static JsonNode getJsonNode(String jsonText) throws IOException {
        return JsonLoader.fromString((String)jsonText);
    }

    public static JsonSchema getSchemaNode(String schemaText) throws IOException, ProcessingException {
        JsonNode schemaNode = JsonSchemaValidator.getJsonNode(schemaText);
        return JsonSchemaValidator.extractJsonSchemaNode(schemaNode, null);
    }

    private static JsonSchema extractJsonSchemaNode(JsonNode jsonNode, String namespace) throws ProcessingException {
        JsonSchemaFactory factory;
        JsonNode schemaIdentifier = jsonNode.get(JSON_SCHEMA_IDENTIFIER_ELEMENT);
        if (schemaIdentifier == null) {
            ((ObjectNode)jsonNode).put(JSON_SCHEMA_IDENTIFIER_ELEMENT, JSON_V7_SCHEMA_IDENTIFIER);
        }
        if (namespace != null) {
            log.debug("Setting namespace to {} in Json schema loading configuration", (Object)namespace);
            LoadingConfiguration cfg = LoadingConfiguration.newBuilder().setURITranslatorConfiguration(URITranslatorConfiguration.newBuilder().setNamespace(namespace).freeze()).freeze();
            factory = JsonSchemaFactory.newBuilder().setLoadingConfiguration(cfg).freeze();
        } else {
            factory = JsonSchemaFactory.byDefault();
        }
        return factory.getJsonSchema(jsonNode);
    }
}

