/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.asyncapi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import io.github.microcks.util.AvroUtil;
import io.github.microcks.util.JsonSchemaValidator;
import io.github.microcks.util.SchemaMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAPISchemaValidator {
    private static Logger log = LoggerFactory.getLogger(AsyncAPISchemaValidator.class);
    public static final String ASYNC_SCHEMA_PAYLOAD_ELEMENT = "payload";
    private static final String ONE_OF_STRUCT = "oneOf";
    private static final String[] STRUCTURES = new String[]{"allOf", "anyOf", "oneOf", "not", "items", "additionalProperties"};
    private static final String[] NOT_SUPPORTED_ATTRIBUTES = new String[]{"discriminator", "externalDocs", "deprecated"};

    private AsyncAPISchemaValidator() {
    }

    public static boolean isJsonValid(String schemaText, String jsonText) throws IOException {
        List<String> errors = AsyncAPISchemaValidator.validateJson(schemaText, jsonText);
        if (!errors.isEmpty()) {
            log.debug("Get validation errors, returning false");
            return false;
        }
        return true;
    }

    public static List<String> validateJson(String schemaText, String jsonText) throws IOException {
        return AsyncAPISchemaValidator.validateJson(AsyncAPISchemaValidator.getJsonNodeForSchema(schemaText), JsonSchemaValidator.getJsonNode(jsonText));
    }

    public static List<String> validateJson(JsonNode schemaNode, JsonNode jsonNode) {
        return AsyncAPISchemaValidator.validateJson(schemaNode, jsonNode, null);
    }

    public static List<String> validateJson(JsonNode schemaNode, JsonNode jsonNode, String namespace) {
        schemaNode = AsyncAPISchemaValidator.convertAsyncAPISchemaToJsonSchema(schemaNode);
        try {
            return JsonSchemaValidator.validateJson(schemaNode, jsonNode, namespace);
        }
        catch (ProcessingException e) {
            log.debug("Got a ProcessingException while trying to interpret schemaNode as a real schema");
            ArrayList<String> errors = new ArrayList<String>();
            errors.add("schemaNode does not seem to represent a valid AsyncAPI schema");
            errors.add("root cause: " + e.getMessage());
            return errors;
        }
    }

    public static List<String> validateJsonMessage(JsonNode specificationNode, JsonNode jsonNode, String messagePathPointer) {
        return AsyncAPISchemaValidator.validateJsonMessage(specificationNode, jsonNode, messagePathPointer, null);
    }

    public static List<String> validateJsonMessage(JsonNode specificationNode, JsonNode jsonNode, String messagePathPointer, String namespace) {
        JsonNode messageNode = specificationNode.at(messagePathPointer);
        if (messageNode == null || messageNode.isMissingNode()) {
            log.debug("messagePathPointer {} is not a valid JSON Pointer", (Object)messagePathPointer);
            return List.of("messagePathPointer does not represent a valid JSON Pointer in AsyncAPI specification");
        }
        messageNode = AsyncAPISchemaValidator.followRefIfAny(messageNode, specificationNode);
        JsonNode schemaNode = null;
        try {
            if (messageNode.isArray()) {
                ArrayNode messagesNode = (ArrayNode)messageNode;
                schemaNode = messagesNode.size() > 1 ? AsyncAPISchemaValidator.buildOneOfMessageSchemaNode(specificationNode, (ArrayNode)messageNode) : AsyncAPISchemaValidator.retrieveSingleMessageSchemaNode(specificationNode, AsyncAPISchemaValidator.followRefIfAny(messagesNode.get(0), specificationNode));
            } else if (messageNode.has(ONE_OF_STRUCT)) {
                ArrayNode oneOfMessageNode = (ArrayNode)messageNode.get(ONE_OF_STRUCT);
                schemaNode = AsyncAPISchemaValidator.buildOneOfMessageSchemaNode(specificationNode, oneOfMessageNode);
            } else {
                schemaNode = AsyncAPISchemaValidator.retrieveSingleMessageSchemaNode(specificationNode, messageNode);
            }
        }
        catch (Exception e) {
            return Arrays.asList(e.getMessage());
        }
        ((ObjectNode)schemaNode).set("components", specificationNode.path("components").deepCopy());
        return AsyncAPISchemaValidator.validateJson(schemaNode, jsonNode, namespace);
    }

    public static List<String> validateAvroMessage(JsonNode specificationNode, byte[] avroBinary, String messagePathPointer, SchemaMap schemaMap) {
        Schema[] avroSchemas;
        try {
            avroSchemas = AsyncAPISchemaValidator.retrieveMessageAvroSchemas(specificationNode, messagePathPointer, schemaMap);
        }
        catch (Exception e) {
            return List.of(e.getMessage());
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (Schema avroSchema : avroSchemas) {
            try {
                AvroUtil.avroToAvroRecord(avroBinary, avroSchema);
                return List.of();
            }
            catch (AvroTypeException ate) {
                errors.add("Avro schema cannot be used to read message: " + ate.getMessage());
            }
            catch (IOException ioe) {
                errors.add("IOException while trying to validate message: " + ioe.getMessage());
            }
        }
        return errors;
    }

    public static List<String> validateAvroMessage(JsonNode specificationNode, GenericRecord avroRecord, String messagePathPointer, SchemaMap schemaMap) {
        Schema[] avroSchemas = null;
        try {
            avroSchemas = AsyncAPISchemaValidator.retrieveMessageAvroSchemas(specificationNode, messagePathPointer, schemaMap);
        }
        catch (Exception e) {
            return List.of(e.getMessage());
        }
        for (Schema avroSchema : avroSchemas) {
            if (!AvroUtil.validate(avroSchema, avroRecord)) continue;
            return List.of();
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (Schema avroSchema : avroSchemas) {
            errors.addAll(AvroUtil.getValidationErrors(avroSchema, avroRecord, new String[0]));
        }
        return errors;
    }

    public static JsonNode getJsonNode(String jsonText) throws IOException {
        return JsonSchemaValidator.getJsonNode(jsonText);
    }

    public static JsonNode getJsonNodeForSchema(String schemaText) throws IOException {
        boolean isYaml = true;
        String line = null;
        BufferedReader reader = new BufferedReader(new StringReader(schemaText));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("{") || line.startsWith("[")) {
                isYaml = false;
                break;
            }
            if (!line.startsWith("---") && !line.startsWith("-") && !line.startsWith("asyncapi: ")) continue;
        }
        reader.close();
        ObjectMapper mapper = null;
        if (isYaml) {
            log.debug("Guessing AsyncAPI spec format is YAML");
            mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        } else {
            log.debug("Guessing AsyncAPI spec format is JSON");
            mapper = new ObjectMapper();
        }
        return mapper.readTree(schemaText);
    }

    private static JsonNode convertAsyncAPISchemaToJsonSchema(JsonNode jsonNode) {
        if (jsonNode.has("components")) {
            AsyncAPISchemaValidator.convertProperties(jsonNode.path("components").path("schemas").elements());
        }
        for (String structure : STRUCTURES) {
            if (!jsonNode.has(structure) || !jsonNode.path(structure).isArray()) continue;
            ArrayNode arrayNode = (ArrayNode)jsonNode.path(structure);
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonNode structureNode = arrayNode.get(i);
                structureNode = AsyncAPISchemaValidator.convertAsyncAPISchemaToJsonSchema(structureNode);
            }
        }
        if (jsonNode.has("type") && jsonNode.path("type").asText().equals("object")) {
            AsyncAPISchemaValidator.convertProperties(jsonNode.path("properties").elements());
        } else {
            AsyncAPISchemaValidator.convertType(jsonNode);
        }
        for (String notSupported : NOT_SUPPORTED_ATTRIBUTES) {
            if (!jsonNode.has(notSupported)) continue;
            ((ObjectNode)jsonNode).remove(notSupported);
        }
        return jsonNode;
    }

    private static void convertProperties(Iterator<JsonNode> properties) {
        while (properties.hasNext()) {
            JsonNode property = properties.next();
            JsonNode jsonNode = AsyncAPISchemaValidator.convertAsyncAPISchemaToJsonSchema(property);
        }
    }

    private static void convertType(JsonNode node) {
        if (node.has("type") && !node.path("type").asText().equals("object") && node.path("nullable").asBoolean()) {
            String type = node.path("type").asText();
            ArrayNode typeArray = ((ObjectNode)node).putArray("type");
            typeArray.add(type).add("null");
        }
    }

    private static JsonNode buildOneOfMessageSchemaNode(JsonNode specificationNode, ArrayNode oneOfMessageNode) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode schemaNode = mapper.createObjectNode();
        ArrayNode oneOfNode = mapper.createArrayNode();
        schemaNode.set(ONE_OF_STRUCT, (JsonNode)oneOfNode);
        for (int i = 0; i < oneOfMessageNode.size(); ++i) {
            JsonNode altMessageNode = oneOfMessageNode.get(i);
            altMessageNode = AsyncAPISchemaValidator.followRefIfAny(altMessageNode, specificationNode);
            oneOfNode.add(AsyncAPISchemaValidator.retrieveSingleMessageSchemaNode(specificationNode, altMessageNode));
        }
        return schemaNode;
    }

    private static JsonNode retrieveSingleMessageSchemaNode(JsonNode specificationNode, JsonNode messageNode) throws Exception {
        if (!messageNode.has(ASYNC_SCHEMA_PAYLOAD_ELEMENT)) {
            log.debug("messageNode {} has no 'payload' attribute", (Object)messageNode);
            throw new Exception("message definition has no valid payload in AsyncAPI specification");
        }
        messageNode = messageNode.path(ASYNC_SCHEMA_PAYLOAD_ELEMENT);
        messageNode = AsyncAPISchemaValidator.followRefIfAny(messageNode, specificationNode);
        return messageNode.deepCopy();
    }

    private static Schema[] retrieveMessageAvroSchemas(JsonNode specificationNode, String messagePathPointer, SchemaMap schemaMap) throws Exception {
        JsonNode messageNode = specificationNode.at(messagePathPointer);
        if (messageNode == null || messageNode.isMissingNode()) {
            log.debug("messagePathPointer {} is not a valid JSON Pointer", (Object)messagePathPointer);
            throw new Exception("messagePathPointer does not represent a valid JSON Pointer in AsyncAPI specification");
        }
        if ((messageNode = AsyncAPISchemaValidator.followRefIfAny(messageNode, specificationNode)).isArray()) {
            ArrayNode messagesNode = (ArrayNode)messageNode;
            if (messagesNode.size() > 1) {
                return AsyncAPISchemaValidator.buildOneOfMessagesAvroSchemas(specificationNode, (ArrayNode)messageNode, schemaMap);
            }
            return new Schema[]{AsyncAPISchemaValidator.buildSingleMessageAvroSchema(specificationNode, AsyncAPISchemaValidator.followRefIfAny(messagesNode.get(0), specificationNode), schemaMap)};
        }
        if (messageNode.has(ONE_OF_STRUCT)) {
            ArrayNode oneOfMessageNode = (ArrayNode)messageNode.get(ONE_OF_STRUCT);
            return AsyncAPISchemaValidator.buildOneOfMessagesAvroSchemas(specificationNode, oneOfMessageNode, schemaMap);
        }
        return new Schema[]{AsyncAPISchemaValidator.buildSingleMessageAvroSchema(specificationNode, messageNode, schemaMap)};
    }

    private static Schema[] buildOneOfMessagesAvroSchemas(JsonNode specificationNode, ArrayNode oneOfMessageNode, SchemaMap schemaMap) throws Exception {
        Schema[] schemas = new Schema[oneOfMessageNode.size()];
        for (int i = 0; i < oneOfMessageNode.size(); ++i) {
            JsonNode altMessageNode = oneOfMessageNode.get(i);
            altMessageNode = AsyncAPISchemaValidator.followRefIfAny(altMessageNode, specificationNode);
            schemas[i] = AsyncAPISchemaValidator.buildSingleMessageAvroSchema(specificationNode, altMessageNode, schemaMap);
        }
        return schemas;
    }

    private static Schema buildSingleMessageAvroSchema(JsonNode specificationNode, JsonNode messageNode, SchemaMap schemaMap) throws Exception {
        if (!messageNode.has(ASYNC_SCHEMA_PAYLOAD_ELEMENT)) {
            log.debug("messageNode {} has no 'payload' attribute", (Object)messageNode);
            throw new Exception("message definition has no valid payload in AsyncAPI specification");
        }
        messageNode = messageNode.path(ASYNC_SCHEMA_PAYLOAD_ELEMENT);
        String schemaContent = null;
        if (messageNode.has("$ref")) {
            String ref = messageNode.path("$ref").asText();
            log.debug("Looking for an external Avro schema in registry: {}", (Object)ref);
            if (ref.contains("#")) {
                ref = ref.substring(0, ref.indexOf("#"));
            }
            if (schemaMap != null) {
                schemaContent = schemaMap.getSchemaEntry(ref);
            }
            if (schemaContent == null) {
                log.info("No schema content found in SchemaMap. {} is not found", (Object)ref);
                throw new Exception("no schema content found for " + ref + " in used SchemaMap.");
            }
        } else {
            schemaContent = messageNode.toString();
        }
        return new Schema.Parser().parse(schemaContent);
    }

    private static JsonNode followRefIfAny(JsonNode referencableNode, JsonNode documentRoot) {
        if (referencableNode.has("$ref")) {
            String ref = referencableNode.path("$ref").asText();
            return AsyncAPISchemaValidator.followRefIfAny(documentRoot.at(ref.substring(1)), documentRoot);
        }
        return referencableNode;
    }
}

