/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.openapi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import io.github.microcks.util.JsonSchemaValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPISchemaValidator {
    private static Logger log = LoggerFactory.getLogger(OpenAPISchemaValidator.class);
    private static final String[] STRUCTURES = new String[]{"allOf", "anyOf", "oneOf", "not", "items", "additionalProperties"};
    private static final String[] NOT_SUPPORTED_ATTRIBUTES = new String[]{"nullable", "discriminator", "readOnly", "writeOnly", "xml", "externalDocs", "example", "deprecated"};

    private OpenAPISchemaValidator() {
    }

    public static boolean isJsonValid(String schemaText, String jsonText) throws IOException {
        return OpenAPISchemaValidator.isJsonValid(schemaText, jsonText, null);
    }

    public static boolean isJsonValid(String schemaText, String jsonText, String namespace) throws IOException {
        List<String> errors = OpenAPISchemaValidator.validateJson(schemaText, jsonText, namespace);
        if (!errors.isEmpty()) {
            log.debug("Get validation errors, returning false");
            return false;
        }
        return true;
    }

    public static List<String> validateJson(String schemaText, String jsonText) throws IOException {
        return OpenAPISchemaValidator.validateJson(schemaText, jsonText, null);
    }

    public static List<String> validateJson(String schemaText, String jsonText, String namespace) throws IOException {
        return OpenAPISchemaValidator.validateJson(OpenAPISchemaValidator.getJsonNodeForSchema(schemaText), JsonSchemaValidator.getJsonNode(jsonText), namespace);
    }

    public static List<String> validateJson(JsonNode schemaNode, JsonNode jsonNode) {
        return OpenAPISchemaValidator.validateJson(schemaNode, jsonNode, null);
    }

    public static List<String> validateJson(JsonNode schemaNode, JsonNode jsonNode, String namespace) {
        schemaNode = OpenAPISchemaValidator.convertOpenAPISchemaToJsonSchema(schemaNode);
        try {
            return JsonSchemaValidator.validateJson(schemaNode, jsonNode, namespace);
        }
        catch (ProcessingException e) {
            log.debug("Got a ProcessingException while trying to interpret schemaNode as a real schema");
            ArrayList<String> errors = new ArrayList<String>();
            errors.add("schemaNode does not seem to represent a valid OpenAPI schema");
            errors.add("root cause: " + e.getMessage());
            return errors;
        }
    }

    public static List<String> validateJsonMessage(JsonNode specificationNode, JsonNode jsonNode, String messagePathPointer, String contentType) {
        return OpenAPISchemaValidator.validateJsonMessage(specificationNode, jsonNode, messagePathPointer, contentType, null);
    }

    public static List<String> validateJsonMessage(JsonNode specificationNode, JsonNode jsonNode, String messagePathPointer, String contentType, String namespace) {
        JsonNode messageNode = specificationNode.at(messagePathPointer);
        if (messageNode == null || messageNode.isMissingNode()) {
            log.debug("messagePathPointer {} is not a valid JSON Pointer", (Object)messagePathPointer);
            return List.of("messagePathPointer does not represent a valid JSON Pointer in OpenAPI specification");
        }
        if (messageNode.has("$ref")) {
            String ref = messageNode.path("$ref").asText();
            messageNode = specificationNode.at(ref.substring(1));
        }
        if ((messageNode = messageNode.at("/content/" + contentType.replace("/", "~1"))) == null || messageNode.isMissingNode()) {
            log.debug("content for {} cannot be found into OpenAPI specification", (Object)contentType);
            return List.of("messagePathPointer does not represent an existing JSON Pointer in OpenAPI specification");
        }
        JsonNode schemaNode = messageNode.path("schema").deepCopy();
        ((ObjectNode)schemaNode).set("components", specificationNode.path("components").deepCopy());
        return OpenAPISchemaValidator.validateJson(schemaNode, jsonNode, namespace);
    }

    public static JsonNode getJsonNode(String jsonText) throws IOException {
        return JsonSchemaValidator.getJsonNode(jsonText);
    }

    public static JsonNode getJsonNodeForSchema(String schemaText) throws IOException {
        boolean isYaml = true;
        String line = null;
        BufferedReader reader = new BufferedReader(new StringReader(schemaText));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("{") || line.startsWith("[")) {
                isYaml = false;
                break;
            }
            if (!line.startsWith("---") && !line.startsWith("-") && !line.startsWith("openapi: ")) continue;
        }
        reader.close();
        ObjectMapper mapper = null;
        if (isYaml) {
            log.debug("Guessing OpenAPI spec format is YAML");
            mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        } else {
            log.debug("Guessing OpenAPI spec format is JSON");
            mapper = new ObjectMapper();
        }
        return mapper.readTree(schemaText);
    }

    private static JsonNode convertOpenAPISchemaToJsonSchema(JsonNode jsonNode) {
        if (jsonNode.has("components")) {
            OpenAPISchemaValidator.convertProperties(jsonNode.path("components").path("schemas").elements());
        }
        for (String structure : STRUCTURES) {
            if (!jsonNode.has(structure) || !jsonNode.path(structure).isArray()) continue;
            ArrayNode arrayNode = (ArrayNode)jsonNode.path(structure);
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonNode structureNode = arrayNode.get(i);
                structureNode = OpenAPISchemaValidator.convertOpenAPISchemaToJsonSchema(structureNode);
            }
        }
        if (jsonNode.has("type") && jsonNode.path("type").asText().equals("object")) {
            OpenAPISchemaValidator.convertProperties(jsonNode.path("properties").elements());
        } else {
            OpenAPISchemaValidator.convertType(jsonNode);
        }
        for (String notSupported : NOT_SUPPORTED_ATTRIBUTES) {
            if (!jsonNode.has(notSupported)) continue;
            ((ObjectNode)jsonNode).remove(notSupported);
        }
        return jsonNode;
    }

    private static void convertProperties(Iterator<JsonNode> properties) {
        while (properties.hasNext()) {
            JsonNode property = properties.next();
            JsonNode jsonNode = OpenAPISchemaValidator.convertOpenAPISchemaToJsonSchema(property);
        }
    }

    private static void convertType(JsonNode node) {
        if (node.has("type") && !node.path("type").asText().equals("object") && node.path("nullable").asBoolean()) {
            String type = node.path("type").asText();
            ArrayNode typeArray = ((ObjectNode)node).putArray("type");
            typeArray.add(type).add("null");
        }
    }
}

