/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.quarkus.deployment;

import io.github.microcks.quarkus.deployment.DevServicesConfig;
import io.github.microcks.quarkus.deployment.MicrocksBuildTimeConfig;
import io.github.microcks.quarkus.deployment.MicrocksContainersEnsembleHosts;
import io.github.microcks.quarkus.runtime.MicrocksProperties;
import io.github.microcks.quarkus.runtime.MicrocksRecorder;
import io.github.microcks.testcontainers.MicrocksAsyncMinionContainer;
import io.github.microcks.testcontainers.MicrocksContainer;
import io.github.microcks.testcontainers.connection.KafkaConnection;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.builder.item.EmptyBuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.logging.Logger;
import org.testcontainers.Testcontainers;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class DevServicesMicrocksProcessor {
    private static final Logger log = Logger.getLogger(DevServicesMicrocksProcessor.class);
    private static final String MICROCKS = "microcks";
    private static final String HTTP_SCHEME = "http://";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-microcks";
    private static final ContainerLocator microcksContainerLocator = new ContainerLocator("quarkus-dev-service-microcks", 8080);
    private static final ContainerLocator microcksContainerLocatorForGRPC = new ContainerLocator("quarkus-dev-service-microcks", 9090);
    private static final List<String> PRIMARY_ARTIFACTS_EXTENSIONS = Arrays.asList("-openapi.yml", "-openapi.yaml", "-openapi.json", ".proto", ".graphql", "-asyncapi.yml", "-asyncapi.yaml", "-asyncapi.json", "-soapui-project.xml");
    private static final List<String> SECONDARY_ARTIFACTS_EXTENSIONS = Arrays.asList("postman-collection.json", "postman_collection.json", "-metadata.yml", "-metadata.yaml", ".har");
    private static final List<String> POSTMAN_COLLECTION_EXTENSIONS = Arrays.asList("postman-collection.json", "postman_collection.json");
    private static volatile List<DevServicesResultBuildItem.RunningDevService> devServices;
    private static volatile MicrocksBuildTimeConfig.DevServiceConfiguration capturedDevServicesConfig;
    private static volatile boolean first;
    private static volatile MicrocksContainersEnsembleHosts ensembleHosts;
    private static volatile boolean aPostmanCollectionIsPresent;

    @BuildStep
    public Optional<DevServicesSharedNetworkBuildItem> prepareSharedNetwork(MicrocksBuildTimeConfig config) {
        MicrocksBuildTimeConfig.DevServiceConfiguration devServicesConfiguration = config.defaultDevService();
        if (!devServicesConfiguration.devservices().enabled()) {
            log.debug((Object)"Not preparing a shared network as Microcks devservices has been disabled in the config");
            return Optional.empty();
        }
        return Optional.of(new DevServicesSharedNetworkBuildItem());
    }

    @BuildStep
    public List<DevServicesResultBuildItem> startMicrocksContainers(LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, MicrocksBuildTimeConfig config, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, CurateOutcomeBuildItem outcomeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        MicrocksBuildTimeConfig.DevServiceConfiguration currentDevServicesConfig = config.defaultDevService();
        if (devServices != null) {
            boolean restartRequired;
            boolean bl = restartRequired = !currentDevServicesConfig.equals(capturedDevServicesConfig);
            if (!restartRequired) {
                return devServices.stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
            }
            for (Closeable closeable : devServices) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop microcks container", e);
                }
            }
            devServices = null;
            capturedDevServicesConfig = null;
        }
        capturedDevServicesConfig = currentDevServicesConfig;
        ArrayList<DevServicesResultBuildItem.RunningDevService> newDevServices = new ArrayList<DevServicesResultBuildItem.RunningDevService>();
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Microcks Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            DevServicesResultBuildItem.RunningDevService runningDevService = this.startContainer(currentDevServicesConfig.devservices(), dockerStatusBuildItem, launchMode.getLaunchMode(), outcomeBuildItem, devServicesConfig.timeout);
            if (runningDevService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
                newDevServices.add(runningDevService);
                String configKey = MicrocksProperties.getConfigPrefix((String)currentDevServicesConfig.devservices().serviceName()) + ".http";
                log.infof("The '%s' microcks container is ready on %s", (Object)currentDevServicesConfig.devservices().serviceName(), runningDevService.getConfig().get(configKey));
            }
        }
        catch (Throwable throwable) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(throwable);
        }
        devServices = newDevServices;
        if (first) {
            first = false;
            Runnable runnable = () -> {
                if (devServices != null) {
                    for (Closeable closeable : devServices) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable t) {
                            log.error((Object)"Failed to stop microcks", t);
                        }
                    }
                }
                first = true;
                devServices = null;
                capturedDevServicesConfig = null;
            };
            closeBuildItem.addCloseTask(runnable, true);
        }
        return devServices.stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
    }

    @BuildStep
    @Produce(value=MicrocksEnsembleBuildItem.class)
    public void completeMicrocksEnsemble(MicrocksBuildTimeConfig config, DevServicesLauncherConfigResultBuildItem devServicesConfigResult, CuratedApplicationShutdownBuildItem closeBuildItem) {
        if (ensembleHosts != null) {
            DockerImageName imageName;
            String microcksHost = ensembleHosts.getMicrocksHost();
            boolean aBrokerIsPresent = false;
            String kafkaBootstrapServers = null;
            for (Map.Entry configEntry : devServicesConfigResult.getConfig().entrySet()) {
                log.debugf("DevServices config: %s=%s", configEntry.getKey(), configEntry.getValue());
                if (!"kafka.bootstrap.servers".equals(configEntry.getKey())) continue;
                kafkaBootstrapServers = configEntry.getValue().toString();
                aBrokerIsPresent = true;
            }
            DevServicesConfig devServiceConfig = config.defaultDevService().devservices();
            DevServicesConfig.EnsembleConfiguration ensembleConfiguration = devServiceConfig.ensemble();
            if (ensembleConfiguration.postmanEnabled() || aPostmanCollectionIsPresent) {
                log.debugf("Starting a GenericContainer with Postman image '%s'", (Object)ensembleConfiguration.postmanImageName());
                imageName = DockerImageName.parse((String)ensembleConfiguration.postmanImageName()).asCompatibleSubstituteFor("quay.io/microcks/microcks-uber-async-minion:latest");
                GenericContainer postmanContainer = new GenericContainer(imageName).withNetwork(Network.SHARED).withNetworkAliases(new String[]{ensembleHosts.getPostmanHost()}).withAccessToHost(true).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*postman-runtime wrapper listening on port.*", (int)1));
                postmanContainer.start();
                closeBuildItem.addCloseTask(() -> ((GenericContainer)postmanContainer).stop(), true);
            }
            if (ensembleConfiguration.asyncEnabled() || aBrokerIsPresent) {
                log.debugf("Starting a MicrocksAsyncMinionContainer with image '%s'", (Object)ensembleConfiguration.asyncImageName());
                imageName = DockerImageName.parse((String)ensembleConfiguration.asyncImageName()).asCompatibleSubstituteFor("quay.io/microcks/microcks-uber-async-minion:latest");
                MicrocksAsyncMinionContainer asyncMinionContainer = (MicrocksAsyncMinionContainer)new MicrocksAsyncMinionContainer(Network.SHARED, imageName, microcksHost).withAccessToHost(true);
                if (kafkaBootstrapServers != null) {
                    if (kafkaBootstrapServers.contains(",")) {
                        String[] kafkaAddresses;
                        for (String kafkaAddress : kafkaAddresses = kafkaBootstrapServers.split(",")) {
                            if (!kafkaAddress.startsWith("PLAINTEXT://")) continue;
                            kafkaBootstrapServers = kafkaAddress.replace("PLAINTEXT://", "");
                        }
                    }
                    log.debugf("Adding a KafkaConnection to '%s' for MicrocksAsyncMinionContainer", (Object)kafkaBootstrapServers);
                    asyncMinionContainer.withKafkaConnection(new KafkaConnection(kafkaBootstrapServers.replace("localhost", "host.testcontainers.internal")));
                }
                List aliases = asyncMinionContainer.getNetworkAliases();
                aliases.add(ensembleHosts.getAsyncMinionHost());
                asyncMinionContainer.setNetworkAliases(aliases);
                asyncMinionContainer.start();
                closeBuildItem.addCloseTask(() -> ((MicrocksAsyncMinionContainer)asyncMinionContainer).stop(), true);
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=MicrocksEnsembleBuildItem.class)
    public void finalizeMicrocksEnsemble(MicrocksRecorder recorder) {
        recorder.record();
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public CardPageBuildItem pages(List<DevServicesResultBuildItem> devServicesResultBuildItems, MicrocksBuildTimeConfig config) {
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        String microcksUIUrl = null;
        String serviceName = config.defaultDevService().devservices().serviceName();
        if (!devServices.isEmpty() && serviceName != null) {
            microcksUIUrl = (String)devServices.get(0).getConfig().get("quarkus.microcks." + serviceName + ".http");
        }
        if (microcksUIUrl != null) {
            cardPageBuildItem.addPage((PageBuilder)Page.externalPageBuilder((String)"Microcks UI").url(microcksUIUrl).isHtmlContent().icon("font-awesome-solid:plug-circle-bolt"));
        }
        return cardPageBuildItem;
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(DevServicesConfig devServicesConfig, DockerStatusBuildItem dockerStatusBuildItem, LaunchMode launchMode, CurateOutcomeBuildItem outcomeBuildItem, Optional<Duration> timeout) {
        if (!devServicesConfig.enabled()) {
            log.info((Object)"Not starting devservices for Microcks as it has been disabled in the config");
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warn((Object)"Please configure quarkus.microcks.hosts or get a working docker instance");
            return null;
        }
        DockerImageName dockerImageName = DockerImageName.parse((String)devServicesConfig.imageName()).asCompatibleSubstituteFor("quay.io/microcks/microcks-uber:latest");
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultMicrocksSupplier = () -> {
            MicrocksContainer microcksContainer = new MicrocksContainer(dockerImageName);
            microcksContainer.withAccessToHost(true);
            Config globalConfig = ConfigProviderResolver.instance().getConfig();
            int testPort = ((OptionalInt)globalConfig.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081);
            if (testPort > 0) {
                Testcontainers.exposeHostPorts((int[])new int[]{testPort});
            }
            microcksContainer.withEnv(devServicesConfig.containerEnv());
            timeout.ifPresent(arg_0 -> ((MicrocksContainer)microcksContainer).withStartupTimeout(arg_0));
            if (launchMode == LaunchMode.DEVELOPMENT) {
                microcksContainer.withLabel(DEV_SERVICE_LABEL, devServicesConfig.serviceName());
            }
            String microcksHost = ConfigureUtil.configureSharedNetwork((GenericContainer)microcksContainer, (String)devServicesConfig.serviceName());
            String postmanHost = String.format("%s-%s-%s-%s", MICROCKS, devServicesConfig.serviceName(), "postman", Base58.randomString((int)5));
            String asyncMinionHost = String.format("%s-%s-%s-%s", MICROCKS, devServicesConfig.serviceName(), "async-minion", Base58.randomString((int)5));
            ensembleHosts = new MicrocksContainersEnsembleHosts(microcksHost, postmanHost, asyncMinionHost);
            ((MicrocksContainer)((MicrocksContainer)microcksContainer.withEnv("POSTMAN_RUNNER_URL", HTTP_SCHEME + postmanHost + ":3000")).withEnv("TEST_CALLBACK_URL", HTTP_SCHEME + microcksHost + ":8080")).withEnv("ASYNC_MINION_URL", HTTP_SCHEME + asyncMinionHost + ":8081");
            microcksContainer.start();
            LoadedArtifacts loadedArtifacts = this.initializeArtifacts(microcksContainer, devServicesConfig, outcomeBuildItem);
            return new DevServicesResultBuildItem.RunningDevService(devServicesConfig.serviceName(), microcksContainer.getContainerId(), () -> ((MicrocksContainer)microcksContainer).close(), this.getDevServiceExposedConfig(devServicesConfig.serviceName(), "localhost", microcksContainer.getMappedPort(8080), microcksContainer.getMappedPort(9090), loadedArtifacts));
        };
        return microcksContainerLocator.locateContainer(devServicesConfig.serviceName(), devServicesConfig.shared(), launchMode).map(containerAddress -> microcksContainerLocatorForGRPC.locateContainer(devServicesConfig.serviceName(), devServicesConfig.shared(), launchMode).map(containerAddressForGRPC -> new DevServicesResultBuildItem.RunningDevService(devServicesConfig.serviceName(), containerAddress.getId(), null, this.getDevServiceExposedConfig(devServicesConfig.serviceName(), containerAddress.getHost(), containerAddress.getPort(), containerAddressForGRPC.getPort()))).orElseGet(defaultMicrocksSupplier)).orElseGet(defaultMicrocksSupplier);
    }

    private Map<String, String> getDevServiceExposedConfig(String serviceName, String visibleHostName, Integer httpPort, Integer grpcPort) {
        String configPrefix = MicrocksProperties.getConfigPrefix((String)serviceName);
        return Map.of(configPrefix + ".http", HTTP_SCHEME + visibleHostName + ":" + httpPort.toString(), configPrefix + ".http.host", visibleHostName, configPrefix + ".http.port", httpPort.toString(), configPrefix + ".grpc", HTTP_SCHEME + visibleHostName + ":" + grpcPort.toString(), configPrefix + ".grpc.host", visibleHostName, configPrefix + ".grpc.port", grpcPort.toString());
    }

    private Map<String, String> getDevServiceExposedConfig(String serviceName, String visibleHostName, Integer httpPort, Integer grpcPort, LoadedArtifacts loadedArtifacts) {
        String configPrefix = MicrocksProperties.getConfigPrefix((String)serviceName);
        return Map.of(configPrefix + ".http", HTTP_SCHEME + visibleHostName + ":" + httpPort.toString(), configPrefix + ".http.host", visibleHostName, configPrefix + ".http.port", httpPort.toString(), configPrefix + ".grpc", HTTP_SCHEME + visibleHostName + ":" + grpcPort.toString(), configPrefix + ".grpc.host", visibleHostName, configPrefix + ".grpc.port", grpcPort.toString(), configPrefix + ".primary-artifacts", String.join((CharSequence)",", loadedArtifacts.primaryArtifacts), configPrefix + ".secondary-artifacts", String.join((CharSequence)",", loadedArtifacts.secondaryArtifacts));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LoadedArtifacts initializeArtifacts(MicrocksContainer microcksContainer, DevServicesConfig devServicesConfig, CurateOutcomeBuildItem outcomeBuildItem) {
        LoadedArtifacts loadedArtifacts = new LoadedArtifacts();
        if (devServicesConfig.remoteArtifacts().isPresent()) {
            DevServicesConfig.ArtifactsConfiguration remoteArtifactsConfig = devServicesConfig.remoteArtifacts().get();
            try {
                for (String remoteArtifactUrl : remoteArtifactsConfig.primaries()) {
                    log.infof("Load '%s' as primary remote artifact", (Object)remoteArtifactUrl);
                    microcksContainer.downloadAsMainRemoteArtifact(remoteArtifactUrl);
                }
                if (remoteArtifactsConfig.secondaries().isPresent()) {
                    for (String remoteArtifactUrl : remoteArtifactsConfig.secondaries().get()) {
                        log.infof("Load '%s' as secondary remote artifact", (Object)remoteArtifactUrl);
                        microcksContainer.downloadAsSecondaryRemoteArtifact(remoteArtifactUrl);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to load Remote Artifacts in microcks", (Throwable)e);
            }
        }
        if (devServicesConfig.artifacts().isPresent()) {
            DevServicesConfig.ArtifactsConfiguration artifactsConfig = devServicesConfig.artifacts().get();
            try {
                for (String primaryArtifact : artifactsConfig.primaries()) {
                    log.infof("Load '%s' as primary artifact", (Object)primaryArtifact);
                    this.addToLoadedArtifacts(primaryArtifact, loadedArtifacts, true);
                    microcksContainer.importAsMainArtifact(new File(primaryArtifact));
                }
                if (!artifactsConfig.secondaries().isPresent()) return loadedArtifacts;
                for (String secondaryArtifact : artifactsConfig.secondaries().get()) {
                    log.infof("Load '%s' as secondary artifact", (Object)secondaryArtifact);
                    this.addToLoadedArtifacts(secondaryArtifact, loadedArtifacts, false);
                    microcksContainer.importAsSecondaryArtifact(new File(secondaryArtifact));
                }
                return loadedArtifacts;
            }
            catch (Exception e) {
                log.error((Object)"Failed to load Artifacts in microcks", (Throwable)e);
                return loadedArtifacts;
            }
        }
        try {
            loadedArtifacts.primaryArtifacts = this.scanAndLoadPrimaryArtifacts(microcksContainer, outcomeBuildItem);
            if (loadedArtifacts.primaryArtifacts.isEmpty()) return loadedArtifacts;
            loadedArtifacts.secondaryArtifacts = this.scanAndLoadSecondaryArtifacts(microcksContainer, outcomeBuildItem);
            return loadedArtifacts;
        }
        catch (Exception e) {
            log.error((Object)"Failed to load Artifacts in microcks", (Throwable)e);
        }
        return loadedArtifacts;
    }

    private void addToLoadedArtifacts(String artifact, LoadedArtifacts loadedArtifacts, boolean primary) {
        String targetName = artifact;
        if (artifact.contains("target/classes/")) {
            targetName = artifact.substring(artifact.indexOf("target/classes/") + "target/classes/".length() + 1);
        } else if (artifact.contains("target/test-classes")) {
            targetName = artifact.substring(artifact.indexOf("target/test-classes/") + "target/test-classes/".length() + 1);
        }
        if (primary) {
            loadedArtifacts.primaryArtifacts.add(targetName);
        } else {
            loadedArtifacts.secondaryArtifacts.add(targetName);
        }
    }

    private List<String> scanAndLoadPrimaryArtifacts(MicrocksContainer microcksContainer, CurateOutcomeBuildItem outcomeBuildItem) throws Exception {
        return this.scanAndLoadArtifacts(microcksContainer, outcomeBuildItem, PRIMARY_ARTIFACTS_EXTENSIONS, true);
    }

    private List<String> scanAndLoadSecondaryArtifacts(MicrocksContainer microcksContainer, CurateOutcomeBuildItem outcomeBuildItem) throws Exception {
        return this.scanAndLoadArtifacts(microcksContainer, outcomeBuildItem, SECONDARY_ARTIFACTS_EXTENSIONS, false);
    }

    private List<String> scanAndLoadArtifacts(MicrocksContainer microcksContainer, CurateOutcomeBuildItem outcomeBuildItem, List<String> validSuffixes, boolean primary) throws Exception {
        ArrayList<String> loadedArtifacts = new ArrayList<String>();
        ArrayList resourceDirs = new ArrayList();
        resourceDirs.addAll(outcomeBuildItem.getApplicationModel().getApplicationModule().getMainSources().getResourceDirs());
        resourceDirs.addAll(outcomeBuildItem.getApplicationModel().getApplicationModule().getTestSources().getResourceDirs());
        HashMap<File, String> filesAndRelativePath = new HashMap<File, String>();
        for (SourceDir sourceDir : resourceDirs) {
            filesAndRelativePath.putAll(this.collectFilesAndRelativePaths(sourceDir.getDir(), validSuffixes));
        }
        for (Map.Entry entry : filesAndRelativePath.entrySet()) {
            loadedArtifacts.add((String)entry.getValue());
            if (primary) {
                log.infof("Load '%s' as primary artifact", (Object)((File)entry.getKey()).getName());
                microcksContainer.importAsMainArtifact((File)entry.getKey());
                continue;
            }
            log.infof("Load '%s' as secondary artifact", (Object)((File)entry.getKey()).getName());
            microcksContainer.importAsSecondaryArtifact((File)entry.getKey());
        }
        return loadedArtifacts;
    }

    private Map<File, String> collectFilesAndRelativePaths(Path dir, List<String> validSuffixes) throws IOException {
        HashMap<File, String> filesPaths = new HashMap<File, String>();
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(dir, 2, new FileVisitOption[0]);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).filter(candidate -> DevServicesMicrocksProcessor.endsWithOneOf(candidate.getName(), validSuffixes)).forEach(file -> filesPaths.put((File)file, dir.relativize(file.toPath()).toString()));
            }
        }
        return filesPaths;
    }

    private static boolean endsWithOneOf(String candidate, List<String> validSuffixes) {
        for (String validSuffix : validSuffixes) {
            if (!candidate.endsWith(validSuffix)) continue;
            if (DevServicesMicrocksProcessor.isAPostmanCollection(candidate)) {
                aPostmanCollectionIsPresent = true;
            }
            return true;
        }
        return false;
    }

    private static boolean isAPostmanCollection(String candidate) {
        for (String postmanSuffix : POSTMAN_COLLECTION_EXTENSIONS) {
            if (!candidate.endsWith(postmanSuffix)) continue;
            return true;
        }
        return false;
    }

    static {
        first = true;
        aPostmanCollectionIsPresent = false;
    }

    static class LoadedArtifacts {
        List<String> primaryArtifacts = new ArrayList<String>();
        List<String> secondaryArtifacts = new ArrayList<String>();

        LoadedArtifacts() {
        }
    }

    public static final class MicrocksEnsembleBuildItem
    extends EmptyBuildItem {
    }
}

