/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.quarkus.deployment;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigGroup
public interface DevServicesConfig {
    public static final String MICROCKS_UBER_LATEST = "quay.io/microcks/microcks-uber:latest";
    public static final String MICROCKS_UBER_ASYNC_MINION_LATEST = "quay.io/microcks/microcks-uber-async-minion:latest";
    public static final String MICROCKS_POSTMAN_LATEST = "quay.io/microcks/microcks-postman-runtime:latest";

    @WithDefault(value="true")
    public boolean enabled();

    @WithDefault(value="quay.io/microcks/microcks-uber:latest")
    public String imageName();

    @WithDefault(value="true")
    public boolean shared();

    @WithDefault(value="default")
    public String serviceName();

    public Map<String, String> containerEnv();

    public Optional<ArtifactsConfiguration> artifacts();

    public Optional<ArtifactsConfiguration> remoteArtifacts();

    public EnsembleConfiguration ensemble();

    @ConfigGroup
    public static interface EnsembleConfiguration {
        @WithDefault(value="false")
        public boolean asyncEnabled();

        @WithDefault(value="quay.io/microcks/microcks-uber-async-minion:latest")
        public String asyncImageName();

        @WithDefault(value="false")
        public boolean postmanEnabled();

        @WithDefault(value="quay.io/microcks/microcks-postman-runtime:latest")
        public String postmanImageName();

        default public boolean enabled() {
            return this.asyncEnabled() || this.postmanEnabled();
        }
    }

    @ConfigGroup
    public static interface ArtifactsConfiguration {
        public List<String> primaries();

        public Optional<List<String>> secondaries();
    }
}

