/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.quarkus.runtime;

import io.github.microcks.quarkus.runtime.MicrocksProperties;
import io.github.microcks.testcontainers.MicrocksContainer;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.logging.Log;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.logging.Logger;

public class ArtifactsHotReplacementSetup
implements HotReplacementSetup {
    private static final Logger log = Logger.getLogger(ArtifactsHotReplacementSetup.class);

    public void setupHotDeployment(HotReplacementContext context) {
        context.consumeNoRestartChanges(files -> {
            Config globalConfig = ConfigProviderResolver.instance().getConfig();
            String configPrefix = MicrocksProperties.getConfigPrefix("default");
            String microcksContainerUrl = (String)globalConfig.getValue(configPrefix + ".http", String.class);
            Optional primaryArtifacts = globalConfig.getOptionalValue(configPrefix + ".primary-artifacts", String.class);
            Optional secondaryArtifacts = globalConfig.getOptionalValue(configPrefix + ".secondary-artifacts", String.class);
            if (log.isInfoEnabled()) {
                log.infof("Microcks container Url for hot replacement: %s", (Object)microcksContainerUrl);
                log.infof("Microcks primary artifacts: %s", (Object)primaryArtifacts);
                log.infof("Microcks secondary artifacts: %s", (Object)secondaryArtifacts);
                log.infof("Changed files: %s", (Object)String.join((CharSequence)",", files));
            }
            primaryArtifacts.ifPresent(s -> Arrays.stream(s.split(",")).filter(files::contains).forEach(file -> {
                URL fileUrl = Thread.currentThread().getContextClassLoader().getResource((String)file);
                this.importArtifactInMicrocks(microcksContainerUrl, new File(fileUrl.getFile()), true);
            }));
            secondaryArtifacts.ifPresent(s -> Arrays.stream(s.split(",")).filter(files::contains).forEach(file -> {
                URL fileUrl = Thread.currentThread().getContextClassLoader().getResource((String)file);
                this.importArtifactInMicrocks(microcksContainerUrl, new File(fileUrl.getFile()), false);
            }));
        });
    }

    private void importArtifactInMicrocks(String microcksContainerUrl, File artifactFile, boolean mainArtifact) {
        try {
            MicrocksContainer.importArtifact((String)microcksContainerUrl, (File)artifactFile, (boolean)mainArtifact);
        }
        catch (Exception e) {
            Log.errorf((String)"Error while importing artifact %s in Microcks: %s", (Object)artifactFile.getName(), (Object)e.getMessage());
        }
    }
}

