/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor;

import io.microsphere.annotation.processor.ResourceProcessor;
import io.microsphere.annotation.processor.model.util.ConfigurationPropertyJSONElementVisitor;
import io.microsphere.annotation.processor.util.MessagerUtils;
import io.microsphere.beans.ConfigurationProperty;
import io.microsphere.json.JSONArray;
import io.microsphere.metadata.ConfigurationPropertyGenerator;
import io.microsphere.metadata.ConfigurationPropertyLoader;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.microsphere.annotation.ConfigurationProperty"})
public class ConfigurationPropertyAnnotationProcessor
extends AbstractProcessor {
    private Messager messager;
    private StringBuilder jsonBuilder;
    private ResourceProcessor classPathResourceProcessor;
    private ConfigurationPropertyJSONElementVisitor jsonElementVisitor;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.jsonBuilder = new StringBuilder();
        this.classPathResourceProcessor = new ResourceProcessor(processingEnv, StandardLocation.CLASS_OUTPUT);
        this.jsonElementVisitor = new ConfigurationPropertyJSONElementVisitor(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.writeMetadata();
        } else {
            this.resolveMetadata(roundEnv);
        }
        return false;
    }

    private void resolveMetadata(RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getRootElements();
        if (!elements.isEmpty()) {
            Iterator<? extends Element> iterator = elements.iterator();
            this.jsonBuilder.append('[');
            while (iterator.hasNext()) {
                Element element = iterator.next();
                element.accept(this.jsonElementVisitor, this.jsonBuilder);
            }
            this.appendGeneratedConfigurationPropertyJSON(this.jsonBuilder);
            int lastIndex = this.jsonBuilder.length() - 1;
            if (',' == this.jsonBuilder.charAt(lastIndex)) {
                this.jsonBuilder.setCharAt(lastIndex, ']');
            } else {
                this.jsonBuilder.append(']');
            }
        }
    }

    private void appendGeneratedConfigurationPropertyJSON(StringBuilder jsonBuilder) {
        List<ConfigurationProperty> configurationProperties = ConfigurationPropertyLoader.loadAll();
        int size = configurationProperties.size();
        for (int i = 0; i < size; ++i) {
            this.appendGeneratedConfigurationPropertyJSON(jsonBuilder, configurationProperties.get(i));
        }
    }

    private void appendGeneratedConfigurationPropertyJSON(StringBuilder jsonBuilder, ConfigurationProperty configurationProperty) {
        ConfigurationPropertyGenerator generator = this.jsonElementVisitor.getGenerator();
        String json = generator.generate(configurationProperty);
        jsonBuilder.append(json).append(',');
    }

    private void writeMetadata() {
        this.classPathResourceProcessor.processInResourceWriter("META-INF/microsphere/configuration-properties.json", writer -> {
            JSONArray jsonArray = new JSONArray(this.jsonBuilder.toString());
            String formatedJSON = jsonArray.toString(2);
            writer.write(formatedJSON);
            MessagerUtils.printNote(this.messager, "The generated metadata JSON of @{} : \n{}", "io.microsphere.annotation.ConfigurationProperty", formatedJSON);
        });
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

