/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor;

import io.microsphere.annotation.processor.util.MessagerUtils;
import io.microsphere.lang.function.ThrowableFunction;
import io.microsphere.reflect.FieldUtils;
import java.util.function.BiFunction;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.JavaFileManager;

public class FilerProcessor {
    private final ProcessingEnvironment processingEnv;

    public FilerProcessor(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public <T> T processInFiler(ThrowableFunction<Filer, T> filerCallback) {
        return (T)this.processInFiler(filerCallback, (filer, e) -> {
            MessagerUtils.printMandatoryWarning(this.processingEnv, "[FilerProcessor] Failed to process in Filer : {}", filer, e);
            return null;
        });
    }

    public <T> T processInFiler(ThrowableFunction<Filer, T> filerCallback, BiFunction<Filer, Throwable, T> exceptionHandler) {
        Filer filer = this.processingEnv.getFiler();
        return filerCallback.execute(filer, exceptionHandler);
    }

    public JavaFileManager getJavaFileManager() {
        return this.processInFiler(filer -> (JavaFileManager)FieldUtils.getFieldValue(filer, "fileManager"));
    }
}

