/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor;

import io.microsphere.annotation.processor.FilerProcessor;
import io.microsphere.annotation.processor.util.MessagerUtils;
import io.microsphere.lang.function.ThrowableConsumer;
import io.microsphere.lang.function.ThrowableFunction;
import io.microsphere.util.ExceptionUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;

public class ResourceProcessor {
    static final boolean FOR_READING = false;
    static final boolean FOR_WRITING = true;
    private final ProcessingEnvironment processingEnv;
    private final JavaFileManager.Location location;
    private final CharSequence moduleAndPackage;
    private final FilerProcessor filerProcessor;
    private final Map<String, FileObject> fileObjectsCache;

    public ResourceProcessor(ProcessingEnvironment processingEnv, JavaFileManager.Location location) {
        this(processingEnv, location, "");
    }

    public ResourceProcessor(ProcessingEnvironment processingEnv, JavaFileManager.Location location, CharSequence moduleAndPackage) {
        this.processingEnv = processingEnv;
        this.location = location;
        this.filerProcessor = new FilerProcessor(processingEnv);
        this.moduleAndPackage = moduleAndPackage;
        this.fileObjectsCache = new HashMap<String, FileObject>();
    }

    public <T> T processInResource(String resourceName, boolean forWriting, ThrowableFunction<Optional<FileObject>, T> resourceCallback) {
        return (T)this.processInResource(resourceName, forWriting, resourceCallback, e -> {
            MessagerUtils.printWarning(this.processingEnv, "[ResourceProcessor] Failed to process the resource[name : '{}' , forWriting : {}]", resourceName, forWriting, e);
            throw ExceptionUtils.wrap(e, RuntimeException.class);
        });
    }

    public <T> T processInResource(String resourceName, boolean forWriting, ThrowableFunction<Optional<FileObject>, T> resourceCallback, Function<Throwable, T> exceptionHandler) {
        return (T)this.filerProcessor.processInFiler(filer -> {
            Optional<FileObject> resourceRef;
            String key = (forWriting ? "W" : "R") + "@" + resourceName;
            FileObject resource = this.fileObjectsCache.get(key);
            if (resource == null) {
                resource = forWriting ? filer.createResource(this.location, this.moduleAndPackage, resourceName, new Element[0]) : filer.getResource(this.location, this.moduleAndPackage, resourceName);
                this.fileObjectsCache.put(key, resource);
            }
            if (forWriting) {
                resourceRef = Optional.of(resource);
            } else if (ResourceProcessor.exists(resource)) {
                resourceRef = Optional.of(resource);
            } else {
                MessagerUtils.printNote(this.processingEnv, "[ResourceProcessor] The resource[relative : '{}' , name : '{}'] does not exist", resourceName, resource.getName());
                resourceRef = Optional.empty();
            }
            return resourceCallback.apply(resourceRef);
        }, (filter, e) -> {
            MessagerUtils.printWarning(this.processingEnv, "[ResourceProcessor] Failed to process the resource[name : '{}']", resourceName, e);
            return exceptionHandler.apply((Throwable)e);
        });
    }

    public Optional<FileObject> getResource(String resourceName, boolean forWriting) {
        return this.processInResource(resourceName, forWriting, resource -> resource);
    }

    public <T> Optional<T> processInResourceInputStream(String resourceName, ThrowableFunction<InputStream, T> streamCallback) {
        return this.processInResourceInputStream(resourceName, streamCallback, (resource, e) -> {
            MessagerUtils.printWarning(this.processingEnv, "[ResourceProcessor] Failed to process the InputStream of the resource[relative : '{}' , name : '{}']", resourceName, resource.getName(), e);
            throw ExceptionUtils.wrap(e, RuntimeException.class);
        });
    }

    public <T> Optional<T> processInResourceInputStream(String resourceName, ThrowableFunction<InputStream, T> streamCallback, BiFunction<FileObject, Throwable, T> exceptionHandler) {
        return this.processInResource(resourceName, false, resourceRef -> resourceRef.map(resource -> {
            Object r;
            block8: {
                InputStream inputStream = resource.openInputStream();
                try {
                    r = streamCallback.apply(inputStream);
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        return exceptionHandler.apply((FileObject)resource, e);
                    }
                }
                inputStream.close();
            }
            return r;
        }));
    }

    public <T> Optional<T> processInResourceReader(String resourceName, ThrowableFunction<Reader, T> readerCallback) {
        return this.processInResourceReader(resourceName, readerCallback, (resource, e) -> {
            MessagerUtils.printWarning(this.processingEnv, "[ResourceProcessor] Failed to process the Reader of the resource[relative : '{}' , name : '{}']", resourceName, resource.getName(), e);
            throw ExceptionUtils.wrap(e, RuntimeException.class);
        });
    }

    public <T> Optional<T> processInResourceReader(String resourceName, ThrowableFunction<Reader, T> readerCallback, BiFunction<FileObject, Throwable, T> exceptionHandler) {
        return this.processInResource(resourceName, false, resourceRef -> resourceRef.map(resource -> {
            Object r;
            block8: {
                Reader reader = resource.openReader(true);
                try {
                    r = readerCallback.apply(reader);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        return exceptionHandler.apply((FileObject)resource, e);
                    }
                }
                reader.close();
            }
            return r;
        }));
    }

    public <T> Optional<T> processInResourceContent(String resourceName, ThrowableFunction<CharSequence, T> contentCallback) {
        return this.processInResourceContent(resourceName, contentCallback, (resource, e) -> {
            MessagerUtils.printWarning(this.processingEnv, "[ResourceProcessor] Failed to process the content of the resource[relative : '{}' , name : '{}']", resourceName, resource.getName(), e);
            throw ExceptionUtils.wrap(e, RuntimeException.class);
        });
    }

    public <T> Optional<T> processInResourceContent(String resourceName, ThrowableFunction<CharSequence, T> contentCallback, BiFunction<FileObject, Throwable, T> exceptionHandler) {
        return this.processInResource(resourceName, false, resourceRef -> resourceRef.map(resource -> {
            try {
                CharSequence content = resource.getCharContent(true);
                return contentCallback.apply(content);
            }
            catch (Throwable e) {
                return exceptionHandler.apply((FileObject)resource, e);
            }
        }));
    }

    public void processInResourceOutputStream(String resourceName, ThrowableConsumer<OutputStream> streamConsumer) {
        this.processInResourceOutputStream(resourceName, streamConsumer, (resource, e) -> {
            MessagerUtils.printWarning(this.processingEnv, "[ResourceProcessor] Failed to process the OutputStream of the resource[relative : '{}' , name : '{}']", resourceName, resource.getName(), e);
            throw ExceptionUtils.wrap(e, RuntimeException.class);
        });
    }

    public void processInResourceOutputStream(String resourceName, ThrowableConsumer<OutputStream> streamConsumer, BiConsumer<FileObject, Throwable> exceptionHandler) {
        this.processInResource(resourceName, true, resourceRef -> resourceRef.map(resource -> {
            try (OutputStream outputStream = resource.openOutputStream();){
                streamConsumer.accept(outputStream);
                outputStream.flush();
            }
            catch (Throwable e) {
                exceptionHandler.accept((FileObject)resource, e);
            }
            return null;
        }));
    }

    public void processInResourceWriter(String resourceName, ThrowableConsumer<Writer> writerConsumer) {
        this.processInResourceWriter(resourceName, writerConsumer, (resource, e) -> {
            MessagerUtils.printWarning(this.processingEnv, "[ResourceProcessor] Failed to process the Writer of the resource[relative : '{}' , name : '{}']", resourceName, resource.getName(), e);
            throw ExceptionUtils.wrap(e, RuntimeException.class);
        });
    }

    public void processInResourceWriter(String resourceName, ThrowableConsumer<Writer> writerConsumer, BiConsumer<FileObject, Throwable> exceptionHandler) {
        this.processInResource(resourceName, true, resourceRef -> resourceRef.map(resource -> {
            try (Writer writer = resource.openWriter();){
                writerConsumer.accept(writer);
                writer.flush();
            }
            catch (Throwable e) {
                exceptionHandler.accept((FileObject)resource, e);
            }
            return null;
        }));
    }

    public static boolean exists(FileObject resource) {
        return resource != null && resource.getLastModified() > 0L;
    }
}

