/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor.model.util;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.processor.model.util.JSONElementVisitor;
import io.microsphere.annotation.processor.util.AnnotationUtils;
import io.microsphere.annotation.processor.util.ElementUtils;
import io.microsphere.annotation.processor.util.TypeUtils;
import io.microsphere.util.Assert;
import java.lang.annotation.ElementType;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;

public abstract class AnnotatedElementJSONElementVisitor
extends JSONElementVisitor {
    protected final ProcessingEnvironment processingEnv;
    protected final Elements elements;
    protected final String annotationClassName;
    protected final DeclaredType annotationType;
    protected final TypeElement annotationTypeElement;
    protected final ElementType[] elementTypes;

    protected AnnotatedElementJSONElementVisitor(ProcessingEnvironment processingEnv, String annotationClassName) {
        Assert.assertNotNull((Object)processingEnv, () -> "The 'processingEnv' argument must not be null");
        Assert.assertNotNull((Object)annotationClassName, () -> "The 'annotationClassName' argument must not be null");
        this.processingEnv = processingEnv;
        this.elements = processingEnv.getElementUtils();
        this.annotationClassName = annotationClassName;
        this.annotationType = TypeUtils.getDeclaredType(processingEnv, annotationClassName);
        this.annotationTypeElement = this.elements.getTypeElement(annotationClassName);
        Assert.assertNotNull((Object)this.annotationTypeElement, () -> "The annotation can't be found by name : " + annotationClassName);
        this.elementTypes = AnnotationUtils.getElementTypes(this.annotationType);
    }

    @Nonnull
    public final String getAnnotationClassName() {
        return this.annotationClassName;
    }

    @Override
    protected boolean supports(Element e) {
        return ElementUtils.matchesElementType(e, this.elementTypes);
    }
}

