/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor.model.util;

import io.microsphere.annotation.processor.model.util.AnnotatedElementJSONElementVisitor;
import io.microsphere.annotation.processor.util.AnnotationUtils;
import io.microsphere.annotation.processor.util.ClassUtils;
import io.microsphere.annotation.processor.util.TypeUtils;
import io.microsphere.beans.ConfigurationProperty;
import io.microsphere.metadata.ConfigurationPropertyGenerator;
import io.microsphere.util.ServiceLoaderUtils;
import io.microsphere.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class ConfigurationPropertyJSONElementVisitor
extends AnnotatedElementJSONElementVisitor {
    public static final String CONFIGURATION_PROPERTY_ANNOTATION_CLASS_NAME = "io.microsphere.annotation.ConfigurationProperty";
    private final ConfigurationPropertyGenerator generator = ServiceLoaderUtils.loadFirstService(ConfigurationPropertyGenerator.class);

    public ConfigurationPropertyJSONElementVisitor(ProcessingEnvironment processingEnv) {
        super(processingEnv, CONFIGURATION_PROPERTY_ANNOTATION_CLASS_NAME);
    }

    @Override
    public Boolean visitVariableAsField(VariableElement field, StringBuilder jsonBuilder) {
        AnnotationMirror annotation = AnnotationUtils.getAnnotation((AnnotatedConstruct)field, this.getAnnotationClassName());
        if (annotation != null) {
            ConfigurationProperty configurationProperty = null;
            Map<ExecutableElement, AnnotationValue> elementValues = AnnotationUtils.getElementValues(annotation);
            for (Map.Entry<ExecutableElement, AnnotationValue> elementValue : elementValues.entrySet()) {
                ExecutableElement attributeMethod = elementValue.getKey();
                String attributeName = AnnotationUtils.getAttributeName(attributeMethod);
                AnnotationValue annotationValue = elementValue.getValue();
                if ("name".equals(attributeName)) {
                    String name = this.resolveName(field, attributeMethod, annotationValue);
                    configurationProperty = new ConfigurationProperty(name);
                    continue;
                }
                if ("type".equals(attributeName)) {
                    String type = this.resolveType(field, attributeMethod, annotationValue);
                    configurationProperty.setType(type);
                    continue;
                }
                if ("defaultValue".equals(attributeName)) {
                    String defaultValue = this.resolveStringValue(attributeMethod, annotationValue);
                    configurationProperty.setDefaultValue(defaultValue);
                    continue;
                }
                if ("required".equals(attributeName)) {
                    boolean required = (Boolean)annotationValue.getValue();
                    configurationProperty.setRequired(required);
                    continue;
                }
                if ("description".equals(attributeName)) {
                    String description = this.resolveDescription(field, attributeMethod, annotationValue);
                    configurationProperty.setDescription(description);
                    continue;
                }
                if (!"source".equals(attributeName)) continue;
                this.setSources(configurationProperty, annotationValue);
            }
            this.setDeclaredClass(configurationProperty, field);
            this.setDeclaredField(configurationProperty, field);
            String json = this.generator.generate(configurationProperty);
            jsonBuilder.append(json);
            jsonBuilder.append(',');
            return true;
        }
        return false;
    }

    public ConfigurationPropertyGenerator getGenerator() {
        return this.generator;
    }

    private String resolveName(VariableElement field, ExecutableElement attributeMethod, AnnotationValue annotationValue) {
        Object value = AnnotationUtils.matchesDefaultAttributeValue(attributeMethod, annotationValue) ? field.getConstantValue() : annotationValue.getValue();
        return (String)value;
    }

    private String resolveType(VariableElement field, ExecutableElement attributeMethod, AnnotationValue annotationValue) {
        Object value = AnnotationUtils.matchesDefaultAttributeValue(attributeMethod, annotationValue) ? field.asType() : annotationValue.getValue();
        TypeMirror type = (TypeMirror)value;
        return TypeUtils.getTypeName(type);
    }

    private String resolveDescription(VariableElement field, ExecutableElement attributeMethod, AnnotationValue annotationValue) {
        String description = this.resolveStringValue(attributeMethod, annotationValue);
        if (StringUtils.isBlank(description)) {
            description = this.elements.getDocComment(field);
        }
        return description;
    }

    private String resolveStringValue(ExecutableElement attributeMethod, AnnotationValue annotationValue) {
        Object value = AnnotationUtils.matchesDefaultAttributeValue(attributeMethod, annotationValue) ? null : annotationValue.getValue();
        return (String)value;
    }

    private void setSources(ConfigurationProperty configurationProperty, AnnotationValue annotationValue) {
        List sources = (List)annotationValue.getValue();
        ConfigurationProperty.Metadata metadata = configurationProperty.getMetadata();
        for (AnnotationValue source : sources) {
            String sourceValue = (String)source.getValue();
            metadata.getSources().add(sourceValue);
        }
    }

    private void setDeclaredClass(ConfigurationProperty configurationProperty, VariableElement field) {
        Element element = field.getEnclosingElement();
        String declaredClassName = ClassUtils.getClassName(element.asType());
        configurationProperty.getMetadata().setDeclaredClass(declaredClassName);
    }

    private void setDeclaredField(ConfigurationProperty configurationProperty, VariableElement field) {
        String declaredFieldName = field.getSimpleName().toString();
        configurationProperty.getMetadata().setDeclaredField(declaredFieldName);
    }
}

