/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor.model.util;

import io.microsphere.annotation.processor.util.AnnotationUtils;
import io.microsphere.annotation.processor.util.TypeUtils;
import io.microsphere.json.JSONUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;

public class JSONAnnotationValueVisitor
extends SimpleAnnotationValueVisitor6<StringBuilder, ExecutableElement> {
    private final StringBuilder jsonBuilder;

    public JSONAnnotationValueVisitor(StringBuilder jsonBuilder) {
        super(jsonBuilder);
        this.jsonBuilder = jsonBuilder;
    }

    @Override
    public StringBuilder visitBoolean(boolean value, ExecutableElement attributeMethod) {
        JSONUtils.append(this.jsonBuilder, AnnotationUtils.getAttributeName(attributeMethod), value);
        return this.jsonBuilder;
    }

    @Override
    public StringBuilder visitByte(byte value, ExecutableElement attributeMethod) {
        JSONUtils.append(this.jsonBuilder, AnnotationUtils.getAttributeName(attributeMethod), value);
        return this.jsonBuilder;
    }

    @Override
    public StringBuilder visitChar(char value, ExecutableElement attributeMethod) {
        JSONUtils.append(this.jsonBuilder, AnnotationUtils.getAttributeName(attributeMethod), value);
        return this.jsonBuilder;
    }

    @Override
    public StringBuilder visitDouble(double value, ExecutableElement attributeMethod) {
        JSONUtils.append(this.jsonBuilder, AnnotationUtils.getAttributeName(attributeMethod), value);
        return this.jsonBuilder;
    }

    @Override
    public StringBuilder visitFloat(float value, ExecutableElement attributeMethod) {
        JSONUtils.append(this.jsonBuilder, AnnotationUtils.getAttributeName(attributeMethod), value);
        return this.jsonBuilder;
    }

    @Override
    public StringBuilder visitInt(int value, ExecutableElement attributeMethod) {
        JSONUtils.append(this.jsonBuilder, AnnotationUtils.getAttributeName(attributeMethod), value);
        return this.jsonBuilder;
    }

    @Override
    public StringBuilder visitLong(long value, ExecutableElement attributeMethod) {
        JSONUtils.append(this.jsonBuilder, AnnotationUtils.getAttributeName(attributeMethod), value);
        return this.jsonBuilder;
    }

    @Override
    public StringBuilder visitShort(short value, ExecutableElement attributeMethod) {
        JSONUtils.append(this.jsonBuilder, AnnotationUtils.getAttributeName(attributeMethod), value);
        return this.jsonBuilder;
    }

    @Override
    public StringBuilder visitString(String value, ExecutableElement attributeMethod) {
        JSONUtils.append(this.jsonBuilder, AnnotationUtils.getAttributeName(attributeMethod), value);
        return this.jsonBuilder;
    }

    @Override
    public StringBuilder visitType(TypeMirror value, ExecutableElement attributeMethod) {
        JSONUtils.append(this.jsonBuilder, AnnotationUtils.getAttributeName(attributeMethod), TypeUtils.getTypeName(value));
        return this.jsonBuilder;
    }

    @Override
    public StringBuilder visitEnumConstant(VariableElement value, ExecutableElement attributeMethod) {
        JSONUtils.append(this.jsonBuilder, AnnotationUtils.getAttributeName(attributeMethod), value.getSimpleName().toString());
        return this.jsonBuilder;
    }

    @Override
    public StringBuilder visitAnnotation(AnnotationMirror value, ExecutableElement attributeMethod) {
        Map<ExecutableElement, AnnotationValue> elementValues = AnnotationUtils.getElementValues(value);
        Iterator<Map.Entry<ExecutableElement, AnnotationValue>> iterator = elementValues.entrySet().iterator();
        StringBuilder annotationJsonBuilder = new StringBuilder();
        annotationJsonBuilder.append('{');
        JSONAnnotationValueVisitor visitor = new JSONAnnotationValueVisitor(annotationJsonBuilder);
        while (iterator.hasNext()) {
            Map.Entry<ExecutableElement, AnnotationValue> entry = iterator.next();
            AnnotationValue annotationValue = entry.getValue();
            visitor.visit(annotationValue, entry.getKey());
            if (!iterator.hasNext()) continue;
            annotationJsonBuilder.append(',');
        }
        annotationJsonBuilder.append('}');
        return this.doAppend(attributeMethod, annotationJsonBuilder);
    }

    @Override
    public StringBuilder visitArray(List<? extends AnnotationValue> values, ExecutableElement attributeMethod) {
        StringBuilder arrayJsonBuilder = new StringBuilder();
        arrayJsonBuilder.append('[');
        int size = values.size();
        JSONAnnotationValueVisitor visitor = new JSONAnnotationValueVisitor(arrayJsonBuilder);
        for (int i = 0; i < size; ++i) {
            AnnotationValue annotationValue = values.get(i);
            annotationValue.accept(visitor, null);
            if (i >= size - 1) continue;
            arrayJsonBuilder.append(',');
        }
        arrayJsonBuilder.append(']');
        return this.doAppend(attributeMethod, arrayJsonBuilder);
    }

    @Override
    public StringBuilder visitUnknown(AnnotationValue annotationValue, ExecutableElement attributeMethod) {
        return this.jsonBuilder;
    }

    protected StringBuilder doAppend(ExecutableElement attributeMethod, StringBuilder value) {
        JSONUtils.appendName(this.jsonBuilder, AnnotationUtils.getAttributeName(attributeMethod)).append((CharSequence)value);
        return this.jsonBuilder;
    }
}

