/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor.model.util;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementKindVisitor6;

public abstract class JSONElementVisitor
extends ElementKindVisitor6<Boolean, StringBuilder> {
    public JSONElementVisitor() {
        super(Boolean.FALSE);
    }

    @Override
    public final Boolean visitPackage(PackageElement e, StringBuilder jsonBuilder) {
        return this.supportsPackage(e) && this.doVisitPackage(e, jsonBuilder);
    }

    @Override
    public final Boolean visitVariable(VariableElement e, StringBuilder stringBuilder) {
        return this.supportsVariable(e) && (Boolean)super.visitVariable(e, stringBuilder) != false;
    }

    @Override
    public final Boolean visitExecutable(ExecutableElement e, StringBuilder jsonBuilder) {
        return this.supportsExecutable(e) && (Boolean)super.visitExecutable(e, jsonBuilder) != false;
    }

    @Override
    public final Boolean visitType(TypeElement e, StringBuilder jsonBuilder) {
        boolean appended = false;
        if (this.supportsType(e) && ((Boolean)super.visitType(e, jsonBuilder)).booleanValue()) {
            appended = true;
        }
        if (this.visitMembers(e.getEnclosedElements(), jsonBuilder)) {
            appended = true;
        }
        return appended;
    }

    @Override
    public final Boolean visitTypeParameter(TypeParameterElement e, StringBuilder jsonBuilder) {
        if (!this.supports(e)) {
            return Boolean.FALSE;
        }
        boolean appended = false;
        if (this.supportsTypeParameter(e) && this.doVisitTypeParameter(e, jsonBuilder)) {
            appended = true;
        }
        if (this.visitMembers(e.getEnclosedElements(), jsonBuilder)) {
            appended = true;
        }
        return appended;
    }

    protected boolean visitMembers(List<? extends Element> members, StringBuilder jsonBuilder) {
        boolean appended = false;
        for (Element element : members) {
            if (!element.accept(this, jsonBuilder).booleanValue()) continue;
            appended = true;
        }
        return appended;
    }

    protected boolean supports(Element e) {
        return true;
    }

    protected boolean supportsPackage(PackageElement e) {
        return this.supports(e);
    }

    protected boolean supportsVariable(VariableElement e) {
        return this.supports(e);
    }

    protected boolean supportsExecutable(ExecutableElement e) {
        return this.supports(e);
    }

    protected boolean supportsType(TypeElement e) {
        return this.supports(e);
    }

    protected boolean supportsTypeParameter(TypeParameterElement e) {
        return this.supports(e);
    }

    protected boolean doVisitPackage(PackageElement e, StringBuilder jsonBuilder) {
        return (Boolean)super.visitPackage(e, jsonBuilder);
    }

    protected boolean doVisitTypeParameter(TypeParameterElement e, StringBuilder jsonBuilder) {
        return (Boolean)super.visitTypeParameter(e, jsonBuilder);
    }
}

