/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor.model.util;

import io.microsphere.annotation.processor.util.AnnotationUtils;
import io.microsphere.annotation.processor.util.ClassUtils;
import io.microsphere.collection.MapUtils;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.ClassLoaderUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;

public class ResolvableAnnotationValueVisitor
extends SimpleAnnotationValueVisitor6<Object, ExecutableElement> {
    private static final Class<?> ANNOTATION_PARSER_CLASS = ClassLoaderUtils.resolveClass("sun.reflect.annotation.AnnotationParser");
    private static final Method annotationForMapMethod = MethodUtils.findMethod(ANNOTATION_PARSER_CLASS, "annotationForMap", Class.class, Map.class);
    private static final boolean DEFAULT_CLASS_VALUES_AS_STRING = false;
    private static final boolean DEFAULT_NESTED_ANNOTATIONS_AS_MAP = false;
    private final boolean classValuesAsString;
    private final boolean nestedAnnotationsAsMap;

    public ResolvableAnnotationValueVisitor() {
        this(false, false);
    }

    public ResolvableAnnotationValueVisitor(boolean classValuesAsString) {
        this(classValuesAsString, false);
    }

    public ResolvableAnnotationValueVisitor(boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        this.classValuesAsString = classValuesAsString;
        this.nestedAnnotationsAsMap = nestedAnnotationsAsMap;
    }

    @Override
    public Object visitBoolean(boolean b, ExecutableElement attributeMethod) {
        return b;
    }

    @Override
    public Object visitByte(byte b, ExecutableElement attributeMethod) {
        return b;
    }

    @Override
    public Object visitChar(char c, ExecutableElement attributeMethod) {
        return Character.valueOf(c);
    }

    @Override
    public Object visitDouble(double d, ExecutableElement attributeMethod) {
        return d;
    }

    @Override
    public Object visitFloat(float f, ExecutableElement attributeMethod) {
        return Float.valueOf(f);
    }

    @Override
    public Object visitInt(int i, ExecutableElement attributeMethod) {
        return i;
    }

    @Override
    public Object visitLong(long i, ExecutableElement attributeMethod) {
        return i;
    }

    @Override
    public Object visitShort(short s, ExecutableElement attributeMethod) {
        return s;
    }

    @Override
    public Object visitString(String s, ExecutableElement attributeMethod) {
        return s;
    }

    @Override
    public Object visitType(TypeMirror t, ExecutableElement attributeMethod) {
        return this.classValuesAsString ? t.toString() : ClassUtils.loadClass(t);
    }

    @Override
    public Object visitEnumConstant(VariableElement c, ExecutableElement attributeMethod) {
        Class enumClass = ClassUtils.loadClass(c.asType());
        return Enum.valueOf(enumClass, c.toString());
    }

    @Override
    public Object visitAnnotation(AnnotationMirror a, ExecutableElement attributeMethod) {
        Map<ExecutableElement, AnnotationValue> elementValues = AnnotationUtils.getElementValues(a);
        Map<String, Object> attributesMap = MapUtils.newFixedLinkedHashMap(elementValues.size());
        for (Map.Entry<ExecutableElement, AnnotationValue> entry : elementValues.entrySet()) {
            ExecutableElement method = entry.getKey();
            String attributeName = AnnotationUtils.getAttributeName(method);
            Object attributeValue = entry.getValue().accept(this, method);
            attributesMap.put(attributeName, attributeValue);
        }
        if (this.nestedAnnotationsAsMap) {
            return attributesMap;
        }
        Class annotationClass = ClassUtils.loadClass(a.getAnnotationType());
        return MethodUtils.invokeStaticMethod(annotationForMapMethod, annotationClass, attributesMap);
    }

    @Override
    public Object visitArray(List<? extends AnnotationValue> values, ExecutableElement attributeMethod) {
        int size = values.size();
        Class<?> componentType = this.getComponentType(attributeMethod);
        E[] array = ArrayUtils.newArray(componentType, size);
        for (int i = 0; i < size; ++i) {
            AnnotationValue value = values.get(i);
            Object attributeValue = value.accept(this, attributeMethod);
            Array.set(array, i, attributeValue);
        }
        return array;
    }

    Class<?> getComponentType(ExecutableElement attributeMethod) {
        if (this.classValuesAsString) {
            return String.class;
        }
        ArrayType arrayType = (ArrayType)attributeMethod.getReturnType();
        return ClassUtils.loadClass(arrayType.getComponentType());
    }

    @Override
    public Object visitUnknown(AnnotationValue av, ExecutableElement attributeMethod) {
        return av;
    }
}

