/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor.util;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.annotation.processor.model.util.ResolvableAnnotationValueVisitor;
import io.microsphere.annotation.processor.util.MethodUtils;
import io.microsphere.annotation.processor.util.TypeUtils;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.MapUtils;
import io.microsphere.lang.function.Predicates;
import io.microsphere.lang.function.Streams;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.StringUtils;
import io.microsphere.util.Utils;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public interface AnnotationUtils
extends Utils {
    public static final String VALUE_ATTRIBUTE_NAME = "value";
    public static final AnnotationValueVisitor<Object, ExecutableElement> DEFAULT_ANNOTATION_VALUE_VISITOR = new ResolvableAnnotationValueVisitor();
    @Immutable
    public static final ElementType[] EMPTY_ELEMENT_TYPE_ARRAY = new ElementType[0];
    public static final boolean WITH_DEFAULT = true;

    public static AnnotationMirror getAnnotation(AnnotatedConstruct annotatedConstruct, Class<? extends Annotation> annotationClass) {
        if (annotatedConstruct == null || annotationClass == null) {
            return null;
        }
        return AnnotationUtils.getAnnotation(annotatedConstruct, annotationClass.getName());
    }

    public static AnnotationMirror getAnnotation(AnnotatedConstruct annotatedConstruct, CharSequence annotationClassName) {
        if (annotatedConstruct == null || annotationClassName == null) {
            return null;
        }
        List<AnnotationMirror> annotations = AnnotationUtils.getAnnotations(annotatedConstruct, annotationClassName);
        return annotations.isEmpty() ? null : annotations.get(0);
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> getAnnotations(AnnotatedConstruct annotatedConstruct) {
        if (annotatedConstruct == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.findAnnotations(annotatedConstruct, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> getAnnotations(AnnotatedConstruct annotatedConstruct, Class<? extends Annotation> annotationClass) {
        if (annotatedConstruct == null || annotationClass == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.getAnnotations(annotatedConstruct, annotationClass.getTypeName());
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> getAnnotations(AnnotatedConstruct annotatedConstruct, CharSequence annotationClassName) {
        if (annotatedConstruct == null || annotationClassName == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.findAnnotations(annotatedConstruct, annotation -> AnnotationUtils.matchesAnnotationTypeName(annotation, annotationClassName));
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> getAllAnnotations(TypeMirror type) {
        if (type == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.getAllAnnotations(TypeUtils.ofTypeElement(type));
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> getAllAnnotations(Element element) {
        if (element == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.findAllAnnotations(element, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> getAllAnnotations(TypeMirror type, Class<? extends Annotation> annotationClass) {
        if (type == null || annotationClass == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.getAllAnnotations((Element)TypeUtils.ofTypeElement(type), annotationClass);
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> getAllAnnotations(Element element, Class<? extends Annotation> annotationClass) {
        if (element == null || annotationClass == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.getAllAnnotations(element, (CharSequence)annotationClass.getTypeName());
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> getAllAnnotations(TypeMirror type, CharSequence annotationClassName) {
        if (type == null || annotationClassName == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.getAllAnnotations((Element)TypeUtils.ofTypeElement(type), annotationClassName);
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> getAllAnnotations(Element element, CharSequence annotationClassName) {
        if (element == null || annotationClassName == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.findAllAnnotations(element, annotation -> AnnotationUtils.matchesAnnotationTypeName(annotation, annotationClassName));
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> getAllAnnotations(ProcessingEnvironment processingEnv, Type annotatedType) {
        if (processingEnv == null || annotatedType == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.findAllAnnotations(processingEnv, annotatedType, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    public static AnnotationMirror findAnnotation(TypeMirror type, Class<? extends Annotation> annotationClass) {
        if (type == null || annotationClass == null) {
            return null;
        }
        return AnnotationUtils.findAnnotation(type, (CharSequence)annotationClass.getTypeName());
    }

    public static AnnotationMirror findAnnotation(TypeMirror type, CharSequence annotationClassName) {
        if (type == null || annotationClassName == null) {
            return null;
        }
        return AnnotationUtils.findAnnotation((Element)TypeUtils.ofTypeElement(type), annotationClassName);
    }

    public static AnnotationMirror findAnnotation(Element element, Class<? extends Annotation> annotationClass) {
        if (element == null || annotationClass == null) {
            return null;
        }
        return AnnotationUtils.findAnnotation(element, (CharSequence)annotationClass.getTypeName());
    }

    public static AnnotationMirror findAnnotation(Element element, CharSequence annotationClassName) {
        if (element == null || annotationClassName == null) {
            return null;
        }
        List<AnnotationMirror> annotations = AnnotationUtils.findAllAnnotations(element, annotation -> AnnotationUtils.matchesAnnotationTypeName(annotation, annotationClassName));
        return CollectionUtils.isEmpty(annotations) ? null : annotations.get(0);
    }

    public static AnnotationMirror findMetaAnnotation(Element annotatedConstruct, Class<? extends Annotation> metaAnnotationClass) {
        if (annotatedConstruct == null || metaAnnotationClass == null) {
            return null;
        }
        return AnnotationUtils.findMetaAnnotation(annotatedConstruct, metaAnnotationClass.getName());
    }

    public static AnnotationMirror findMetaAnnotation(Element annotatedConstruct, CharSequence metaAnnotationClassName) {
        AnnotationMirror annotation;
        if (annotatedConstruct == null || metaAnnotationClassName == null) {
            return null;
        }
        AnnotationMirror metaAnnotation = null;
        List<AnnotationMirror> annotations = AnnotationUtils.getAllAnnotations(annotatedConstruct);
        int size = CollectionUtils.size(annotations);
        for (int i = 0; i < size && (metaAnnotation = AnnotationUtils.findAnnotation((TypeMirror)(annotation = annotations.get(i)).getAnnotationType(), metaAnnotationClassName)) == null; ++i) {
        }
        return metaAnnotation;
    }

    public static boolean isAnnotationPresent(Element element, Class<? extends Annotation> annotationClass) {
        if (element == null || annotationClass == null) {
            return false;
        }
        return AnnotationUtils.findAnnotation(element, annotationClass) != null || AnnotationUtils.findMetaAnnotation(element, annotationClass) != null;
    }

    public static boolean isAnnotationPresent(Element element, CharSequence annotationClassName) {
        if (element == null || annotationClassName == null) {
            return false;
        }
        return AnnotationUtils.findAnnotation(element, annotationClassName) != null || AnnotationUtils.findMetaAnnotation(element, annotationClassName) != null;
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> findAnnotations(AnnotatedConstruct annotatedConstruct, Predicate<? super AnnotationMirror> ... annotationFilters) {
        if (annotatedConstruct == null) {
            return Collections.emptyList();
        }
        List<? extends AnnotationMirror> annotations = annotatedConstruct.getAnnotationMirrors();
        if (CollectionUtils.isEmpty(annotations)) {
            return Collections.emptyList();
        }
        if (ArrayUtils.isNotEmpty(annotationFilters)) {
            annotations = Streams.filterAll(annotations, annotationFilters);
        }
        return annotations.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(annotations);
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> findAllAnnotations(TypeMirror type, Predicate<? super AnnotationMirror> ... annotationFilters) {
        if (type == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.findAllAnnotations(TypeUtils.ofTypeElement(type), annotationFilters);
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> findAllAnnotations(TypeElement element, Predicate<? super AnnotationMirror> ... annotationFilters) {
        if (element == null) {
            return Collections.emptyList();
        }
        List<TypeElement> typeElements = TypeUtils.getAllTypeElements(element);
        List annotations = typeElements.stream().map(AnnotationUtils::getAnnotations).flatMap(Collection::stream).collect(Collectors.toList());
        if (ArrayUtils.isNotEmpty(annotationFilters)) {
            annotations = Streams.filterAll(annotations, annotationFilters);
        }
        return CollectionUtils.isEmpty(annotations) ? Collections.emptyList() : Collections.unmodifiableList(annotations);
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> findAllAnnotations(Element element, Predicate<? super AnnotationMirror> ... annotationFilters) {
        if (element == null) {
            return Collections.emptyList();
        }
        TypeElement typeElement = TypeUtils.ofTypeElement(element);
        if (typeElement == null) {
            return AnnotationUtils.findAnnotations(element, annotationFilters);
        }
        return AnnotationUtils.findAllAnnotations(typeElement, annotationFilters);
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> findAllAnnotations(ProcessingEnvironment processingEnv, Type annotatedType, Predicate<? super AnnotationMirror> ... annotationFilters) {
        if (processingEnv == null || annotatedType == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.findAllAnnotations(processingEnv, annotatedType.getTypeName(), annotationFilters);
    }

    @Nonnull
    @Immutable
    public static List<AnnotationMirror> findAllAnnotations(ProcessingEnvironment processingEnv, CharSequence annotatedTypeName, Predicate<? super AnnotationMirror> ... annotationFilters) {
        if (processingEnv == null || annotatedTypeName == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.findAllAnnotations(TypeUtils.getTypeElement(processingEnv, annotatedTypeName), annotationFilters);
    }

    public static boolean matchesAnnotationType(AnnotationMirror annotationMirror, Type annotationType) {
        if (annotationMirror == null || annotationType == null) {
            return false;
        }
        return AnnotationUtils.matchesAnnotationTypeName(annotationMirror, annotationType.getTypeName());
    }

    public static boolean matchesAnnotationTypeName(AnnotationMirror annotationMirror, CharSequence annotationTypeName) {
        if (annotationMirror == null || annotationTypeName == null) {
            return false;
        }
        return TypeUtils.isSameType((TypeMirror)annotationMirror.getAnnotationType(), annotationTypeName);
    }

    public static String getAttributeName(ExecutableElement attributeMethod) {
        return MethodUtils.getMethodName(attributeMethod);
    }

    public static boolean matchesAttributeMethod(ExecutableElement attributeMethod, String attributeName) {
        return attributeMethod != null && Objects.equals(AnnotationUtils.getAttributeName(attributeMethod), attributeName);
    }

    public static boolean matchesAttributeValue(AnnotationValue one, AnnotationValue another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        Object oneValue = one.getValue();
        Object anotherValue = another.getValue();
        return Objects.equals(oneValue, anotherValue);
    }

    public static boolean matchesAttributeValue(AnnotationValue annotationValue, Object attributeValue) {
        return annotationValue != null && Objects.equals(annotationValue.getValue(), attributeValue);
    }

    public static boolean matchesDefaultAttributeValue(ExecutableElement attributeMethod, AnnotationValue annotationValue) {
        return attributeMethod != null && AnnotationUtils.matchesAttributeValue(attributeMethod.getDefaultValue(), annotationValue);
    }

    @Nonnull
    @Immutable
    public static Map<String, Object> getAttributesMap(AnnotatedConstruct annotatedConstruct, Class<? extends Annotation> annotationClass) {
        return AnnotationUtils.getAttributesMap(annotatedConstruct, annotationClass, true);
    }

    @Nonnull
    @Immutable
    public static Map<String, Object> getAttributesMap(AnnotatedConstruct annotatedConstruct, Class<? extends Annotation> annotationClass, boolean withDefault) {
        return AnnotationUtils.getAttributesMap(AnnotationUtils.getAnnotation(annotatedConstruct, annotationClass), withDefault);
    }

    @Nonnull
    @Immutable
    public static Map<String, Object> getAttributesMap(AnnotationMirror annotation) {
        return AnnotationUtils.getAttributesMap(annotation, true);
    }

    @Nonnull
    @Immutable
    public static Map<String, Object> getAttributesMap(AnnotationMirror annotation, boolean withDefault) {
        Map<ExecutableElement, AnnotationValue> attributes = AnnotationUtils.getElementValues(annotation, withDefault);
        int size = attributes.size();
        if (size < 1) {
            return Collections.emptyMap();
        }
        Map attributesMap = MapUtils.newFixedLinkedHashMap(size);
        for (Map.Entry<ExecutableElement, AnnotationValue> entry : attributes.entrySet()) {
            ExecutableElement attributeMethod = entry.getKey();
            String attributeName = AnnotationUtils.getAttributeName(attributeMethod);
            Object attributeValue = AnnotationUtils.getAttribute(entry);
            attributesMap.put(attributeName, attributeValue);
        }
        return Collections.unmodifiableMap(attributesMap);
    }

    @Nonnull
    @Immutable
    public static Map<ExecutableElement, AnnotationValue> getElementValues(AnnotatedConstruct annotatedConstruct, Class<? extends Annotation> annotationClass) {
        return AnnotationUtils.getElementValues(annotatedConstruct, annotationClass, true);
    }

    @Nonnull
    @Immutable
    public static Map<ExecutableElement, AnnotationValue> getElementValues(AnnotatedConstruct annotatedConstruct, Class<? extends Annotation> annotationClass, boolean withDefault) {
        return AnnotationUtils.getElementValues(AnnotationUtils.getAnnotation(annotatedConstruct, annotationClass), withDefault);
    }

    @Nonnull
    @Immutable
    public static Map<ExecutableElement, AnnotationValue> getElementValues(AnnotationMirror annotation) {
        return AnnotationUtils.getElementValues(annotation, true);
    }

    @Nonnull
    @Immutable
    public static Map<ExecutableElement, AnnotationValue> getElementValues(AnnotationMirror annotation, boolean withDefault) {
        if (annotation == null) {
            return Collections.emptyMap();
        }
        DeclaredType annotationType = annotation.getAnnotationType();
        List<ExecutableElement> attributeMethods = MethodUtils.getDeclaredMethods(annotationType);
        int size = attributeMethods.size();
        Map<ExecutableElement, AnnotationValue> attributes = MapUtils.newFixedLinkedHashMap(size);
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotation.getElementValues();
        for (int i = 0; i < size; ++i) {
            ExecutableElement attributeMethod = attributeMethods.get(i);
            AnnotationValue annotationValue = elementValues.get(attributeMethod);
            if (withDefault && annotationValue == null) {
                annotationValue = attributeMethod.getDefaultValue();
            }
            if (annotationValue == null) continue;
            attributes.put(attributeMethod, annotationValue);
        }
        return Collections.unmodifiableMap(attributes);
    }

    @Nullable
    @Immutable
    public static Map.Entry<ExecutableElement, AnnotationValue> getElementValue(AnnotationMirror annotation, String attributeName, boolean withDefault) {
        if (annotation == null || StringUtils.isBlank(attributeName)) {
            return null;
        }
        ExecutableElement attributeMethod = null;
        AnnotationValue annotationValue = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotation.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            attributeMethod = entry.getKey();
            if (!AnnotationUtils.matchesAttributeMethod(attributeMethod, attributeName)) continue;
            annotationValue = entry.getValue();
            break;
        }
        if (withDefault && annotationValue == null) {
            DeclaredType annotationType = annotation.getAnnotationType();
            List<ExecutableElement> attributeMethods = MethodUtils.findDeclaredMethods(annotationType, method -> !elementValues.containsKey(method));
            int size = attributeMethods.size();
            for (int i = 0; i < size; ++i) {
                attributeMethod = attributeMethods.get(i);
                if (!AnnotationUtils.matchesAttributeMethod(attributeMethod, attributeName)) continue;
                annotationValue = attributeMethod.getDefaultValue();
                break;
            }
        }
        return MapUtils.immutableEntry(attributeMethod, annotationValue);
    }

    @Nullable
    public static Map.Entry<ExecutableElement, AnnotationValue> getElementValue(Map<ExecutableElement, AnnotationValue> elementValues, String attributeName) {
        if (MapUtils.isEmpty(elementValues)) {
            return null;
        }
        for (Map.Entry<ExecutableElement, AnnotationValue> entry : elementValues.entrySet()) {
            if (!AnnotationUtils.matchesAttributeMethod(entry.getKey(), attributeName)) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    public static <T> T getAttribute(AnnotationMirror annotation, String attributeName) {
        return AnnotationUtils.getAttribute(annotation, attributeName, true);
    }

    @Nullable
    public static <T> T getAttribute(AnnotationMirror annotation, String attributeName, boolean withDefault) {
        Map.Entry<ExecutableElement, AnnotationValue> attributeEntry = AnnotationUtils.getElementValue(annotation, attributeName, withDefault);
        return AnnotationUtils.getAttribute(attributeEntry);
    }

    @Nullable
    public static <T> T getAttribute(Map.Entry<ExecutableElement, AnnotationValue> elementValue) {
        if (elementValue == null) {
            return null;
        }
        ExecutableElement attributeMethod = elementValue.getKey();
        AnnotationValue annotationValue = elementValue.getValue();
        return (T)annotationValue.accept(DEFAULT_ANNOTATION_VALUE_VISITOR, attributeMethod);
    }

    @Nullable
    public static <T> T getValue(AnnotationMirror annotation) {
        return AnnotationUtils.getAttribute(annotation, VALUE_ATTRIBUTE_NAME);
    }

    @Nonnull
    public static ElementType[] getElementTypes(AnnotationMirror annotation) {
        return annotation == null ? EMPTY_ELEMENT_TYPE_ARRAY : AnnotationUtils.getElementTypes(annotation.getAnnotationType());
    }

    @Nonnull
    public static ElementType[] getElementTypes(DeclaredType annotationType) {
        AnnotationMirror targetAnnotation = AnnotationUtils.findAnnotation((TypeMirror)annotationType, Target.class);
        ElementType[] elementTypes = (ElementType[])AnnotationUtils.getValue(targetAnnotation);
        return elementTypes == null ? EMPTY_ELEMENT_TYPE_ARRAY : elementTypes;
    }
}

