/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor.util;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.annotation.processor.util.ElementUtils;
import io.microsphere.annotation.processor.util.MemberUtils;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.ListUtils;
import io.microsphere.lang.function.Predicates;
import io.microsphere.util.Utils;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public interface ConstructorUtils
extends Utils {
    @Nonnull
    @Immutable
    public static List<ExecutableElement> getDeclaredConstructors(TypeElement type) {
        return type == null ? Collections.emptyList() : ConstructorUtils.getDeclaredConstructors(type.asType());
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> getDeclaredConstructors(TypeMirror type) {
        return type == null ? Collections.emptyList() : ConstructorUtils.findDeclaredConstructors(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nullable
    public static ExecutableElement findConstructor(TypeElement type, Type ... parameterTypes) {
        return type == null ? null : ConstructorUtils.findConstructor(type.asType(), parameterTypes);
    }

    @Nullable
    public static ExecutableElement findConstructor(TypeMirror type, Type ... parameterTypes) {
        if (type == null) {
            return null;
        }
        return ListUtils.first(ConstructorUtils.findDeclaredConstructors(type, constructor -> ElementUtils.matchParameterTypes(constructor, parameterTypes)));
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> findDeclaredConstructors(TypeElement type, Predicate<? super ExecutableElement> ... constructorFilters) {
        return type == null ? Collections.emptyList() : ConstructorUtils.findDeclaredConstructors(type.asType(), constructorFilters);
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> findDeclaredConstructors(TypeMirror type, Predicate<? super ExecutableElement> ... constructorFilters) {
        return ConstructorUtils.filterDeclaredConstructors(type, constructorFilters);
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> filterDeclaredConstructors(TypeMirror type, Predicate<? super ExecutableElement> ... constructorFilters) {
        if (type == null) {
            return Collections.emptyList();
        }
        List<? extends Element> declaredMembers = MemberUtils.getDeclaredMembers(type, false);
        if (CollectionUtils.isEmpty(declaredMembers)) {
            return Collections.emptyList();
        }
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(declaredMembers);
        return ElementUtils.filterElements(constructors, constructorFilters);
    }
}

