/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor.util;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.processor.util.TypeUtils;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.lang.function.Predicates;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Utils;
import java.lang.annotation.ElementType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public interface ElementUtils
extends Utils {
    public static boolean isClass(ElementKind kind) {
        return kind != null && kind.isClass();
    }

    public static boolean isInterface(ElementKind kind) {
        return kind != null && kind.isInterface();
    }

    public static boolean isDeclaredType(ElementKind kind) {
        return ElementUtils.isClass(kind) || ElementUtils.isInterface(kind);
    }

    public static boolean isField(ElementKind kind) {
        return kind != null && kind.isField();
    }

    public static boolean isExecutable(ElementKind kind) {
        if (kind != null) {
            switch (kind) {
                case METHOD: 
                case CONSTRUCTOR: 
                case STATIC_INIT: 
                case INSTANCE_INIT: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isMember(ElementKind kind) {
        return ElementUtils.isField(kind) || ElementUtils.isExecutable(kind);
    }

    public static boolean isInitializer(ElementKind kind) {
        if (kind != null) {
            switch (kind) {
                case STATIC_INIT: 
                case INSTANCE_INIT: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isVariable(ElementKind kind) {
        if (kind != null) {
            switch (kind) {
                case ENUM_CONSTANT: 
                case FIELD: 
                case PARAMETER: 
                case LOCAL_VARIABLE: 
                case EXCEPTION_PARAMETER: 
                case RESOURCE_VARIABLE: {
                    return true;
                }
            }
            return "BINDING_VARIABLE".equals(kind.name());
        }
        return false;
    }

    public static ElementKind toElementKind(ElementType elementType) {
        if (elementType == null) {
            return ElementKind.OTHER;
        }
        switch (elementType) {
            case TYPE: 
            case TYPE_USE: {
                return ElementKind.CLASS;
            }
        }
        return ElementKind.valueOf(elementType.name());
    }

    public static boolean matchesElementType(ElementKind elementKind, ElementType elementType) {
        return elementKind == ElementUtils.toElementKind(elementType);
    }

    public static boolean matchesElementType(ElementKind elementKind, ElementType ... elementTypes) {
        int length = ArrayUtils.length(elementTypes);
        if (length < 1) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!ElementUtils.matchesElementType(elementKind, elementTypes[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesElementType(Element element, ElementType ... elementTypes) {
        return element != null && ElementUtils.matchesElementType(element.getKind(), elementTypes);
    }

    public static boolean matchesElementKind(Element member, ElementKind kind) {
        return member == null || kind == null ? false : kind.equals((Object)member.getKind());
    }

    public static boolean isPublicNonStatic(Element member) {
        return ElementUtils.hasModifiers(member, Modifier.PUBLIC) && !ElementUtils.hasModifiers(member, Modifier.STATIC);
    }

    public static boolean hasModifiers(Element member, Modifier ... modifiers) {
        if (member == null || modifiers == null) {
            return false;
        }
        Set<Modifier> actualModifiers = member.getModifiers();
        for (Modifier modifier : modifiers) {
            if (actualModifiers.contains((Object)modifier)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    @Immutable
    public static <E extends Element> List<E> filterElements(List<E> elements, Predicate<? super E> ... elementPredicates) {
        if (CollectionUtils.isEmpty(elements) || elementPredicates == null) {
            return Collections.emptyList();
        }
        if (ArrayUtils.isNotEmpty(elementPredicates)) {
            Predicate<? super E> predicate = Predicates.and(elementPredicates);
            elements = elements.stream().filter(predicate).collect(Collectors.toList());
        }
        return elements.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(elements);
    }

    public static boolean matchParameterTypes(ExecutableElement executableElement, Type ... parameterTypes) {
        return executableElement == null || parameterTypes == null ? false : ElementUtils.matchParameterTypeNames(executableElement.getParameters(), io.microsphere.reflect.TypeUtils.getTypeNames(parameterTypes));
    }

    public static boolean matchParameterTypes(List<? extends VariableElement> parameters, Type ... parameterTypes) {
        return parameters == null || parameterTypes == null ? false : ElementUtils.matchParameterTypeNames(parameters, io.microsphere.reflect.TypeUtils.getTypeNames(parameterTypes));
    }

    public static boolean matchParameterTypeNames(List<? extends VariableElement> parameters, CharSequence ... parameterTypeNames) {
        if (parameters == null || parameterTypeNames == null) {
            return false;
        }
        int length = ArrayUtils.length(parameterTypeNames);
        int size = parameters.size();
        if (size != length) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            VariableElement parameter = parameters.get(i);
            if (TypeUtils.isSameType((Element)parameter, parameterTypeNames[i])) continue;
            return false;
        }
        return true;
    }
}

