/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor.util;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.annotation.processor.util.ElementUtils;
import io.microsphere.annotation.processor.util.MemberUtils;
import io.microsphere.annotation.processor.util.TypeUtils;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.lang.function.Predicates;
import io.microsphere.lang.function.Streams;
import io.microsphere.util.Utils;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public interface FieldUtils
extends Utils {
    @Nullable
    public static VariableElement getDeclaredField(Element element, String fieldName) {
        return element == null ? null : FieldUtils.getDeclaredField(element.asType(), fieldName);
    }

    @Nullable
    public static VariableElement getDeclaredField(TypeMirror type, String fieldName) {
        return Streams.filterFirst(FieldUtils.findDeclaredFields(type, field -> fieldName.equals(field.getSimpleName().toString())), new Predicate[0]);
    }

    @Nonnull
    @Immutable
    public static List<VariableElement> getDeclaredFields(Element element) {
        return FieldUtils.findDeclaredFields(element, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<VariableElement> getDeclaredFields(TypeMirror type) {
        return FieldUtils.findDeclaredFields(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<VariableElement> getAllDeclaredFields(Element element) {
        return FieldUtils.findAllDeclaredFields(element, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<VariableElement> getAllDeclaredFields(TypeMirror type) {
        return FieldUtils.findAllDeclaredFields(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nullable
    public static VariableElement findField(Element element, String fieldName) {
        return element == null ? null : FieldUtils.findField(element.asType(), fieldName);
    }

    @Nullable
    public static VariableElement findField(TypeMirror type, String fieldName) {
        return Streams.filterFirst(FieldUtils.findAllDeclaredFields(type, field -> FieldUtils.equalsFieldName(field, fieldName)), new Predicate[0]);
    }

    @Nonnull
    @Immutable
    public static List<VariableElement> findDeclaredFields(Element element, Predicate<? super VariableElement> ... fieldFilters) {
        return element == null ? Collections.emptyList() : FieldUtils.findDeclaredFields(element.asType(), fieldFilters);
    }

    @Nonnull
    @Immutable
    public static List<VariableElement> findDeclaredFields(TypeMirror type, Predicate<? super VariableElement> ... fieldFilters) {
        return FieldUtils.filterDeclaredFields(type, false, fieldFilters);
    }

    @Nonnull
    @Immutable
    public static List<VariableElement> findAllDeclaredFields(Element element, Predicate<? super VariableElement> ... fieldFilters) {
        return element == null ? Collections.emptyList() : FieldUtils.findAllDeclaredFields(element.asType(), fieldFilters);
    }

    @Nonnull
    @Immutable
    public static List<VariableElement> findAllDeclaredFields(TypeMirror type, Predicate<? super VariableElement> ... fieldFilters) {
        return FieldUtils.filterDeclaredFields(type, true, fieldFilters);
    }

    @Nonnull
    @Immutable
    public static List<VariableElement> filterDeclaredFields(TypeMirror type, boolean includeHierarchicalTypes, Predicate<? super VariableElement> ... fieldFilters) {
        if (type == null) {
            return Collections.emptyList();
        }
        List<? extends Element> declaredMembers = MemberUtils.getDeclaredMembers(type, includeHierarchicalTypes);
        if (CollectionUtils.isEmpty(declaredMembers)) {
            return Collections.emptyList();
        }
        List<VariableElement> fields = ElementFilter.fieldsIn(declaredMembers);
        return ElementUtils.filterElements(fields, fieldFilters);
    }

    public static boolean isEnumMemberField(VariableElement field) {
        if (field == null || !TypeUtils.isEnumType(field.getEnclosingElement())) {
            return false;
        }
        return ElementKind.ENUM_CONSTANT.equals((Object)field.getKind());
    }

    public static boolean isNonStaticField(VariableElement field) {
        return FieldUtils.isField(field) && !ElementUtils.hasModifiers(field, Modifier.STATIC);
    }

    public static boolean isField(VariableElement field) {
        return ElementUtils.matchesElementKind(field, ElementKind.FIELD) || FieldUtils.isEnumMemberField(field);
    }

    public static boolean isField(VariableElement field, Modifier ... modifiers) {
        return FieldUtils.isField(field) && ElementUtils.hasModifiers(field, modifiers);
    }

    @Nonnull
    @Immutable
    public static List<VariableElement> getNonStaticFields(TypeMirror type) {
        return FieldUtils.findDeclaredFields(type, FieldUtils::isNonStaticField);
    }

    @Nonnull
    @Immutable
    public static List<VariableElement> getNonStaticFields(Element element) {
        return element == null ? Collections.emptyList() : FieldUtils.getNonStaticFields(element.asType());
    }

    @Nonnull
    @Immutable
    public static List<VariableElement> getAllNonStaticFields(TypeMirror type) {
        return FieldUtils.findAllDeclaredFields(type, FieldUtils::isNonStaticField);
    }

    @Nonnull
    @Immutable
    public static List<VariableElement> getAllNonStaticFields(Element element) {
        return element == null ? Collections.emptyList() : FieldUtils.getAllNonStaticFields(element.asType());
    }

    public static boolean equalsFieldName(VariableElement field, CharSequence fieldName) {
        return field != null && fieldName != null && field.getSimpleName().toString().equals(fieldName.toString());
    }
}

