/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor.util;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.processor.util.ElementUtils;
import io.microsphere.annotation.processor.util.TypeUtils;
import io.microsphere.lang.function.Predicates;
import io.microsphere.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public interface MemberUtils
extends Utils {
    @Nonnull
    @Immutable
    public static List<? extends Element> getDeclaredMembers(TypeMirror type) {
        return type == null ? Collections.emptyList() : MemberUtils.getDeclaredMembers(TypeUtils.ofTypeElement(type));
    }

    @Nonnull
    @Immutable
    public static List<? extends Element> getDeclaredMembers(TypeElement type) {
        return type == null ? Collections.emptyList() : MemberUtils.findDeclaredMembers(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<? extends Element> getAllDeclaredMembers(TypeMirror type) {
        return type == null ? Collections.emptyList() : MemberUtils.findAllDeclaredMembers(TypeUtils.ofTypeElement(type), Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<? extends Element> getAllDeclaredMembers(TypeElement type) {
        return type == null ? Collections.emptyList() : MemberUtils.findAllDeclaredMembers(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<? extends Element> getDeclaredMembers(TypeMirror type, boolean includeHierarchicalTypes) {
        return includeHierarchicalTypes ? MemberUtils.getAllDeclaredMembers(type) : MemberUtils.getDeclaredMembers(type);
    }

    @Nonnull
    @Immutable
    public static List<? extends Element> getDeclaredMembers(TypeElement type, boolean includeHierarchicalTypes) {
        return includeHierarchicalTypes ? MemberUtils.getAllDeclaredMembers(type) : MemberUtils.getDeclaredMembers(type);
    }

    @Nonnull
    @Immutable
    public static <T extends Element> List<T> findDeclaredMembers(TypeMirror type, Predicate<? super T> ... memberFilters) {
        return type == null ? Collections.emptyList() : MemberUtils.findDeclaredMembers(TypeUtils.ofTypeElement(type), memberFilters);
    }

    @Nonnull
    @Immutable
    public static <T extends Element> List<T> findDeclaredMembers(TypeElement type, Predicate<? super T> ... memberFilters) {
        if (type == null) {
            return Collections.emptyList();
        }
        return ElementUtils.filterElements(type.getEnclosedElements(), memberFilters);
    }

    @Nonnull
    @Immutable
    public static <T extends Element> List<T> findAllDeclaredMembers(TypeMirror type, Predicate<? super T> ... memberFilters) {
        return type == null ? Collections.emptyList() : MemberUtils.findAllDeclaredMembers(TypeUtils.ofTypeElement(type), memberFilters);
    }

    @Nonnull
    @Immutable
    public static <T extends Element> List<T> findAllDeclaredMembers(TypeElement type, Predicate<? super T> ... memberFilters) {
        if (type == null) {
            return Collections.emptyList();
        }
        List declaredMembers = TypeUtils.getAllDeclaredTypes(type).stream().map(MemberUtils::getDeclaredMembers).flatMap(Collection::stream).collect(Collectors.toList());
        return ElementUtils.filterElements(declaredMembers, memberFilters);
    }

    @Nonnull
    @Immutable
    public static <T extends Element> List<T> findDeclaredMembers(TypeMirror type, boolean includeHierarchicalTypes, Predicate<? super T> ... memberFilters) {
        return includeHierarchicalTypes ? MemberUtils.findAllDeclaredMembers(type, memberFilters) : MemberUtils.findDeclaredMembers(type, memberFilters);
    }

    @Nonnull
    @Immutable
    public static <T extends Element> List<T> findDeclaredMembers(TypeElement type, boolean all, Predicate<? super T> ... memberFilters) {
        return all ? MemberUtils.findAllDeclaredMembers(type, memberFilters) : MemberUtils.findDeclaredMembers(type, memberFilters);
    }
}

