/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor.util;

import io.microsphere.annotation.processor.util.LoggerUtils;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.Utils;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;

public interface MessagerUtils
extends Utils {
    public static void printNote(ProcessingEnvironment processingEnv, String pattern, Object ... args) {
        MessagerUtils.printNote(processingEnv.getMessager(), pattern, args);
    }

    public static void printNote(Messager messager, String pattern, Object ... args) {
        MessagerUtils.printMessage(messager, Diagnostic.Kind.NOTE, pattern, args);
    }

    public static void printWarning(ProcessingEnvironment processingEnv, String pattern, Object ... args) {
        MessagerUtils.printWarning(processingEnv.getMessager(), pattern, args);
    }

    public static void printWarning(Messager messager, String pattern, Object ... args) {
        MessagerUtils.printMessage(messager, Diagnostic.Kind.WARNING, pattern, args);
    }

    public static void printMandatoryWarning(ProcessingEnvironment processingEnv, String pattern, Object ... args) {
        MessagerUtils.printMandatoryWarning(processingEnv.getMessager(), pattern, args);
    }

    public static void printMandatoryWarning(Messager messager, String pattern, Object ... args) {
        MessagerUtils.printMessage(messager, Diagnostic.Kind.MANDATORY_WARNING, pattern, args);
    }

    public static void printError(ProcessingEnvironment processingEnv, String pattern, Object ... args) {
        MessagerUtils.printError(processingEnv.getMessager(), pattern, args);
    }

    public static void printError(Messager messager, String pattern, Object ... args) {
        MessagerUtils.printMessage(messager, Diagnostic.Kind.ERROR, pattern, args);
    }

    public static void printMessage(ProcessingEnvironment processingEnv, Diagnostic.Kind kind, String pattern, Object ... args) {
        MessagerUtils.printMessage(processingEnv.getMessager(), kind, pattern, args);
    }

    public static void printMessage(Messager messager, Diagnostic.Kind kind, String pattern, Object ... args) {
        String message = FormatUtils.format(pattern, args);
        messager.printMessage(kind, message);
        switch (kind) {
            case ERROR: {
                LoggerUtils.error(pattern, args);
                break;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                LoggerUtils.warn(pattern, args);
                break;
            }
            case NOTE: {
                LoggerUtils.info(pattern, args);
                break;
            }
            default: {
                LoggerUtils.debug(pattern, args);
            }
        }
    }
}

