/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor.util;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.annotation.processor.util.ElementUtils;
import io.microsphere.annotation.processor.util.MemberUtils;
import io.microsphere.annotation.processor.util.TypeUtils;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.lang.function.Predicates;
import io.microsphere.lang.function.Streams;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Utils;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

public interface MethodUtils
extends Utils {
    @Nonnull
    @Immutable
    public static List<ExecutableElement> getDeclaredMethods(TypeElement type) {
        return MethodUtils.findDeclaredMethods(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> getDeclaredMethods(TypeMirror type) {
        return MethodUtils.findDeclaredMethods(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> getAllDeclaredMethods(TypeElement type) {
        return MethodUtils.findAllDeclaredMethods(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> getAllDeclaredMethods(TypeMirror type) {
        return MethodUtils.findAllDeclaredMethods(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> findDeclaredMethods(TypeElement type, Predicate<? super ExecutableElement> ... methodFilters) {
        return type == null ? Collections.emptyList() : MethodUtils.findDeclaredMethods(type.asType(), methodFilters);
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> findDeclaredMethods(TypeMirror type, Predicate<? super ExecutableElement> ... methodFilters) {
        return MethodUtils.filterDeclaredMethods(type, false, methodFilters);
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> findAllDeclaredMethods(TypeElement type, Type ... excludedTypes) {
        return type == null ? Collections.emptyList() : MethodUtils.findAllDeclaredMethods(type.asType(), excludedTypes);
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> findAllDeclaredMethods(TypeMirror type, Type ... excludedTypes) {
        if (type == null) {
            return Collections.emptyList();
        }
        return MethodUtils.findAllDeclaredMethods(type, MethodUtils.methodPredicateForExcludedTypes(excludedTypes));
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> findPublicNonStaticMethods(TypeElement type, Type ... excludedTypes) {
        return type == null ? Collections.emptyList() : MethodUtils.findPublicNonStaticMethods(TypeUtils.ofDeclaredType(type), excludedTypes);
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> findPublicNonStaticMethods(TypeMirror type, Type ... excludedTypes) {
        if (type == null) {
            return Collections.emptyList();
        }
        Predicate predicate = Predicates.and(MethodUtils.methodPredicateForExcludedTypes(excludedTypes), MethodUtils::isPublicNonStaticMethod);
        return MethodUtils.findAllDeclaredMethods(type, predicate);
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> findAllDeclaredMethods(TypeElement type, Predicate<? super ExecutableElement> ... methodFilters) {
        return type == null ? Collections.emptyList() : MethodUtils.findAllDeclaredMethods(type.asType(), methodFilters);
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> findAllDeclaredMethods(TypeMirror type, Predicate<? super ExecutableElement> ... methodFilters) {
        return MethodUtils.filterDeclaredMethods(type, true, methodFilters);
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> filterDeclaredMethods(TypeMirror type, boolean includeHierarchicalTypes, Predicate<? super ExecutableElement> ... methodFilters) {
        if (type == null) {
            return Collections.emptyList();
        }
        List<? extends Element> declaredMembers = MemberUtils.getDeclaredMembers(type, includeHierarchicalTypes);
        if (CollectionUtils.isEmpty(declaredMembers)) {
            return Collections.emptyList();
        }
        List<ExecutableElement> methods = ElementFilter.methodsIn(declaredMembers);
        return ElementUtils.filterElements(methods, methodFilters);
    }

    public static boolean isMethod(ExecutableElement method) {
        return method != null && ElementKind.METHOD.equals((Object)method.getKind());
    }

    public static boolean isPublicNonStaticMethod(ExecutableElement method) {
        return MethodUtils.isMethod(method) && ElementUtils.isPublicNonStatic(method);
    }

    @Nullable
    public static ExecutableElement findMethod(TypeElement type, String methodName) {
        return MethodUtils.findMethod(type, methodName, ArrayUtils.EMPTY_TYPE_ARRAY);
    }

    @Nullable
    public static ExecutableElement findMethod(TypeMirror type, String methodName) {
        return MethodUtils.findMethod(type, methodName, ArrayUtils.EMPTY_TYPE_ARRAY);
    }

    @Nullable
    public static ExecutableElement findMethod(TypeElement type, String methodName, Type ... parameterTypes) {
        return type == null ? null : MethodUtils.findMethod(type.asType(), methodName, parameterTypes);
    }

    @Nullable
    public static ExecutableElement findMethod(TypeMirror type, String methodName, Type ... parameterTypes) {
        if (type == null || methodName == null || parameterTypes == null) {
            return null;
        }
        List<ExecutableElement> allDeclaredMethods = MethodUtils.findAllDeclaredMethods(type, method -> MethodUtils.matches(method, methodName, parameterTypes));
        return allDeclaredMethods.isEmpty() ? null : allDeclaredMethods.get(0);
    }

    @Nullable
    public static ExecutableElement findMethod(TypeElement type, String methodName, CharSequence ... parameterTypeNames) {
        return type == null ? null : MethodUtils.findMethod(type.asType(), methodName, parameterTypeNames);
    }

    @Nullable
    public static ExecutableElement findMethod(TypeMirror type, String methodName, CharSequence ... parameterTypeNames) {
        if (type == null || methodName == null || parameterTypeNames == null) {
            return null;
        }
        List<ExecutableElement> allDeclaredMethods = MethodUtils.findAllDeclaredMethods(type, method -> MethodUtils.matches(method, methodName, parameterTypeNames));
        return allDeclaredMethods.isEmpty() ? null : allDeclaredMethods.get(0);
    }

    @Nullable
    public static ExecutableElement getOverrideMethod(ProcessingEnvironment processingEnv, TypeElement type, ExecutableElement declaringMethod) {
        Elements elements = processingEnv.getElementUtils();
        return Streams.filterFirst(MethodUtils.getAllDeclaredMethods(type), method -> elements.overrides((ExecutableElement)method, declaringMethod, type));
    }

    @Nonnull
    @Immutable
    public static List<ExecutableElement> filterMethods(List<ExecutableElement> methods, Predicate<? super ExecutableElement> ... methodFilters) {
        if (CollectionUtils.isEmpty(methods)) {
            return Collections.emptyList();
        }
        List<ExecutableElement> filteredMethods = methods;
        if (ArrayUtils.isNotEmpty(methodFilters)) {
            Predicate<? super ExecutableElement> combinedPredicate = Predicates.and(methodFilters);
            filteredMethods = methods.stream().filter(combinedPredicate).collect(Collectors.toList());
        }
        return filteredMethods.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(filteredMethods);
    }

    @Nullable
    public static String getMethodName(ExecutableElement method) {
        return method == null ? null : method.getSimpleName().toString();
    }

    @Nullable
    public static String getReturnTypeName(ExecutableElement method) {
        return method == null ? null : TypeUtils.toString(method.getReturnType());
    }

    @Nonnull
    @Immutable
    public static List<TypeMirror> getMethodParameterTypeMirrors(ExecutableElement method) {
        if (method == null) {
            return Collections.emptyList();
        }
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.isEmpty()) {
            return Collections.emptyList();
        }
        List parameterTypes = parameters.stream().map(Element::asType).collect(Collectors.toList());
        return Collections.unmodifiableList(parameterTypes);
    }

    public static String[] getMethodParameterTypeNames(ExecutableElement method) {
        List<TypeMirror> parameterTypes = MethodUtils.getMethodParameterTypeMirrors(method);
        return parameterTypes.isEmpty() ? ArrayUtils.EMPTY_STRING_ARRAY : (String[])parameterTypes.stream().map(TypeUtils::toString).toArray(String[]::new);
    }

    public static boolean matches(ExecutableElement method, String methodName, Type ... parameterTypes) {
        return MethodUtils.matchesMethod(method, methodName, parameterTypes);
    }

    public static boolean matches(ExecutableElement method, String methodName, CharSequence ... parameterTypeNames) {
        return MethodUtils.matchesMethod(method, methodName, parameterTypeNames);
    }

    public static boolean matchesMethodName(ExecutableElement method, String methodName) {
        return Objects.equals(MethodUtils.getMethodName(method), methodName);
    }

    public static boolean matchesMethod(ExecutableElement method, String methodName, Type ... parameterTypes) {
        if (method == null || methodName == null || parameterTypes == null) {
            return false;
        }
        if (!MethodUtils.matchesMethodName(method, methodName)) {
            return false;
        }
        return ElementUtils.matchParameterTypes(method, parameterTypes);
    }

    public static boolean matchesMethod(ExecutableElement method, String methodName, CharSequence ... parameterTypeNames) {
        if (method == null || methodName == null || parameterTypeNames == null) {
            return false;
        }
        if (!Objects.equals(MethodUtils.getMethodName(method), methodName)) {
            return false;
        }
        return ElementUtils.matchParameterTypeNames(method.getParameters(), parameterTypeNames);
    }

    @Nullable
    public static Element getEnclosingElement(ExecutableElement method) {
        return method == null ? null : method.getEnclosingElement();
    }

    @Nonnull
    public static Predicate<? super ExecutableElement> methodPredicateForExcludedTypes(Type ... excludedTypes) {
        return method -> {
            boolean excluded = true;
            Element declaredType = MethodUtils.getEnclosingElement(method);
            for (Type excludedType : excludedTypes) {
                if (!TypeUtils.isSameType(declaredType, excludedType)) continue;
                excluded = false;
                break;
            }
            return excluded;
        };
    }
}

