/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.annotation.processor.util;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.Lists;
import io.microsphere.lang.function.Predicates;
import io.microsphere.lang.function.Streams;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Assert;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.TypeFinder;
import io.microsphere.util.Utils;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public interface TypeUtils
extends Utils {
    @Nonnull
    @Immutable
    public static final List<String> SIMPLE_TYPE_NAMES = Lists.ofList((String[])ClassUtils.SIMPLE_TYPES.stream().map(Class::getName).toArray(String[]::new));
    @Nonnull
    public static final Function<TypeElement, TypeElement> TYPE_ELEMENT_GET_SUPERCLASS = type -> TypeUtils.ofTypeElement(type.getSuperclass());
    @Nonnull
    public static final Function<TypeElement, TypeElement[]> TYPE_ELEMENT_GET_INTERFACES = type -> (TypeElement[])type.getInterfaces().stream().map(TypeUtils::ofTypeElement).toArray(TypeElement[]::new);

    public static boolean isSimpleType(Element element) {
        return element != null && TypeUtils.isSimpleType(element.asType());
    }

    public static boolean isSimpleType(TypeMirror type) {
        return type != null && SIMPLE_TYPE_NAMES.contains(type.toString());
    }

    public static boolean isSameType(Element element, Type type) {
        return TypeUtils.isSameType(element == null ? null : element.asType(), type);
    }

    public static boolean isSameType(Element type, CharSequence typeName) {
        return TypeUtils.isSameType(type == null ? null : type.asType(), typeName);
    }

    public static boolean isSameType(TypeMirror typeMirror, Type type) {
        return TypeUtils.isSameType(typeMirror, (CharSequence)(type == null ? null : type.getTypeName()));
    }

    public static boolean isSameType(TypeMirror type, CharSequence typeName) {
        if (type == null && typeName == null) {
            return true;
        }
        return Objects.equals(String.valueOf(type), String.valueOf(typeName));
    }

    public static boolean isArrayType(TypeMirror type) {
        return type != null && TypeKind.ARRAY == type.getKind();
    }

    public static boolean isArrayType(Element element) {
        return element != null && TypeUtils.isArrayType(element.asType());
    }

    public static boolean isEnumType(TypeMirror type) {
        DeclaredType declaredType = TypeUtils.ofDeclaredType(type);
        return declaredType != null && ElementKind.ENUM == declaredType.asElement().getKind();
    }

    public static boolean isEnumType(Element element) {
        return element != null && TypeUtils.isEnumType(element.asType());
    }

    public static boolean isClassType(TypeMirror type) {
        DeclaredType declaredType = TypeUtils.ofDeclaredType(type);
        return declaredType != null && TypeUtils.isClassType(declaredType.asElement());
    }

    public static boolean isClassType(Element element) {
        return element != null && ElementKind.CLASS == element.getKind();
    }

    public static boolean isPrimitiveType(TypeMirror type) {
        return type != null && type.getKind().isPrimitive();
    }

    public static boolean isPrimitiveType(Element element) {
        return element != null && TypeUtils.isPrimitiveType(element.asType());
    }

    public static boolean isInterfaceType(TypeMirror type) {
        DeclaredType declaredType = TypeUtils.ofDeclaredType(type);
        return declaredType != null && TypeUtils.isInterfaceType(declaredType.asElement());
    }

    public static boolean isInterfaceType(Element element) {
        return element != null && ElementKind.INTERFACE == element.getKind();
    }

    public static boolean isAnnotationType(TypeMirror type) {
        DeclaredType declaredType = TypeUtils.ofDeclaredType(type);
        return declaredType != null && TypeUtils.isAnnotationType(declaredType.asElement());
    }

    public static boolean isAnnotationType(Element element) {
        return element != null && ElementKind.ANNOTATION_TYPE == element.getKind();
    }

    public static boolean isTypeElement(Element element) {
        return element instanceof TypeElement;
    }

    public static boolean isTypeElement(TypeMirror type) {
        DeclaredType declaredType = TypeUtils.ofDeclaredType(type);
        return declaredType != null && TypeUtils.isTypeElement(declaredType.asElement());
    }

    public static boolean isDeclaredType(Element element) {
        return element != null && TypeUtils.isDeclaredType(element.asType());
    }

    public static boolean isDeclaredType(TypeMirror type) {
        return type instanceof DeclaredType;
    }

    public static TypeElement ofTypeElement(Element element) {
        return TypeUtils.isTypeElement(element) ? (TypeElement)element : null;
    }

    @Nullable
    public static TypeElement ofTypeElement(TypeMirror type) {
        DeclaredType declaredType = TypeUtils.ofDeclaredType(type);
        return TypeUtils.ofTypeElement(declaredType);
    }

    @Nullable
    public static TypeElement ofTypeElement(DeclaredType declaredType) {
        if (declaredType != null) {
            return TypeUtils.ofTypeElement(declaredType.asElement());
        }
        return null;
    }

    @Nullable
    public static DeclaredType ofDeclaredType(Element element) {
        return element == null ? null : TypeUtils.ofDeclaredType(element.asType());
    }

    @Nullable
    public static DeclaredType ofDeclaredType(TypeMirror type) {
        return TypeUtils.isDeclaredType(type) ? (DeclaredType)type : null;
    }

    @Nonnull
    @Immutable
    public static List<TypeMirror> ofTypeMirrors(Element ... elements) {
        return TypeUtils.ofTypeMirrors(Lists.ofList(elements));
    }

    @Nonnull
    @Immutable
    public static List<TypeMirror> ofTypeMirrors(Collection<? extends Element> elements) {
        return TypeUtils.ofTypeMirrors(elements, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<TypeMirror> ofTypeMirrors(Collection<? extends Element> elements, Predicate<? super TypeMirror> ... typeFilters) {
        return CollectionUtils.isEmpty(elements) ? Collections.emptyList() : Collections.unmodifiableList(elements.stream().map(Element::asType).filter(Predicates.and(typeFilters)).collect(Collectors.toList()));
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> ofTypeElements(TypeMirror ... types) {
        return TypeUtils.ofTypeElements(Lists.ofList(types));
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> ofTypeElements(Collection<? extends TypeMirror> types) {
        return TypeUtils.ofTypeElements(types, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> ofTypeElements(Collection<? extends TypeMirror> types, Predicate<? super TypeElement> ... typeFilters) {
        return CollectionUtils.isEmpty(types) ? Collections.emptyList() : Collections.unmodifiableList(types.stream().map(TypeUtils::ofTypeElement).filter(Objects::nonNull).filter(Predicates.and(typeFilters)).collect(Collectors.toList()));
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> ofDeclaredTypes(Element ... elements) {
        return TypeUtils.ofDeclaredTypes(Lists.ofList(elements));
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> ofDeclaredTypes(Collection<? extends Element> elements) {
        return TypeUtils.ofDeclaredTypes(elements, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> ofDeclaredTypes(Collection<? extends Element> elements, Predicate<? super DeclaredType> ... typeFilters) {
        if (CollectionUtils.isEmpty(elements)) {
            return Collections.emptyList();
        }
        List declaredTypes = elements.stream().map(TypeUtils::ofTypeElement).filter(Objects::nonNull).map(Element::asType).map(TypeUtils::ofDeclaredType).filter(Objects::nonNull).filter(Predicates.and(typeFilters)).collect(Collectors.toList());
        return declaredTypes.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(declaredTypes);
    }

    @Nullable
    public static TypeElement getTypeElementOfSuperclass(TypeElement type) {
        return type == null ? null : TypeUtils.ofTypeElement(type.getSuperclass());
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> getAllTypeElementsOfSuperTypes(TypeElement type) {
        return TypeUtils.findAllTypeElementsOfSuperTypes(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> getAllTypeElementsOfSuperclasses(TypeElement type) {
        return TypeUtils.findAllTypeElementsOfSuperclasses(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> getTypeElementsOfInterfaces(TypeElement type) {
        return TypeUtils.findTypeElementsOfInterfaces(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> getAllTypeElementsOfInterfaces(TypeElement type) {
        return TypeUtils.findAllTypeElementsOfInterfaces(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> getTypeElements(TypeElement type) {
        return TypeUtils.getTypeElements(type, true, false, true, true);
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> getAllTypeElements(TypeElement type) {
        return TypeUtils.getTypeElements(type, true, true, true, true);
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> getTypeElements(TypeElement type, boolean includeSelf, boolean includeHierarchicalTypes, boolean includeSuperClasses, boolean includeSuperInterfaces) {
        return TypeUtils.findTypeElements(type, includeSelf, includeHierarchicalTypes, includeSuperClasses, includeSuperInterfaces, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> findTypeElementsOfInterfaces(TypeElement type, Predicate<? super TypeElement> ... interfaceFilters) {
        return TypeUtils.findTypeElements(type, false, false, false, true, interfaceFilters);
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> findAllTypeElementsOfSuperclasses(TypeElement type, Predicate<? super TypeElement> ... typeFilters) {
        return TypeUtils.findTypeElements(type, false, true, true, false, typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> findAllTypeElementsOfInterfaces(TypeElement type, Predicate<? super TypeElement> ... interfaceFilters) {
        return TypeUtils.findTypeElements(type, false, true, false, true, interfaceFilters);
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> findAllTypeElementsOfSuperTypes(TypeElement type, Predicate<? super TypeElement> ... typeFilters) {
        return TypeUtils.findTypeElements(type, false, true, true, true, typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> findTypeElements(TypeElement type, boolean includeSelf, boolean includeHierarchicalTypes, boolean includeSuperclass, boolean includeSuperInterfaces, Predicate<? super TypeElement> ... typeFilters) throws IllegalArgumentException {
        if (type == null) {
            return Collections.emptyList();
        }
        Assert.assertNoNullElements((Object[])typeFilters, () -> "Any element of 'typeFilters' array must not be null");
        return TypeUtils.typeElementFinder(type, includeSelf, includeHierarchicalTypes, includeSuperclass, includeSuperInterfaces).findTypes(typeFilters);
    }

    @Nullable
    public static DeclaredType getDeclaredTypeOfSuperclass(Element typeElement) {
        return typeElement == null ? null : TypeUtils.getDeclaredTypeOfSuperclass(typeElement.asType());
    }

    @Nullable
    public static DeclaredType getDeclaredTypeOfSuperclass(TypeMirror type) {
        TypeElement superType = TypeUtils.getTypeElementOfSuperclass(TypeUtils.ofTypeElement(type));
        return superType == null ? null : TypeUtils.ofDeclaredType(superType.asType());
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> getDeclaredTypesOfInterfaces(Element element) {
        return element == null ? Collections.emptyList() : TypeUtils.findDeclaredTypesOfInterfaces(element.asType(), Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> getDeclaredTypesOfInterfaces(TypeMirror type) {
        return TypeUtils.findDeclaredTypesOfInterfaces(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> getAllDeclaredTypesOfSuperclasses(Element type) {
        return type == null ? Collections.emptyList() : TypeUtils.findAllDeclaredTypesOfSuperclasses(type.asType(), Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> getAllDeclaredTypesOfSuperclasses(TypeMirror type) {
        return TypeUtils.findAllDeclaredTypesOfSuperclasses(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> getAllDeclaredTypesOfInterfaces(Element type) {
        return type == null ? Collections.emptyList() : TypeUtils.findAllDeclaredTypesOfInterfaces(type.asType(), Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> getAllDeclaredTypesOfInterfaces(TypeMirror type) {
        return TypeUtils.findAllDeclaredTypesOfInterfaces(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> getAllDeclaredTypesOfSuperTypes(Element type) {
        return type == null ? Collections.emptyList() : TypeUtils.findAllDeclaredTypesOfSuperTypes(type.asType(), Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> getAllDeclaredTypesOfSuperTypes(TypeMirror type) {
        return TypeUtils.findAllDeclaredTypesOfSuperTypes(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> getAllDeclaredTypes(Element type) {
        return type == null ? Collections.emptyList() : TypeUtils.findAllDeclaredTypes(type.asType(), Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> getAllDeclaredTypes(TypeMirror type) {
        return TypeUtils.findAllDeclaredTypes(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> getDeclaredTypes(Element type, boolean includeSelf, boolean includeHierarchicalTypes, boolean includeSuperClasses, boolean includeSuperInterfaces) {
        return TypeUtils.getDeclaredTypes(type.asType(), includeSelf, includeHierarchicalTypes, includeSuperClasses, includeSuperInterfaces);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> getDeclaredTypes(TypeMirror type, boolean includeSelf, boolean includeHierarchicalTypes, boolean includeSuperClasses, boolean includeSuperInterfaces) {
        return TypeUtils.findDeclaredTypes(type, includeSelf, includeHierarchicalTypes, includeSuperClasses, includeSuperInterfaces, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findDeclaredTypes(TypeMirror type, Type ... excludedTypes) {
        return type == null ? Collections.emptyList() : TypeUtils.findDeclaredTypes((Element)TypeUtils.ofTypeElement(type), excludedTypes);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findDeclaredTypes(Element type, Type ... excludedTypes) {
        return type == null ? Collections.emptyList() : TypeUtils.findDeclaredTypes(type, (CharSequence[])io.microsphere.reflect.TypeUtils.getTypeNames(excludedTypes));
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findDeclaredTypes(TypeMirror type, CharSequence ... excludedTypeNames) {
        return type == null ? Collections.emptyList() : TypeUtils.findDeclaredTypes((Element)TypeUtils.ofTypeElement(type), excludedTypeNames);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findDeclaredTypes(Element type, CharSequence ... excludedTypeNames) {
        return type == null ? Collections.emptyList() : TypeUtils.findDeclaredTypes(type, false, false, true, true, t -> !ArrayUtils.contains(excludedTypeNames, t.toString()));
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findDeclaredTypesOfInterfaces(Element type, Predicate<? super DeclaredType> ... typeFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.findDeclaredTypesOfInterfaces(type.asType(), typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findDeclaredTypesOfInterfaces(TypeMirror type, Predicate<? super DeclaredType> ... typeFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.ofDeclaredTypes(TypeUtils.getTypeElementsOfInterfaces(TypeUtils.ofTypeElement(type)), typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findAllDeclaredTypesOfSuperclasses(Element type, Predicate<? super DeclaredType> ... typeFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.findAllDeclaredTypesOfSuperclasses(type.asType(), typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findAllDeclaredTypesOfSuperclasses(TypeMirror type, Predicate<? super DeclaredType> ... typeFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.ofDeclaredTypes(TypeUtils.getAllTypeElementsOfSuperclasses(TypeUtils.ofTypeElement(type)), typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findAllDeclaredTypesOfInterfaces(Element type, Predicate<? super DeclaredType> ... typeFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.findAllDeclaredTypesOfInterfaces(type.asType(), typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findAllDeclaredTypesOfInterfaces(TypeMirror type, Predicate<? super DeclaredType> ... typeFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.ofDeclaredTypes(TypeUtils.getAllTypeElementsOfInterfaces(TypeUtils.ofTypeElement(type)), typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findAllDeclaredTypesOfSuperTypes(Element type, Predicate<? super DeclaredType> ... typeFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.findAllDeclaredTypesOfSuperTypes(type.asType(), typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findAllDeclaredTypesOfSuperTypes(TypeMirror type, Predicate<? super DeclaredType> ... typeFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.ofDeclaredTypes(TypeUtils.getAllTypeElementsOfSuperTypes(TypeUtils.ofTypeElement(type)), typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findAllDeclaredTypes(TypeMirror type, Type ... excludedTypes) {
        return type == null ? Collections.emptyList() : TypeUtils.findAllDeclaredTypes((Element)TypeUtils.ofTypeElement(type), excludedTypes);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findAllDeclaredTypes(Element type, Type ... excludedTypes) {
        return type == null ? Collections.emptyList() : TypeUtils.findAllDeclaredTypes(type, (CharSequence[])io.microsphere.reflect.TypeUtils.getTypeNames(excludedTypes));
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findAllDeclaredTypes(TypeMirror type, CharSequence ... excludedTypeNames) {
        return type == null ? Collections.emptyList() : TypeUtils.findAllDeclaredTypes((Element)TypeUtils.ofTypeElement(type), excludedTypeNames);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findAllDeclaredTypes(Element type, CharSequence ... excludedTypeNames) {
        return type == null ? Collections.emptyList() : TypeUtils.findAllDeclaredTypes(type, t -> !ArrayUtils.contains(excludedTypeNames, t.toString()));
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findAllDeclaredTypes(Element type, Predicate<? super DeclaredType> ... typeFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.findAllDeclaredTypes(type.asType(), typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findAllDeclaredTypes(TypeMirror type, Predicate<? super DeclaredType> ... typeFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.ofDeclaredTypes(TypeUtils.getAllTypeElements(TypeUtils.ofTypeElement(type)), typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findDeclaredTypes(Element type, boolean includeSelf, boolean includeHierarchicalTypes, boolean includeSuperClasses, boolean includeSuperInterfaces, Predicate<? super DeclaredType> ... typeFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.findDeclaredTypes(type.asType(), includeSelf, includeHierarchicalTypes, includeSuperClasses, includeSuperInterfaces, typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<DeclaredType> findDeclaredTypes(TypeMirror type, boolean includeSelf, boolean includeHierarchicalTypes, boolean includeSuperClasses, boolean includeSuperInterfaces, Predicate<? super DeclaredType> ... typeFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.ofDeclaredTypes(TypeUtils.getTypeElements(TypeUtils.ofTypeElement(type), includeSelf, includeHierarchicalTypes, includeSuperClasses, includeSuperInterfaces), typeFilters);
    }

    @Nonnull
    @Immutable
    public static List<TypeMirror> getTypeMirrorsOfInterfaces(TypeMirror type) {
        return type == null ? Collections.emptyList() : TypeUtils.findTypeMirrorsOfInterfaces(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<TypeMirror> getTypeMirrorsOfInterfaces(TypeElement type) {
        return type == null ? Collections.emptyList() : TypeUtils.findTypeMirrorsOfInterfaces(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<TypeMirror> findTypeMirrorsOfInterfaces(TypeMirror type, Predicate<TypeMirror> ... interfaceFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.findTypeMirrorsOfInterfaces(TypeUtils.ofTypeElement(type), interfaceFilters);
    }

    @Nonnull
    @Immutable
    public static List<TypeMirror> findTypeMirrorsOfInterfaces(TypeElement type, Predicate<TypeMirror> ... interfaceFilters) {
        if (type == null) {
            return Collections.emptyList();
        }
        List typeMirrors = TypeUtils.getTypeElementsOfInterfaces(type).stream().map(Element::asType).filter(Predicates.and(interfaceFilters)).collect(Collectors.toList());
        return typeMirrors.isEmpty() ? Collections.emptyList() : typeMirrors;
    }

    @Nonnull
    @Immutable
    public static List<TypeMirror> getAllTypeMirrorsOfInterfaces(TypeMirror type) {
        return TypeUtils.findAllTypeMirrorsOfInterfaces(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<TypeMirror> getAllTypeMirrorsOfInterfaces(TypeElement type) {
        return TypeUtils.findAllTypeMirrorsOfInterfaces(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<TypeMirror> findAllTypeMirrorsOfInterfaces(TypeMirror type, Predicate<TypeMirror> ... interfaceFilters) {
        return type == null ? Collections.emptyList() : TypeUtils.findAllTypeMirrorsOfInterfaces(TypeUtils.ofTypeElement(type), interfaceFilters);
    }

    @Nonnull
    @Immutable
    public static List<TypeMirror> findAllTypeMirrorsOfInterfaces(TypeElement type, Predicate<TypeMirror> ... interfaceFilters) {
        if (type == null) {
            return Collections.emptyList();
        }
        List typeMirrors = TypeUtils.getAllTypeElementsOfInterfaces(type).stream().map(Element::asType).filter(Predicates.and(interfaceFilters)).collect(Collectors.toList());
        return typeMirrors.isEmpty() ? Collections.emptyList() : typeMirrors;
    }

    @Nullable
    public static TypeMirror findInterfaceTypeMirror(Element type, Type interfaceType) {
        return TypeUtils.findInterfaceTypeMirror(type, (CharSequence)interfaceType.getTypeName());
    }

    @Nullable
    public static TypeMirror findInterfaceTypeMirror(TypeMirror type, Type interfaceType) {
        return TypeUtils.findInterfaceTypeMirror(type, (CharSequence)interfaceType.getTypeName());
    }

    @Nullable
    public static TypeMirror findInterfaceTypeMirror(Element type, CharSequence interfaceClassName) {
        return type == null ? null : TypeUtils.findInterfaceTypeMirror(type.asType(), interfaceClassName);
    }

    @Nullable
    public static TypeMirror findInterfaceTypeMirror(TypeMirror type, CharSequence interfaceClassName) {
        return Streams.filterFirst(TypeUtils.getAllTypeMirrorsOfInterfaces(type), t -> TypeUtils.isSameType(t, interfaceClassName));
    }

    @Nonnull
    @Immutable
    public static List<TypeMirror> getTypeMirrors(ProcessingEnvironment processingEnv, Type ... types) {
        if (ArrayUtils.isEmpty(types)) {
            return Collections.emptyList();
        }
        List typeMirrors = Stream.of(types).filter(Objects::nonNull).map(t -> TypeUtils.getTypeMirror(processingEnv, t)).filter(Objects::nonNull).collect(Collectors.toList());
        return typeMirrors.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(typeMirrors);
    }

    @Nullable
    public static TypeMirror getTypeMirror(ProcessingEnvironment processingEnv, Type type) {
        TypeElement typeElement = TypeUtils.getTypeElement(processingEnv, type);
        return typeElement == null ? null : typeElement.asType();
    }

    @Nonnull
    @Immutable
    public static List<TypeElement> getTypeElements(ProcessingEnvironment processingEnv, Type ... types) {
        if (ArrayUtils.isEmpty(types)) {
            return Collections.emptyList();
        }
        List typeElements = Stream.of(types).filter(Objects::nonNull).map(t -> TypeUtils.getTypeElement(processingEnv, t)).filter(Objects::nonNull).collect(Collectors.toList());
        return typeElements.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(typeElements);
    }

    @Nullable
    public static TypeElement getTypeElement(ProcessingEnvironment processingEnv, Type type) {
        return type == null ? null : TypeUtils.getTypeElement(processingEnv, type.getTypeName());
    }

    @Nullable
    public static TypeElement getTypeElement(ProcessingEnvironment processingEnv, TypeMirror type) {
        return type == null ? null : TypeUtils.getTypeElement(processingEnv, type.toString());
    }

    @Nullable
    public static TypeElement getTypeElement(ProcessingEnvironment processingEnv, CharSequence typeName) {
        if (processingEnv == null || typeName == null) {
            return null;
        }
        Elements elements = processingEnv.getElementUtils();
        return elements.getTypeElement(typeName);
    }

    @Nullable
    public static DeclaredType getDeclaredType(ProcessingEnvironment processingEnv, Type type) {
        return type == null ? null : TypeUtils.getDeclaredType(processingEnv, type.getTypeName());
    }

    @Nullable
    public static DeclaredType getDeclaredType(ProcessingEnvironment processingEnv, TypeMirror type) {
        return type == null ? null : TypeUtils.getDeclaredType(processingEnv, type.toString());
    }

    @Nullable
    public static DeclaredType getDeclaredType(ProcessingEnvironment processingEnv, CharSequence typeName) {
        return TypeUtils.ofDeclaredType(TypeUtils.getTypeElement(processingEnv, typeName));
    }

    @Nullable
    public static String toString(TypeMirror type) {
        return TypeUtils.getTypeName(type);
    }

    @Nullable
    public static String getTypeName(TypeMirror type) {
        List typeMirrors;
        int size;
        List<? extends TypeParameterElement> typeParameterElements;
        int typeParameterElementsSize;
        if (type == null) {
            return null;
        }
        TypeElement element = TypeUtils.ofTypeElement(type);
        if (element != null && (typeParameterElementsSize = (typeParameterElements = element.getTypeParameters()).size()) > 0 && (size = (typeMirrors = (List)MethodUtils.invokeMethod((Object)type, "getTypeArguments", new Object[0])).size()) > 0) {
            StringBuilder typeBuilder = new StringBuilder(element.toString());
            typeBuilder.append('<').append(typeMirrors).append('>');
            return typeBuilder.toString();
        }
        return type.toString();
    }

    @Nonnull
    public static TypeFinder<TypeElement> typeElementFinder(TypeElement typeElement, boolean includeSelf, boolean includeHierarchicalTypes, boolean includeSuperclass, boolean includeInterfaces) {
        return new TypeFinder<TypeElement>(typeElement, TYPE_ELEMENT_GET_SUPERCLASS, TYPE_ELEMENT_GET_INTERFACES, includeSelf, includeHierarchicalTypes, includeSuperclass, includeInterfaces);
    }
}

