/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.beans;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.collection.MapUtils;
import io.microsphere.lang.function.ThrowableSupplier;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class BeanMetadata {
    private final Class<?> beanClass;
    private final BeanInfo beanInfo;
    private final Map<String, PropertyDescriptor> propertyDescriptorsMap;

    protected BeanMetadata(@Nonnull Class<?> beanClass) {
        this(ThrowableSupplier.execute(() -> Introspector.getBeanInfo(beanClass, Object.class)));
    }

    protected BeanMetadata(BeanInfo beanInfo) {
        this.beanInfo = beanInfo;
        this.propertyDescriptorsMap = BeanMetadata.buildPropertyDescriptorsMap(beanInfo);
        this.beanClass = beanInfo.getBeanDescriptor().getBeanClass();
    }

    @Nonnull
    @Immutable
    static Map<String, PropertyDescriptor> buildPropertyDescriptorsMap(BeanInfo beanInfo) {
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        int length = propertyDescriptors.length;
        Map<String, PropertyDescriptor> propertyDescriptorsMap = MapUtils.newFixedHashMap(length);
        for (int i = 0; i < length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            String propertyName = StringUtils.uncapitalize(propertyDescriptor.getName());
            propertyDescriptorsMap.put(propertyName, propertyDescriptor);
        }
        return Collections.unmodifiableMap(propertyDescriptorsMap);
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    @Nonnull
    @Immutable
    public Collection<PropertyDescriptor> getPropertyDescriptors() {
        return this.propertyDescriptorsMap.values();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.propertyDescriptorsMap.get(propertyName);
    }

    @Nonnull
    @Immutable
    public Map<String, PropertyDescriptor> getPropertyDescriptorsMap() {
        return this.propertyDescriptorsMap;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof BeanMetadata)) {
            return false;
        }
        BeanMetadata that = (BeanMetadata)o;
        return Objects.equals(this.getBeanClass(), that.getBeanClass());
    }

    public int hashCode() {
        return Objects.hashCode(this.getBeanClass());
    }

    public String toString() {
        return "BeanMetadata{beanClass='" + ClassUtils.getTypeName(this.beanClass) + "'}";
    }

    public static BeanMetadata of(@Nonnull Class<?> beanClass) throws RuntimeException {
        return new BeanMetadata(beanClass);
    }
}

