/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.beans;

import io.microsphere.annotation.ConfigurationProperty;
import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.beans.BeanMetadata;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.EnumerationUtils;
import io.microsphere.collection.ListUtils;
import io.microsphere.collection.MapUtils;
import io.microsphere.collection.QueueUtils;
import io.microsphere.collection.SetUtils;
import io.microsphere.lang.MutableInteger;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.AccessibleObjectUtils;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.Utils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public abstract class BeanUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtils.class);
    static final String DEFAULT_BEAN_PROPERTIES_MAX_RESOLVED_DEPTH_PROPERTY_VALUE = "100";
    public static final String BEAN_PROPERTIES_MAX_RESOLVED_DEPTH_PROPERTY_NAME = "microsphere.bean.properties.max-resolved-depth";
    public static final int DEFAULT_BEAN_PROPERTIES_MAX_RESOLVED_DEPTH = Integer.parseInt("100");
    @ConfigurationProperty(name="microsphere.bean.properties.max-resolved-depth", defaultValue="100", description="The maximum depth of resolving properties of a bean in order to avoid stack overflow, default is 100")
    public static final int BEAN_PROPERTIES_MAX_RESOLVED_DEPTH = Integer.getInteger("microsphere.bean.properties.max-resolved-depth", DEFAULT_BEAN_PROPERTIES_MAX_RESOLVED_DEPTH);
    static final String BEAN_METADATA_CACHE_SIZE_DEFAULT_PROPERTY_VALUE = "64";
    public static final int DEFAULT_BEAN_METADATA_CACHE_SIZE = Integer.parseInt("64");
    public static final String BEAN_METADATA_CACHE_SIZE_PROPERTY_NAME = "microsphere.bean.metadata.cache.size";
    @ConfigurationProperty(name="microsphere.bean.metadata.cache.size", defaultValue="64", description="The cache size of BeanMetadata, default is 64")
    public static final int BEAN_METADATA_CACHE_SIZE = Integer.getInteger("microsphere.bean.metadata.cache.size", DEFAULT_BEAN_METADATA_CACHE_SIZE);
    private static final ConcurrentMap<Class<?>, BeanMetadata> beanMetadataCache = MapUtils.newConcurrentHashMap(BEAN_METADATA_CACHE_SIZE);

    @Nonnull
    @Immutable
    public static Map<String, Object> resolvePropertiesAsMap(Object bean) {
        return BeanUtils.resolvePropertiesAsMap(bean, BEAN_PROPERTIES_MAX_RESOLVED_DEPTH);
    }

    @Nonnull
    @Immutable
    public static Map<String, Object> resolvePropertiesAsMap(Object bean, int maxResolvedDepth) {
        return BeanUtils.resolvePropertiesAsMap(bean, MutableInteger.of(0), maxResolvedDepth);
    }

    @Nonnull
    public static BeanMetadata getBeanMetadata(Class<?> beanClass) throws RuntimeException {
        return beanMetadataCache.computeIfAbsent(beanClass, BeanMetadata::of);
    }

    public static Method findWriteMethod(BeanMetadata beanMetadata, String propertyName) {
        PropertyDescriptor propertyDescriptor = BeanUtils.findPropertyDescriptor(beanMetadata, propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (writeMethod == null && logger.isTraceEnabled()) {
            logger.trace("The property[name : '{}'] of Bean[class : '{}'] has no write method, skipping...", propertyName, ClassUtils.getTypeName(beanMetadata.getBeanClass()));
        }
        return writeMethod;
    }

    public static PropertyDescriptor findPropertyDescriptor(BeanMetadata beanMetadata, String propertyName) {
        PropertyDescriptor propertyDescriptor = beanMetadata.getPropertyDescriptor(propertyName);
        if (propertyDescriptor == null && logger.isTraceEnabled()) {
            logger.trace("The property[name : '{}'] of Bean[class : '{}'] has no property descriptor, skipping...", propertyName, ClassUtils.getTypeName(beanMetadata.getBeanClass()));
        }
        return propertyDescriptor;
    }

    @Nonnull
    @Immutable
    protected static Map<String, Object> resolvePropertiesAsMap(Object bean, MutableInteger resolvedDepth, int maxResolvedDepth) {
        if (bean == null) {
            return Collections.emptyMap();
        }
        if (resolvedDepth.incrementAndGet() >= maxResolvedDepth) {
            return Collections.emptyMap();
        }
        Class<?> beanClass = bean.getClass();
        BeanMetadata beanMetadata = BeanUtils.getBeanMetadata(beanClass);
        Map<String, PropertyDescriptor> propertyDescriptorsMap = beanMetadata.getPropertyDescriptorsMap();
        Map<String, Object> propertiesMap = MapUtils.newFixedHashMap(propertyDescriptorsMap.size());
        for (Map.Entry<String, PropertyDescriptor> entry : propertyDescriptorsMap.entrySet()) {
            String propertyName = entry.getKey();
            PropertyDescriptor propertyDescriptor = entry.getValue();
            Object propertyValue = BeanUtils.resolveProperty(bean, propertyDescriptor, resolvedDepth, maxResolvedDepth);
            propertiesMap.put(propertyName, propertyValue);
        }
        return Collections.unmodifiableMap(propertiesMap);
    }

    static Object resolveProperty(Object instance, PropertyDescriptor propertyDescriptor, MutableInteger resolvedDepth, int maxResolvedDepth) {
        Method readMethod = propertyDescriptor.getReadMethod();
        AccessibleObjectUtils.trySetAccessible(readMethod);
        Object propertyValue = MethodUtils.invokeMethod(instance, readMethod, new Object[0]);
        Class<?> propertyType = propertyDescriptor.getPropertyType();
        return BeanUtils.resolveProperty(propertyValue, propertyType, resolvedDepth, maxResolvedDepth);
    }

    static Object resolveProperty(Object value, MutableInteger resolvedDepth, int maxResolvedDepth) {
        return BeanUtils.resolveProperty(value, value == null ? null : value.getClass(), resolvedDepth, maxResolvedDepth);
    }

    static Object resolveProperty(Object value, Class<?> valueType, MutableInteger resolvedDepth, int maxResolvedDepth) {
        if (value == null) {
            return null;
        }
        if (valueType.isPrimitive() || ClassUtils.isSimpleType(valueType) || ClassUtils.isCharSequence(valueType) || ClassUtils.isNumber(valueType) || valueType.isEnum() || ClassUtils.isClass(value)) {
            return value;
        }
        if (valueType.isArray()) {
            return BeanUtils.toArray(value, valueType, resolvedDepth, maxResolvedDepth);
        }
        if (ListUtils.isList(valueType)) {
            return BeanUtils.toList(value, valueType, resolvedDepth, maxResolvedDepth);
        }
        if (SetUtils.isSet(valueType)) {
            return BeanUtils.toSet(value, valueType, resolvedDepth, maxResolvedDepth);
        }
        if (QueueUtils.isQueue(valueType)) {
            return BeanUtils.toQueue(value, valueType, resolvedDepth, maxResolvedDepth);
        }
        if (EnumerationUtils.isEnumeration(valueType)) {
            return BeanUtils.toEnumeration(value, valueType, resolvedDepth, maxResolvedDepth);
        }
        if (MapUtils.isMap(valueType)) {
            return BeanUtils.toMap(value, valueType, resolvedDepth, maxResolvedDepth);
        }
        return BeanUtils.resolvePropertiesAsMap(value, resolvedDepth, maxResolvedDepth);
    }

    static Object toArray(Object value, Class<?> valueType, MutableInteger resolvedDepth, int maxResolvedDepth) {
        int length = Array.getLength(value);
        Object newArray = Array.newInstance(Object.class, length);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(value, i);
            Array.set(newArray, i, BeanUtils.resolveProperty(element, valueType.getComponentType(), resolvedDepth, maxResolvedDepth));
        }
        return newArray;
    }

    static List<?> toList(Object value, Class<?> valueType, MutableInteger resolvedDepth, int maxResolvedDepth) {
        List list = (List)value;
        ArrayList<Object> newList = ListUtils.newArrayList(CollectionUtils.size(list));
        BeanUtils.addValues(newList, list, resolvedDepth, maxResolvedDepth);
        return newList;
    }

    static Set<?> toSet(Object value, Class<?> valueType, MutableInteger resolvedDepth, int maxResolvedDepth) {
        Set set = (Set)value;
        Set<Object> newSet = SetUtils.newFixedLinkedHashSet(CollectionUtils.size(set));
        BeanUtils.addValues(newSet, set, resolvedDepth, maxResolvedDepth);
        return newSet;
    }

    static Queue<?> toQueue(Object value, Class<?> valueType, MutableInteger resolvedDepth, int maxResolvedDepth) {
        Queue queue = (Queue)value;
        ArrayDeque<Object> newQueue = QueueUtils.newArrayDeque(CollectionUtils.size(queue));
        BeanUtils.addValues(newQueue, queue, resolvedDepth, maxResolvedDepth);
        return newQueue;
    }

    static Enumeration<?> toEnumeration(Object value, Class<?> valueType, MutableInteger resolvedDepth, int maxResolvedDepth) {
        Enumeration enumeration = (Enumeration)value;
        LinkedList<Object> newList = ListUtils.newLinkedList();
        BeanUtils.addValues(newList, CollectionUtils.toIterable(enumeration), resolvedDepth, maxResolvedDepth);
        return Collections.enumeration(newList);
    }

    static Object toMap(Object value, Class<?> valueType, MutableInteger resolvedDepth, int maxResolvedDepth) {
        Map map = (Map)value;
        Map newMap = MapUtils.newFixedLinkedHashMap(MapUtils.size(map));
        for (Map.Entry entry : map.entrySet()) {
            newMap.put(entry.getKey(), BeanUtils.resolveProperty(entry.getValue(), resolvedDepth, maxResolvedDepth));
        }
        return newMap;
    }

    static void addValues(Collection<Object> targetValues, Iterable<?> sourceValues, MutableInteger resolvedDepth, int maxResolvedDepth) {
        for (Object value : sourceValues) {
            Object resolvedValue = BeanUtils.resolveProperty(value, resolvedDepth, maxResolvedDepth);
            targetValues.add(resolvedValue);
        }
    }

    private BeanUtils() {
    }
}

