/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.beans;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.SetUtils;
import io.microsphere.util.Assert;
import io.microsphere.util.ClassUtils;
import java.util.Objects;
import java.util.Set;

public class ConfigurationProperty {
    @Nonnull
    private final String name;
    @Nonnull
    private String type;
    @Nullable
    private Object value;
    @Nullable
    private Object defaultValue;
    private boolean required;
    @Nullable
    private String description;
    @Nonnull
    private final Metadata metadata;

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ConfigurationProperty(String name) {
        this(name, String.class);
    }

    public ConfigurationProperty(String name, Class<?> type) {
        Assert.assertNotNull((Object)name, () -> "the property name must not null");
        this.name = name;
        this.setType(type);
        this.metadata = new Metadata();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public void setType(@Nonnull Class<?> type) {
        Assert.assertNotNull(type, () -> "the property type must not null");
        this.setType(ClassUtils.getTypeName(type));
    }

    public void setType(String type) {
        Assert.assertNotEmpty(type, () -> "the property type must not null");
        this.type = type;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public void setValue(@Nullable Object value) {
        this.value = value;
    }

    @Nullable
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(@Nullable Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Nonnull
    public Metadata getMetadata() {
        return this.metadata;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ConfigurationProperty)) {
            return false;
        }
        ConfigurationProperty that = (ConfigurationProperty)o;
        return this.isRequired() == that.isRequired() && this.getName().equals(that.getName()) && this.getType().equals(that.getType()) && Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getDefaultValue(), that.getDefaultValue()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getMetadata(), that.getMetadata());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + Objects.hashCode(this.getValue());
        result = 31 * result + Objects.hashCode(this.getDefaultValue());
        result = 31 * result + Objects.hashCode(this.getDescription());
        result = 31 * result + Boolean.hashCode(this.isRequired());
        result = 31 * result + Objects.hashCode(this.getMetadata());
        return result;
    }

    public String toString() {
        return "ConfigurationProperty{name='" + this.name + '\'' + ", type=" + this.type + ", value=" + this.value + ", defaultValue=" + this.defaultValue + ", required=" + this.required + ", metadata=" + this.metadata + '}';
    }

    public static class Metadata {
        private Set<String> sources;
        private Set<String> targets;
        private String declaredClass;
        private String declaredField;

        @Nonnull
        public Set<String> getSources() {
            if (this.sources == null) {
                this.sources = SetUtils.newLinkedHashSet(2);
            }
            return this.sources;
        }

        @Nonnull
        public Set<String> getTargets() {
            if (this.targets == null) {
                this.targets = SetUtils.newLinkedHashSet(2);
            }
            return this.targets;
        }

        @Nullable
        public String getDeclaredClass() {
            return this.declaredClass;
        }

        @Nullable
        public String getDeclaredField() {
            return this.declaredField;
        }

        public void setDeclaredClass(@Nullable String declaredClass) {
            this.declaredClass = declaredClass;
        }

        public void setDeclaredField(@Nullable String declaredField) {
            this.declaredField = declaredField;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Metadata)) {
                return false;
            }
            Metadata metadata = (Metadata)o;
            return Objects.equals(this.getSources(), metadata.getSources()) && Objects.equals(this.getTargets(), metadata.getTargets()) && Objects.equals(this.getDeclaredClass(), metadata.getDeclaredClass()) && Objects.equals(this.getDeclaredField(), metadata.getDeclaredField());
        }

        public int hashCode() {
            int result = Objects.hashCode(this.getSources());
            result = 31 * result + Objects.hashCode(this.getTargets());
            result = 31 * result + Objects.hashCode(this.getDeclaredClass());
            result = 31 * result + Objects.hashCode(this.getDeclaredField());
            return result;
        }

        public String toString() {
            return "Metadata{sources=" + this.getSources() + ", targets=" + this.getTargets() + ", declaredClass='" + this.declaredClass + '\'' + ", declaredField='" + this.declaredField + '\'' + '}';
        }
    }
}

