/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.classloading;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.classloading.Artifact;
import java.net.URL;
import java.util.Objects;

@Immutable
public class MavenArtifact
extends Artifact {
    @Nonnull
    private final String groupId;

    public MavenArtifact(@Nonnull String groupId, @Nonnull String artifactId, @Nullable String version, @Nullable URL location) {
        super(artifactId, version, location);
        this.groupId = groupId;
    }

    public static MavenArtifact create(@Nonnull String groupId, @Nonnull String artifactId, @Nullable String version, @Nullable URL location) {
        return new MavenArtifact(groupId, artifactId, version, location);
    }

    public static MavenArtifact create(@Nonnull String groupId, @Nonnull String artifactId, @Nullable String version) {
        return MavenArtifact.create(groupId, artifactId, version, null);
    }

    public static MavenArtifact create(@Nonnull String groupId, @Nonnull String artifactId) {
        return MavenArtifact.create(groupId, artifactId, "?");
    }

    @Nonnull
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public boolean matches(Artifact artifact) {
        return this.matchesGroupId(artifact) && super.matches(artifact);
    }

    private boolean matchesGroupId(Artifact artifact) {
        return this.matches(artifact, this::getGroupId);
    }

    private String getGroupId(Artifact artifact) {
        if (artifact instanceof MavenArtifact) {
            return ((MavenArtifact)artifact).getGroupId();
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MavenArtifact)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MavenArtifact that = (MavenArtifact)o;
        return Objects.equals(this.groupId, that.groupId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.groupId);
    }

    @Override
    public String toString() {
        String sb = "MavenArtifact{groupId='" + this.groupId + '\'' + ", artifactId='" + this.getArtifactId() + '\'' + ", version='" + this.getVersion() + '\'' + ", location='" + this.getLocation() + '\'' + '}';
        return sb;
    }
}

