/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.classloading;

import io.microsphere.annotation.Nullable;
import io.microsphere.classloading.AbstractArtifactResourceResolver;
import io.microsphere.classloading.Artifact;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.ListUtils;
import io.microsphere.io.FileUtils;
import io.microsphere.io.IOUtils;
import io.microsphere.io.scanner.SimpleFileScanner;
import io.microsphere.net.URLUtils;
import io.microsphere.util.Assert;
import io.microsphere.util.jar.JarUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class StreamArtifactResourceResolver
extends AbstractArtifactResourceResolver {
    public StreamArtifactResourceResolver(int priority) {
        super(priority);
    }

    public StreamArtifactResourceResolver(ClassLoader classLoader, int priority) {
        super(classLoader, priority);
        Assert.assertNotNull((Object)classLoader, () -> "The 'classLoader' must not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Artifact resolve(URL resourceURL) {
        Artifact artifact;
        InputStream artifactMetadataData;
        block8: {
            if (resourceURL == null) {
                return null;
            }
            File archiveFile = URLUtils.resolveArchiveFile(resourceURL);
            artifactMetadataData = null;
            artifact = null;
            try {
                if (archiveFile == null) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("The resourceURL['{}'] can't be resolved to be an archive file", resourceURL);
                    }
                    artifactMetadataData = this.readArtifactMetadataDataFromResource(resourceURL, this.classLoader);
                } else {
                    artifactMetadataData = this.readArtifactMetadataDataFromArchiveFile(archiveFile);
                }
                if (artifactMetadataData == null) break block8;
                artifact = this.resolve(resourceURL, artifactMetadataData, this.classLoader);
            }
            catch (IOException e) {
                block9: {
                    try {
                        if (!this.logger.isErrorEnabled()) break block9;
                        this.logger.error("The Artifact can't be resolved from the resource URL : {}", resourceURL, e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(artifactMetadataData);
                        throw throwable;
                    }
                }
                IOUtils.close(artifactMetadataData);
            }
        }
        IOUtils.close(artifactMetadataData);
        return artifact;
    }

    @Nullable
    protected InputStream readArtifactMetadataDataFromResource(URL resourceURL, ClassLoader classLoader) throws IOException {
        return null;
    }

    @Nullable
    protected InputStream readArtifactMetadataDataFromArchiveFile(File archiveFile) throws IOException {
        InputStream artifactMetadataData = null;
        if (archiveFile.isFile()) {
            artifactMetadataData = this.readArtifactMetadataDataFromFile(archiveFile);
        } else if (archiveFile.isDirectory()) {
            artifactMetadataData = this.readArtifactMetadataDataFromDirectory(archiveFile);
        }
        return artifactMetadataData;
    }

    @Nullable
    protected InputStream readArtifactMetadataDataFromFile(File archiveFile) throws IOException {
        JarFile jarFile = new JarFile(archiveFile);
        JarEntry jarEntry = this.findArtifactMetadataEntry(jarFile);
        if (jarEntry == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("The artifact metadata entry can't be resolved from the JarFile[path: '{}']", archiveFile);
            }
            return null;
        }
        return jarFile.getInputStream(jarEntry);
    }

    @Nullable
    protected InputStream readArtifactMetadataDataFromDirectory(File directory) throws IOException {
        File artifactMetadataFile = this.findArtifactMetadata(directory);
        if (artifactMetadataFile == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("The artifact metadata file can't be found in the directory[path: '{}']", directory);
            }
            return null;
        }
        return new FileInputStream(artifactMetadataFile);
    }

    protected JarEntry findArtifactMetadataEntry(JarFile jarFile) throws IOException {
        List<JarEntry> entries = JarUtils.filter(jarFile, this::isArtifactMetadataEntry);
        return ListUtils.first(entries);
    }

    protected File findArtifactMetadata(File directory) throws IOException {
        Set<File> files = SimpleFileScanner.INSTANCE.scan(directory, true, file -> this.isArtifactMetadataFile(directory, file));
        return CollectionUtils.first(files);
    }

    protected boolean isArtifactMetadataEntry(JarEntry jarEntry) {
        return this.isArtifactMetadata(jarEntry.getName());
    }

    protected boolean isArtifactMetadataFile(File directory, File file) {
        String path = FileUtils.resolveRelativePath(directory, file);
        return this.isArtifactMetadata(path);
    }

    protected abstract boolean isArtifactMetadata(String var1);

    protected abstract Artifact resolve(URL var1, InputStream var2, ClassLoader var3) throws IOException;
}

