/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;

public class ArrayEnumeration<E>
implements Enumeration<E> {
    private final E[] elements;
    private final int size;
    private int position;

    public ArrayEnumeration(E[] elements) {
        this.elements = elements;
        this.size = elements.length;
        this.position = 0;
    }

    @Override
    public boolean hasMoreElements() {
        return this.position < this.size;
    }

    @Override
    public E nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException("No more elements exist");
        }
        return this.elements[this.position++];
    }

    public int hashCode() {
        return Objects.hash(this.elements);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ArrayEnumeration)) {
            return false;
        }
        ArrayEnumeration that = (ArrayEnumeration)o;
        return Arrays.equals(this.elements, that.elements);
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", "[", "]");
        for (E element : this.elements) {
            stringJoiner.add(String.valueOf(element));
        }
        return stringJoiner.toString();
    }
}

