/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import java.util.Map;
import java.util.Objects;

public class DefaultEntry<K, V>
implements Map.Entry<K, V> {
    private final K key;
    private V value;

    public DefaultEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> DefaultEntry<K, V> of(K key, V value) {
        return new DefaultEntry<K, V>(key, value);
    }

    @Override
    public final K getKey() {
        return this.key;
    }

    @Override
    public final V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        V oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultEntry)) {
            return false;
        }
        DefaultEntry that = (DefaultEntry)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        int result = Objects.hashCode(this.key);
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

