/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.ArrayEnumeration;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.Utils;
import java.util.Enumeration;

public abstract class EnumerationUtils
implements Utils {
    public static boolean isEnumeration(@Nullable Object values) {
        return values instanceof Enumeration;
    }

    public static boolean isEnumeration(@Nullable Class<?> type) {
        return ClassUtils.isAssignableFrom(Enumeration.class, type);
    }

    @Nonnull
    public static <E> Enumeration<E> of(E ... elements) {
        return EnumerationUtils.ofEnumeration(elements);
    }

    @Nonnull
    public static <E> Enumeration<E> ofEnumeration(E ... elements) {
        return new ArrayEnumeration<E>(elements);
    }

    private EnumerationUtils() {
    }
}

