/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Assert;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class ListUtils
implements Utils {
    public static boolean isList(@Nullable Object values) {
        return values instanceof List;
    }

    public static boolean isList(@Nullable Class<?> type) {
        return ClassUtils.isAssignableFrom(List.class, type);
    }

    @Nullable
    public static <E> E first(List<E> list) {
        return CollectionUtils.size(list) < 1 ? null : (E)list.get(0);
    }

    @Nullable
    public static <E> E last(List<E> list) {
        int size = CollectionUtils.size(list);
        return size < 1 ? null : (E)list.get(size - 1);
    }

    @Nonnull
    @Immutable
    public static <E> List<E> of(E ... elements) {
        return ListUtils.ofList(elements);
    }

    @Nonnull
    @Immutable
    public static <E> List<E> ofList(E ... elements) {
        if (ArrayUtils.isEmpty(elements)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    @Nonnull
    @Immutable
    public static <E> List<E> ofList(Iterable<E> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        if (ListUtils.isList(iterable)) {
            return Collections.unmodifiableList((List)iterable);
        }
        return ListUtils.ofList(iterable.iterator());
    }

    @Nonnull
    @Immutable
    public static <E> List<E> ofList(Enumeration<E> enumeration) {
        return ListUtils.ofList(CollectionUtils.toIterator(enumeration));
    }

    @Nonnull
    @Immutable
    public static <E> List<E> ofList(Iterator<E> iterator) {
        if (iterator == null) {
            return Collections.emptyList();
        }
        LinkedList<E> list = ListUtils.newLinkedList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return Collections.unmodifiableList(list);
    }

    @Nonnull
    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    @Nonnull
    public static <E> ArrayList<E> newArrayList(int size) {
        return new ArrayList(size);
    }

    @Nonnull
    public static <E> ArrayList<E> newArrayList(Enumeration<E> values) {
        return ListUtils.newArrayList(CollectionUtils.toIterable(values));
    }

    @Nonnull
    public static <E> ArrayList<E> newArrayList(Iterable<E> values) {
        return ListUtils.newArrayList(values.iterator());
    }

    @Nonnull
    public static <E> ArrayList<E> newArrayList(Iterator<E> iterator) {
        ArrayList<E> list = ListUtils.newArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    @Nonnull
    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    @Nonnull
    public static <E> LinkedList<E> newLinkedList(Enumeration<E> values) {
        return ListUtils.newLinkedList(CollectionUtils.toIterable(values));
    }

    public static <E> LinkedList<E> newLinkedList(Iterable<E> values) {
        return ListUtils.newLinkedList(values.iterator());
    }

    public static <E> LinkedList<E> newLinkedList(Iterator<E> iterator) {
        LinkedList<E> list = ListUtils.newLinkedList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <E> ArrayList<E> ofArrayList(E ... array) throws IllegalArgumentException {
        int length = ArrayUtils.length(array);
        Assert.assertTrue(length > 0, () -> "The array length must be greater than 0");
        ArrayList<E> list = ListUtils.newArrayList(length);
        for (int i = 0; i < length; ++i) {
            list.add(i, array[i]);
        }
        return list;
    }

    public static <E> LinkedList<E> ofLinkedList(E ... array) throws IllegalArgumentException {
        int length = ArrayUtils.length(array);
        Assert.assertTrue(length > 0, () -> "The array length must be greater than 0");
        LinkedList<E> list = ListUtils.newLinkedList();
        for (int i = 0; i < length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static <T> void forEach(List<T> values, BiConsumer<Integer, T> indexedElementConsumer) {
        int length = CollectionUtils.size(values);
        for (int i = 0; i < length; ++i) {
            T value = values.get(i);
            indexedElementConsumer.accept(i, (Integer)value);
        }
    }

    public static <T> void forEach(List<T> values, Consumer<T> consumer) {
        ListUtils.forEach(values, (Integer i, T e) -> consumer.accept(e));
    }

    private ListUtils() {
    }
}

