/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.collection.MapUtils;
import io.microsphere.util.Utils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class PropertiesUtils
implements Utils {
    @Nonnull
    @Immutable
    public static Map<String, Object> flatProperties(Map<String, Object> properties) {
        if (MapUtils.isEmpty(properties)) {
            return properties;
        }
        LinkedHashMap<String, Object> flattenProperties = new LinkedHashMap<String, Object>();
        PropertiesUtils.flatProperties(properties, null, flattenProperties);
        return Collections.unmodifiableMap(flattenProperties);
    }

    protected static void flatProperties(Map<String, Object> properties, String propertyNamePrefix, Map<String, Object> flattenProperties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String propertyName = PropertiesUtils.normalizePropertyName(propertyNamePrefix, entry.getKey());
            Object propertyValue = entry.getValue();
            if (propertyValue instanceof String) {
                flattenProperties.put(propertyName, propertyValue);
                continue;
            }
            if (!(propertyValue instanceof Map)) continue;
            Map subProperties = (Map)propertyValue;
            PropertiesUtils.flatProperties(subProperties, propertyName, flattenProperties);
        }
    }

    private static String normalizePropertyName(String propertyNamePrefix, String propertyName) {
        return propertyNamePrefix == null ? propertyName : propertyNamePrefix + "." + propertyName;
    }

    private PropertiesUtils() {
    }
}

