/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.EmptyDeque;
import io.microsphere.collection.ReversedDeque;
import io.microsphere.collection.SingletonDeque;
import io.microsphere.collection.UnmodifiableDeque;
import io.microsphere.collection.UnmodifiableQueue;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.Utils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Queue;

public abstract class QueueUtils
implements Utils {
    public static final Deque<?> EMPTY_DEQUE = EmptyDeque.INSTANCE;

    public static boolean isQueue(@Nullable Object values) {
        return values instanceof Queue;
    }

    public static boolean isQueue(@Nullable Class<?> type) {
        return ClassUtils.isAssignableFrom(Queue.class, type);
    }

    public static boolean isDeque(Iterable<?> values) {
        return values instanceof Deque;
    }

    @Nonnull
    @Immutable
    public static <E> Queue<E> emptyQueue() {
        return EMPTY_DEQUE;
    }

    @Nonnull
    @Immutable
    public static <E> Deque<E> emptyDeque() {
        return EMPTY_DEQUE;
    }

    @Nonnull
    public static <E> Queue<E> unmodifiableQueue(Queue<E> queue) {
        return new UnmodifiableQueue<E>(queue);
    }

    @Nonnull
    @Immutable
    public static <E> Deque<E> unmodifiableDeque(Deque<E> deque) {
        return new UnmodifiableDeque<E>(deque);
    }

    @Nonnull
    @Immutable
    public static <E> Queue<E> singletonQueue(E element) {
        return new SingletonDeque<E>(element);
    }

    @Nonnull
    @Immutable
    public static <E> Deque<E> singletonDeque(E element) {
        return new SingletonDeque<E>(element);
    }

    public static <E> Deque<E> reversedDeque(Deque<E> deque) {
        return ReversedDeque.of(deque);
    }

    @Nonnull
    @Immutable
    public static <E> Queue<E> ofQueue(E ... elements) {
        return QueueUtils.unmodifiableDeque(QueueUtils.newArrayDeque(elements));
    }

    @Nonnull
    public static <E> ArrayDeque<E> newArrayDeque() {
        return new ArrayDeque();
    }

    @Nonnull
    public static <E> ArrayDeque<E> newArrayDeque(int initialCapacity) {
        return new ArrayDeque(initialCapacity);
    }

    @Nonnull
    public static <E> ArrayDeque<E> newArrayDeque(E ... elements) {
        int length = ArrayUtils.length(elements);
        ArrayDeque<E> arrayDeque = QueueUtils.newArrayDeque(length);
        for (int i = 0; i < length; ++i) {
            arrayDeque.add(elements[i]);
        }
        return arrayDeque;
    }

    private QueueUtils() {
    }
}

