/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import io.microsphere.collection.DelegatingDeque;
import io.microsphere.util.ArrayUtils;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

public class ReversedDeque<E>
extends DelegatingDeque<E> {
    public ReversedDeque(Deque<E> delegate) {
        super(delegate);
    }

    public static <T> Deque<T> of(Deque<T> deque) {
        if (deque instanceof ReversedDeque) {
            return deque;
        }
        return new ReversedDeque<T>(deque);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        for (E e : this) {
            action.accept(e);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.getDelegate().descendingIterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 16);
    }

    @Override
    public boolean add(E e) {
        this.getDelegate().addFirst(e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            this.getDelegate().addFirst(e);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean remove(Object o) {
        Iterator<E> it = this.iterator();
        if (o == null) {
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
                return true;
            }
        } else {
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public Object[] toArray() {
        return ArrayUtils.reverse(super.toArray());
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return ArrayUtils.toArrayReversed(this.getDelegate(), a);
    }

    @Override
    public String toString() {
        Iterator<E> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection that = (Collection)o;
        if (that.size() != this.size()) {
            return false;
        }
        Iterator<E> iterator = this.iterator();
        Iterator otherIterator = ((Iterable)o).iterator();
        while (iterator.hasNext() && otherIterator.hasNext()) {
            if (Objects.equals(iterator.next(), otherIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public void addFirst(E e) {
        this.getDelegate().addLast(e);
    }

    @Override
    public void addLast(E e) {
        this.getDelegate().addFirst(e);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.getDelegate().iterator();
    }

    @Override
    public E element() {
        return this.getDelegate().getLast();
    }

    @Override
    public E getFirst() {
        return this.getDelegate().getLast();
    }

    @Override
    public E getLast() {
        return this.getDelegate().getFirst();
    }

    @Override
    public boolean offer(E e) {
        return this.getDelegate().offerFirst(e);
    }

    @Override
    public boolean offerFirst(E e) {
        return this.getDelegate().offerLast(e);
    }

    @Override
    public boolean offerLast(E e) {
        return this.getDelegate().offerFirst(e);
    }

    @Override
    public E peek() {
        return this.getDelegate().peekLast();
    }

    @Override
    public E peekFirst() {
        return this.getDelegate().peekLast();
    }

    @Override
    public E peekLast() {
        return this.getDelegate().peekFirst();
    }

    @Override
    public E poll() {
        return this.getDelegate().pollLast();
    }

    @Override
    public E pollFirst() {
        return this.getDelegate().pollLast();
    }

    @Override
    public E pollLast() {
        return this.getDelegate().pollFirst();
    }

    @Override
    public E pop() {
        return this.getDelegate().removeLast();
    }

    @Override
    public void push(E e) {
        this.getDelegate().addLast(e);
    }

    @Override
    public E remove() {
        return this.getDelegate().removeLast();
    }

    @Override
    public E removeFirst() {
        return this.getDelegate().removeLast();
    }

    @Override
    public E removeLast() {
        return this.getDelegate().removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.getDelegate().removeLastOccurrence(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.getDelegate().removeFirstOccurrence(o);
    }
}

