/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import io.microsphere.annotation.Immutable;
import io.microsphere.collection.AbstractDeque;
import io.microsphere.collection.CollectionUtils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;

@Immutable
public class SingletonDeque<E>
extends AbstractDeque<E>
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final E element;

    public SingletonDeque(E element) {
        this.element = element;
    }

    @Override
    public Iterator<E> iterator() {
        return CollectionUtils.singletonIterator(this.element);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return CollectionUtils.singletonIterator(this.element);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offerFirst(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offerLast(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E getFirst() {
        return this.element;
    }

    @Override
    public E getLast() {
        return this.element;
    }

    @Override
    public E peekFirst() {
        return this.element;
    }

    @Override
    public E peekLast() {
        return this.element;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public final boolean equals(Object o) {
        if (!(o instanceof SingletonDeque)) {
            return false;
        }
        SingletonDeque that = (SingletonDeque)o;
        return Objects.equals(this.element, that.element);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.element);
    }
}

