/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import io.microsphere.annotation.Immutable;
import io.microsphere.collection.ReadOnlyIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

@Immutable
public class SingletonIterator<E>
extends ReadOnlyIterator<E> {
    private final E element;
    private boolean hasNext = true;

    public SingletonIterator(E element) {
        this.element = element;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        if (this.hasNext) {
            this.hasNext = false;
            return this.element;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        if (this.hasNext) {
            action.accept(this.element);
            this.hasNext = false;
        }
    }
}

