/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.convert;

import io.microsphere.annotation.Nullable;
import io.microsphere.convert.Converters;
import io.microsphere.lang.Prioritized;
import io.microsphere.reflect.TypeUtils;
import io.microsphere.util.ClassUtils;

@FunctionalInterface
public interface Converter<S, T>
extends Prioritized {
    default public boolean accept(Class<?> sourceType, Class<?> targetType) {
        return ClassUtils.isAssignableFrom(this.getSourceType(), sourceType) && ClassUtils.isAssignableFrom(this.getTargetType(), targetType);
    }

    @Nullable
    public T convert(@Nullable S var1);

    default public Class<S> getSourceType() {
        return TypeUtils.resolveActualTypeArgumentClass(this.getClass(), Converter.class, 0);
    }

    default public Class<T> getTargetType() {
        return TypeUtils.resolveActualTypeArgumentClass(this.getClass(), Converter.class, 1);
    }

    public static <S, T> Converter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
        return Converters.findConverter(sourceType, targetType);
    }

    public static <T> T convertIfPossible(Object source, Class<T> targetType) {
        Converter<?, T> converter = Converter.getConverter(source.getClass(), targetType);
        if (converter != null) {
            return converter.convert(source);
        }
        return null;
    }
}

